/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.databasemanagement.model.DatabaseFleetHealthMetrics;
import com.oracle.bmc.databasemanagement.requests.GetDatabaseFleetHealthMetricsRequest;
import com.oracle.bmc.databasemanagement.responses.GetDatabaseFleetHealthMetricsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDatabaseFleetHealthMetricsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetDatabaseFleetHealthMetricsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetDatabaseFleetHealthMetricsRequest interceptRequest(GetDatabaseFleetHealthMetricsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetDatabaseFleetHealthMetricsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompareBaselineTime(), (String)"compareBaselineTime is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompareTargetTime(), (String)"compareTargetTime is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20201101").path("fleetMetrics");
        if (request.getManagedDatabaseGroupId() != null) {
            target = target.queryParam("managedDatabaseGroupId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getManagedDatabaseGroupId())});
        }
        if (request.getCompartmentId() != null) {
            target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        }
        target = target.queryParam("compareBaselineTime", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompareBaselineTime())});
        target = target.queryParam("compareTargetTime", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompareTargetTime())});
        if (request.getCompareType() != null) {
            target = target.queryParam("compareType", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompareType().getValue())});
        }
        if (request.getFilterByMetricNames() != null) {
            target = target.queryParam("filterByMetricNames", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getFilterByMetricNames())});
        }
        if (request.getFilterByDatabaseType() != null) {
            target = target.queryParam("filterByDatabaseType", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getFilterByDatabaseType())});
        }
        if (request.getFilterByDatabaseSubType() != null) {
            target = target.queryParam("filterByDatabaseSubType", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getFilterByDatabaseSubType())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetDatabaseFleetHealthMetricsResponse> fromResponse() {
        Function<Response, GetDatabaseFleetHealthMetricsResponse> transformer = new Function<Response, GetDatabaseFleetHealthMetricsResponse>(){

            public GetDatabaseFleetHealthMetricsResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.databasemanagement.responses.GetDatabaseFleetHealthMetricsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(DatabaseFleetHealthMetrics.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetDatabaseFleetHealthMetricsResponse.Builder builder = GetDatabaseFleetHealthMetricsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.databaseFleetHealthMetrics((DatabaseFleetHealthMetrics)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetDatabaseFleetHealthMetricsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

