/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.databasemanagement.model.DatabaseHomeMetrics;
import com.oracle.bmc.databasemanagement.requests.GetDatabaseHomeMetricsRequest;
import com.oracle.bmc.databasemanagement.responses.GetDatabaseHomeMetricsResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDatabaseHomeMetricsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetDatabaseHomeMetricsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetDatabaseHomeMetricsRequest interceptRequest(GetDatabaseHomeMetricsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetDatabaseHomeMetricsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getManagedDatabaseId(), (String)"managedDatabaseId is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getStartTime(), (String)"startTime is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getEndTime(), (String)"endTime is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20201101").path("databaseHomeMetrics");
        target = target.queryParam("managedDatabaseId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getManagedDatabaseId())});
        target = target.queryParam("startTime", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getStartTime())});
        target = target.queryParam("endTime", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getEndTime())});
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetDatabaseHomeMetricsResponse> fromResponse() {
        Function<Response, GetDatabaseHomeMetricsResponse> transformer = new Function<Response, GetDatabaseHomeMetricsResponse>(){

            public GetDatabaseHomeMetricsResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.databasemanagement.responses.GetDatabaseHomeMetricsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(DatabaseHomeMetrics.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetDatabaseHomeMetricsResponse.Builder builder = GetDatabaseHomeMetricsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.databaseHomeMetrics((DatabaseHomeMetrics)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetDatabaseHomeMetricsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

