/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.databasemanagement.requests.RemoveManagedDatabaseFromManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.responses.RemoveManagedDatabaseFromManagedDatabaseGroupResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveManagedDatabaseFromManagedDatabaseGroupConverter {
    private static final Logger LOG = LoggerFactory.getLogger(RemoveManagedDatabaseFromManagedDatabaseGroupConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static RemoveManagedDatabaseFromManagedDatabaseGroupRequest interceptRequest(RemoveManagedDatabaseFromManagedDatabaseGroupRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, RemoveManagedDatabaseFromManagedDatabaseGroupRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getManagedDatabaseGroupId(), (String)"managedDatabaseGroupId must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getRemoveManagedDatabaseFromManagedDatabaseGroupDetails(), (String)"removeManagedDatabaseFromManagedDatabaseGroupDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20201101").path("managedDatabaseGroups").path(HttpUtils.encodePathSegment((String)request.getManagedDatabaseGroupId())).path("actions").path("removeManagedDatabase");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, RemoveManagedDatabaseFromManagedDatabaseGroupResponse> fromResponse() {
        Function<Response, RemoveManagedDatabaseFromManagedDatabaseGroupResponse> transformer = new Function<Response, RemoveManagedDatabaseFromManagedDatabaseGroupResponse>(){

            public RemoveManagedDatabaseFromManagedDatabaseGroupResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.databasemanagement.responses.RemoveManagedDatabaseFromManagedDatabaseGroupResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create();
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                RemoveManagedDatabaseFromManagedDatabaseGroupResponse.Builder builder = RemoveManagedDatabaseFromManagedDatabaseGroupResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                RemoveManagedDatabaseFromManagedDatabaseGroupResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

