/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetManagedDatabaseGroupRequest
extends BmcRequest<Void> {
    private String managedDatabaseGroupId;
    private String opcRequestId;

    @ConstructorProperties(value={"managedDatabaseGroupId", "opcRequestId"})
    GetManagedDatabaseGroupRequest(String managedDatabaseGroupId, String opcRequestId) {
        this.managedDatabaseGroupId = managedDatabaseGroupId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getManagedDatabaseGroupId() {
        return this.managedDatabaseGroupId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetManagedDatabaseGroupRequest, Void> {
        private String managedDatabaseGroupId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetManagedDatabaseGroupRequest o) {
            this.managedDatabaseGroupId(o.getManagedDatabaseGroupId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetManagedDatabaseGroupRequest build() {
            GetManagedDatabaseGroupRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder managedDatabaseGroupId(String managedDatabaseGroupId) {
            this.managedDatabaseGroupId = managedDatabaseGroupId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetManagedDatabaseGroupRequest buildWithoutInvocationCallback() {
            return new GetManagedDatabaseGroupRequest(this.managedDatabaseGroupId, this.opcRequestId);
        }

        public String toString() {
            return "GetManagedDatabaseGroupRequest.Builder(managedDatabaseGroupId=" + this.managedDatabaseGroupId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

