/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetManagedDatabaseRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private String opcRequestId;

    @ConstructorProperties(value={"managedDatabaseId", "opcRequestId"})
    GetManagedDatabaseRequest(String managedDatabaseId, String opcRequestId) {
        this.managedDatabaseId = managedDatabaseId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetManagedDatabaseRequest, Void> {
        private String managedDatabaseId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetManagedDatabaseRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetManagedDatabaseRequest build() {
            GetManagedDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetManagedDatabaseRequest buildWithoutInvocationCallback() {
            return new GetManagedDatabaseRequest(this.managedDatabaseId, this.opcRequestId);
        }

        public String toString() {
            return "GetManagedDatabaseRequest.Builder(managedDatabaseId=" + this.managedDatabaseId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

