/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.databasemanagement.model.Job;
import com.oracle.bmc.databasemanagement.model.SortOrders;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListJobsRequest
extends BmcRequest<Void> {
    private String compartmentId;
    private String opcRequestId;
    private String id;
    private String managedDatabaseGroupId;
    private String managedDatabaseId;
    private String name;
    private Job.LifecycleState lifecycleState;
    private Integer limit;
    private String page;
    private SortBy sortBy;
    private SortOrders sortOrder;

    @ConstructorProperties(value={"compartmentId", "opcRequestId", "id", "managedDatabaseGroupId", "managedDatabaseId", "name", "lifecycleState", "limit", "page", "sortBy", "sortOrder"})
    ListJobsRequest(String compartmentId, String opcRequestId, String id, String managedDatabaseGroupId, String managedDatabaseId, String name, Job.LifecycleState lifecycleState, Integer limit, String page, SortBy sortBy, SortOrders sortOrder) {
        this.compartmentId = compartmentId;
        this.opcRequestId = opcRequestId;
        this.id = id;
        this.managedDatabaseGroupId = managedDatabaseGroupId;
        this.managedDatabaseId = managedDatabaseId;
        this.name = name;
        this.lifecycleState = lifecycleState;
        this.limit = limit;
        this.page = page;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getId() {
        return this.id;
    }

    public String getManagedDatabaseGroupId() {
        return this.managedDatabaseGroupId;
    }

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getName() {
        return this.name;
    }

    public Job.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrders getSortOrder() {
        return this.sortOrder;
    }

    public static class Builder
    implements BmcRequest.Builder<ListJobsRequest, Void> {
        private String compartmentId;
        private String opcRequestId;
        private String id;
        private String managedDatabaseGroupId;
        private String managedDatabaseId;
        private String name;
        private Job.LifecycleState lifecycleState;
        private Integer limit;
        private String page;
        private SortBy sortBy;
        private SortOrders sortOrder;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListJobsRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.id(o.getId());
            this.managedDatabaseGroupId(o.getManagedDatabaseGroupId());
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.name(o.getName());
            this.lifecycleState(o.getLifecycleState());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListJobsRequest build() {
            ListJobsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder managedDatabaseGroupId(String managedDatabaseGroupId) {
            this.managedDatabaseGroupId = managedDatabaseGroupId;
            return this;
        }

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder lifecycleState(Job.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrders sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public ListJobsRequest buildWithoutInvocationCallback() {
            return new ListJobsRequest(this.compartmentId, this.opcRequestId, this.id, this.managedDatabaseGroupId, this.managedDatabaseId, this.name, this.lifecycleState, this.limit, this.page, this.sortBy, this.sortOrder);
        }

        public String toString() {
            return "ListJobsRequest.Builder(compartmentId=" + this.compartmentId + ", opcRequestId=" + this.opcRequestId + ", id=" + this.id + ", managedDatabaseGroupId=" + this.managedDatabaseGroupId + ", managedDatabaseId=" + this.managedDatabaseId + ", name=" + this.name + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", limit=" + this.limit + ", page=" + this.page + ", sortBy=" + (Object)((Object)this.sortBy) + ", sortOrder=" + (Object)((Object)this.sortOrder) + ")";
        }
    }

    public static enum SortBy {
        Timecreated("TIMECREATED"),
        Name("NAME");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

