/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.databasemanagement.DbManagementAsync;
import com.oracle.bmc.databasemanagement.internal.http.AddManagedDatabaseToManagedDatabaseGroupConverter;
import com.oracle.bmc.databasemanagement.internal.http.ChangeJobCompartmentConverter;
import com.oracle.bmc.databasemanagement.internal.http.ChangeManagedDatabaseGroupCompartmentConverter;
import com.oracle.bmc.databasemanagement.internal.http.CreateJobConverter;
import com.oracle.bmc.databasemanagement.internal.http.CreateManagedDatabaseGroupConverter;
import com.oracle.bmc.databasemanagement.internal.http.DeleteJobConverter;
import com.oracle.bmc.databasemanagement.internal.http.DeleteManagedDatabaseGroupConverter;
import com.oracle.bmc.databasemanagement.internal.http.GetDatabaseFleetHealthMetricsConverter;
import com.oracle.bmc.databasemanagement.internal.http.GetDatabaseHomeMetricsConverter;
import com.oracle.bmc.databasemanagement.internal.http.GetJobConverter;
import com.oracle.bmc.databasemanagement.internal.http.GetJobExecutionConverter;
import com.oracle.bmc.databasemanagement.internal.http.GetJobRunConverter;
import com.oracle.bmc.databasemanagement.internal.http.GetManagedDatabaseConverter;
import com.oracle.bmc.databasemanagement.internal.http.GetManagedDatabaseGroupConverter;
import com.oracle.bmc.databasemanagement.internal.http.ListJobExecutionsConverter;
import com.oracle.bmc.databasemanagement.internal.http.ListJobRunsConverter;
import com.oracle.bmc.databasemanagement.internal.http.ListJobsConverter;
import com.oracle.bmc.databasemanagement.internal.http.ListManagedDatabaseGroupsConverter;
import com.oracle.bmc.databasemanagement.internal.http.ListManagedDatabasesConverter;
import com.oracle.bmc.databasemanagement.internal.http.RemoveManagedDatabaseFromManagedDatabaseGroupConverter;
import com.oracle.bmc.databasemanagement.internal.http.UpdateManagedDatabaseGroupConverter;
import com.oracle.bmc.databasemanagement.requests.AddManagedDatabaseToManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.ChangeJobCompartmentRequest;
import com.oracle.bmc.databasemanagement.requests.ChangeManagedDatabaseGroupCompartmentRequest;
import com.oracle.bmc.databasemanagement.requests.CreateJobRequest;
import com.oracle.bmc.databasemanagement.requests.CreateManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.DeleteJobRequest;
import com.oracle.bmc.databasemanagement.requests.DeleteManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.GetDatabaseFleetHealthMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.GetDatabaseHomeMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.GetJobExecutionRequest;
import com.oracle.bmc.databasemanagement.requests.GetJobRequest;
import com.oracle.bmc.databasemanagement.requests.GetJobRunRequest;
import com.oracle.bmc.databasemanagement.requests.GetManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.GetManagedDatabaseRequest;
import com.oracle.bmc.databasemanagement.requests.ListJobExecutionsRequest;
import com.oracle.bmc.databasemanagement.requests.ListJobRunsRequest;
import com.oracle.bmc.databasemanagement.requests.ListJobsRequest;
import com.oracle.bmc.databasemanagement.requests.ListManagedDatabaseGroupsRequest;
import com.oracle.bmc.databasemanagement.requests.ListManagedDatabasesRequest;
import com.oracle.bmc.databasemanagement.requests.RemoveManagedDatabaseFromManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.responses.AddManagedDatabaseToManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.ChangeJobCompartmentResponse;
import com.oracle.bmc.databasemanagement.responses.ChangeManagedDatabaseGroupCompartmentResponse;
import com.oracle.bmc.databasemanagement.responses.CreateJobResponse;
import com.oracle.bmc.databasemanagement.responses.CreateManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.DeleteJobResponse;
import com.oracle.bmc.databasemanagement.responses.DeleteManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.GetDatabaseFleetHealthMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.GetDatabaseHomeMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.GetJobExecutionResponse;
import com.oracle.bmc.databasemanagement.responses.GetJobResponse;
import com.oracle.bmc.databasemanagement.responses.GetJobRunResponse;
import com.oracle.bmc.databasemanagement.responses.GetManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.GetManagedDatabaseResponse;
import com.oracle.bmc.databasemanagement.responses.ListJobExecutionsResponse;
import com.oracle.bmc.databasemanagement.responses.ListJobRunsResponse;
import com.oracle.bmc.databasemanagement.responses.ListJobsResponse;
import com.oracle.bmc.databasemanagement.responses.ListManagedDatabaseGroupsResponse;
import com.oracle.bmc.databasemanagement.responses.ListManagedDatabasesResponse;
import com.oracle.bmc.databasemanagement.responses.RemoveManagedDatabaseFromManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateManagedDatabaseGroupResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbManagementAsyncClient
implements DbManagementAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DbManagementAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DBMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://dbmgmt.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public DbManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DbManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DbManagementAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DbManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DbManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DbManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DbManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public DbManagementAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<AddManagedDatabaseToManagedDatabaseGroupResponse> addManagedDatabaseToManagedDatabaseGroup(AddManagedDatabaseToManagedDatabaseGroupRequest request, AsyncHandler<AddManagedDatabaseToManagedDatabaseGroupRequest, AddManagedDatabaseToManagedDatabaseGroupResponse> handler) {
        LOG.trace("Called async addManagedDatabaseToManagedDatabaseGroup");
        AddManagedDatabaseToManagedDatabaseGroupRequest interceptedRequest = AddManagedDatabaseToManagedDatabaseGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddManagedDatabaseToManagedDatabaseGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddManagedDatabaseToManagedDatabaseGroupResponse> transformer = AddManagedDatabaseToManagedDatabaseGroupConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<AddManagedDatabaseToManagedDatabaseGroupRequest, AddManagedDatabaseToManagedDatabaseGroupResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<AddManagedDatabaseToManagedDatabaseGroupRequest, AddManagedDatabaseToManagedDatabaseGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeJobCompartmentResponse> changeJobCompartment(ChangeJobCompartmentRequest request, AsyncHandler<ChangeJobCompartmentRequest, ChangeJobCompartmentResponse> handler) {
        LOG.trace("Called async changeJobCompartment");
        ChangeJobCompartmentRequest interceptedRequest = ChangeJobCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeJobCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeJobCompartmentResponse> transformer = ChangeJobCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeJobCompartmentRequest, ChangeJobCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeJobCompartmentRequest, ChangeJobCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeManagedDatabaseGroupCompartmentResponse> changeManagedDatabaseGroupCompartment(ChangeManagedDatabaseGroupCompartmentRequest request, AsyncHandler<ChangeManagedDatabaseGroupCompartmentRequest, ChangeManagedDatabaseGroupCompartmentResponse> handler) {
        LOG.trace("Called async changeManagedDatabaseGroupCompartment");
        ChangeManagedDatabaseGroupCompartmentRequest interceptedRequest = ChangeManagedDatabaseGroupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeManagedDatabaseGroupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeManagedDatabaseGroupCompartmentResponse> transformer = ChangeManagedDatabaseGroupCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeManagedDatabaseGroupCompartmentRequest, ChangeManagedDatabaseGroupCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeManagedDatabaseGroupCompartmentRequest, ChangeManagedDatabaseGroupCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateJobResponse> createJob(CreateJobRequest request, AsyncHandler<CreateJobRequest, CreateJobResponse> handler) {
        LOG.trace("Called async createJob");
        CreateJobRequest interceptedRequest = CreateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateJobResponse> transformer = CreateJobConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateJobRequest, CreateJobResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateJobRequest, CreateJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateManagedDatabaseGroupResponse> createManagedDatabaseGroup(CreateManagedDatabaseGroupRequest request, AsyncHandler<CreateManagedDatabaseGroupRequest, CreateManagedDatabaseGroupResponse> handler) {
        LOG.trace("Called async createManagedDatabaseGroup");
        CreateManagedDatabaseGroupRequest interceptedRequest = CreateManagedDatabaseGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateManagedDatabaseGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateManagedDatabaseGroupResponse> transformer = CreateManagedDatabaseGroupConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateManagedDatabaseGroupRequest, CreateManagedDatabaseGroupResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateManagedDatabaseGroupRequest, CreateManagedDatabaseGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteJobResponse> deleteJob(DeleteJobRequest request, AsyncHandler<DeleteJobRequest, DeleteJobResponse> handler) {
        LOG.trace("Called async deleteJob");
        DeleteJobRequest interceptedRequest = DeleteJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteJobResponse> transformer = DeleteJobConverter.fromResponse();
        AsyncHandler<DeleteJobRequest, DeleteJobResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteJobRequest, DeleteJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteManagedDatabaseGroupResponse> deleteManagedDatabaseGroup(DeleteManagedDatabaseGroupRequest request, AsyncHandler<DeleteManagedDatabaseGroupRequest, DeleteManagedDatabaseGroupResponse> handler) {
        LOG.trace("Called async deleteManagedDatabaseGroup");
        DeleteManagedDatabaseGroupRequest interceptedRequest = DeleteManagedDatabaseGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteManagedDatabaseGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteManagedDatabaseGroupResponse> transformer = DeleteManagedDatabaseGroupConverter.fromResponse();
        AsyncHandler<DeleteManagedDatabaseGroupRequest, DeleteManagedDatabaseGroupResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteManagedDatabaseGroupRequest, DeleteManagedDatabaseGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDatabaseFleetHealthMetricsResponse> getDatabaseFleetHealthMetrics(GetDatabaseFleetHealthMetricsRequest request, AsyncHandler<GetDatabaseFleetHealthMetricsRequest, GetDatabaseFleetHealthMetricsResponse> handler) {
        LOG.trace("Called async getDatabaseFleetHealthMetrics");
        GetDatabaseFleetHealthMetricsRequest interceptedRequest = GetDatabaseFleetHealthMetricsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDatabaseFleetHealthMetricsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDatabaseFleetHealthMetricsResponse> transformer = GetDatabaseFleetHealthMetricsConverter.fromResponse();
        AsyncHandler<GetDatabaseFleetHealthMetricsRequest, GetDatabaseFleetHealthMetricsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDatabaseFleetHealthMetricsRequest, GetDatabaseFleetHealthMetricsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDatabaseHomeMetricsResponse> getDatabaseHomeMetrics(GetDatabaseHomeMetricsRequest request, AsyncHandler<GetDatabaseHomeMetricsRequest, GetDatabaseHomeMetricsResponse> handler) {
        LOG.trace("Called async getDatabaseHomeMetrics");
        GetDatabaseHomeMetricsRequest interceptedRequest = GetDatabaseHomeMetricsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDatabaseHomeMetricsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDatabaseHomeMetricsResponse> transformer = GetDatabaseHomeMetricsConverter.fromResponse();
        AsyncHandler<GetDatabaseHomeMetricsRequest, GetDatabaseHomeMetricsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDatabaseHomeMetricsRequest, GetDatabaseHomeMetricsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetJobResponse> getJob(GetJobRequest request, AsyncHandler<GetJobRequest, GetJobResponse> handler) {
        LOG.trace("Called async getJob");
        GetJobRequest interceptedRequest = GetJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobResponse> transformer = GetJobConverter.fromResponse();
        AsyncHandler<GetJobRequest, GetJobResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetJobRequest, GetJobResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetJobExecutionResponse> getJobExecution(GetJobExecutionRequest request, AsyncHandler<GetJobExecutionRequest, GetJobExecutionResponse> handler) {
        LOG.trace("Called async getJobExecution");
        GetJobExecutionRequest interceptedRequest = GetJobExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobExecutionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobExecutionResponse> transformer = GetJobExecutionConverter.fromResponse();
        AsyncHandler<GetJobExecutionRequest, GetJobExecutionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetJobExecutionRequest, GetJobExecutionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetJobRunResponse> getJobRun(GetJobRunRequest request, AsyncHandler<GetJobRunRequest, GetJobRunResponse> handler) {
        LOG.trace("Called async getJobRun");
        GetJobRunRequest interceptedRequest = GetJobRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobRunResponse> transformer = GetJobRunConverter.fromResponse();
        AsyncHandler<GetJobRunRequest, GetJobRunResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetJobRunRequest, GetJobRunResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetManagedDatabaseResponse> getManagedDatabase(GetManagedDatabaseRequest request, AsyncHandler<GetManagedDatabaseRequest, GetManagedDatabaseResponse> handler) {
        LOG.trace("Called async getManagedDatabase");
        GetManagedDatabaseRequest interceptedRequest = GetManagedDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagedDatabaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetManagedDatabaseResponse> transformer = GetManagedDatabaseConverter.fromResponse();
        AsyncHandler<GetManagedDatabaseRequest, GetManagedDatabaseResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetManagedDatabaseRequest, GetManagedDatabaseResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetManagedDatabaseGroupResponse> getManagedDatabaseGroup(GetManagedDatabaseGroupRequest request, AsyncHandler<GetManagedDatabaseGroupRequest, GetManagedDatabaseGroupResponse> handler) {
        LOG.trace("Called async getManagedDatabaseGroup");
        GetManagedDatabaseGroupRequest interceptedRequest = GetManagedDatabaseGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagedDatabaseGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetManagedDatabaseGroupResponse> transformer = GetManagedDatabaseGroupConverter.fromResponse();
        AsyncHandler<GetManagedDatabaseGroupRequest, GetManagedDatabaseGroupResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetManagedDatabaseGroupRequest, GetManagedDatabaseGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListJobExecutionsResponse> listJobExecutions(ListJobExecutionsRequest request, AsyncHandler<ListJobExecutionsRequest, ListJobExecutionsResponse> handler) {
        LOG.trace("Called async listJobExecutions");
        ListJobExecutionsRequest interceptedRequest = ListJobExecutionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobExecutionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListJobExecutionsResponse> transformer = ListJobExecutionsConverter.fromResponse();
        AsyncHandler<ListJobExecutionsRequest, ListJobExecutionsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListJobExecutionsRequest, ListJobExecutionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListJobRunsResponse> listJobRuns(ListJobRunsRequest request, AsyncHandler<ListJobRunsRequest, ListJobRunsResponse> handler) {
        LOG.trace("Called async listJobRuns");
        ListJobRunsRequest interceptedRequest = ListJobRunsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobRunsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListJobRunsResponse> transformer = ListJobRunsConverter.fromResponse();
        AsyncHandler<ListJobRunsRequest, ListJobRunsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListJobRunsRequest, ListJobRunsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListJobsResponse> listJobs(ListJobsRequest request, AsyncHandler<ListJobsRequest, ListJobsResponse> handler) {
        LOG.trace("Called async listJobs");
        ListJobsRequest interceptedRequest = ListJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListJobsResponse> transformer = ListJobsConverter.fromResponse();
        AsyncHandler<ListJobsRequest, ListJobsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListJobsRequest, ListJobsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListManagedDatabaseGroupsResponse> listManagedDatabaseGroups(ListManagedDatabaseGroupsRequest request, AsyncHandler<ListManagedDatabaseGroupsRequest, ListManagedDatabaseGroupsResponse> handler) {
        LOG.trace("Called async listManagedDatabaseGroups");
        ListManagedDatabaseGroupsRequest interceptedRequest = ListManagedDatabaseGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedDatabaseGroupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListManagedDatabaseGroupsResponse> transformer = ListManagedDatabaseGroupsConverter.fromResponse();
        AsyncHandler<ListManagedDatabaseGroupsRequest, ListManagedDatabaseGroupsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListManagedDatabaseGroupsRequest, ListManagedDatabaseGroupsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListManagedDatabasesResponse> listManagedDatabases(ListManagedDatabasesRequest request, AsyncHandler<ListManagedDatabasesRequest, ListManagedDatabasesResponse> handler) {
        LOG.trace("Called async listManagedDatabases");
        ListManagedDatabasesRequest interceptedRequest = ListManagedDatabasesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedDatabasesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListManagedDatabasesResponse> transformer = ListManagedDatabasesConverter.fromResponse();
        AsyncHandler<ListManagedDatabasesRequest, ListManagedDatabasesResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListManagedDatabasesRequest, ListManagedDatabasesResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RemoveManagedDatabaseFromManagedDatabaseGroupResponse> removeManagedDatabaseFromManagedDatabaseGroup(RemoveManagedDatabaseFromManagedDatabaseGroupRequest request, AsyncHandler<RemoveManagedDatabaseFromManagedDatabaseGroupRequest, RemoveManagedDatabaseFromManagedDatabaseGroupResponse> handler) {
        LOG.trace("Called async removeManagedDatabaseFromManagedDatabaseGroup");
        RemoveManagedDatabaseFromManagedDatabaseGroupRequest interceptedRequest = RemoveManagedDatabaseFromManagedDatabaseGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveManagedDatabaseFromManagedDatabaseGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemoveManagedDatabaseFromManagedDatabaseGroupResponse> transformer = RemoveManagedDatabaseFromManagedDatabaseGroupConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<RemoveManagedDatabaseFromManagedDatabaseGroupRequest, RemoveManagedDatabaseFromManagedDatabaseGroupResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RemoveManagedDatabaseFromManagedDatabaseGroupRequest, RemoveManagedDatabaseFromManagedDatabaseGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateManagedDatabaseGroupResponse> updateManagedDatabaseGroup(UpdateManagedDatabaseGroupRequest request, AsyncHandler<UpdateManagedDatabaseGroupRequest, UpdateManagedDatabaseGroupResponse> handler) {
        LOG.trace("Called async updateManagedDatabaseGroup");
        UpdateManagedDatabaseGroupRequest interceptedRequest = UpdateManagedDatabaseGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateManagedDatabaseGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateManagedDatabaseGroupResponse> transformer = UpdateManagedDatabaseGroupConverter.fromResponse();
        AsyncHandler<UpdateManagedDatabaseGroupRequest, UpdateManagedDatabaseGroupResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateManagedDatabaseGroupRequest, UpdateManagedDatabaseGroupResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DbManagementAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DbManagementAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DbManagementAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

