/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.databasemanagement.DbManagement;
import com.oracle.bmc.databasemanagement.DbManagementPaginators;
import com.oracle.bmc.databasemanagement.DbManagementWaiters;
import com.oracle.bmc.databasemanagement.internal.http.AddManagedDatabaseToManagedDatabaseGroupConverter;
import com.oracle.bmc.databasemanagement.internal.http.ChangeJobCompartmentConverter;
import com.oracle.bmc.databasemanagement.internal.http.ChangeManagedDatabaseGroupCompartmentConverter;
import com.oracle.bmc.databasemanagement.internal.http.CreateJobConverter;
import com.oracle.bmc.databasemanagement.internal.http.CreateManagedDatabaseGroupConverter;
import com.oracle.bmc.databasemanagement.internal.http.DeleteJobConverter;
import com.oracle.bmc.databasemanagement.internal.http.DeleteManagedDatabaseGroupConverter;
import com.oracle.bmc.databasemanagement.internal.http.GetDatabaseFleetHealthMetricsConverter;
import com.oracle.bmc.databasemanagement.internal.http.GetDatabaseHomeMetricsConverter;
import com.oracle.bmc.databasemanagement.internal.http.GetJobConverter;
import com.oracle.bmc.databasemanagement.internal.http.GetJobExecutionConverter;
import com.oracle.bmc.databasemanagement.internal.http.GetJobRunConverter;
import com.oracle.bmc.databasemanagement.internal.http.GetManagedDatabaseConverter;
import com.oracle.bmc.databasemanagement.internal.http.GetManagedDatabaseGroupConverter;
import com.oracle.bmc.databasemanagement.internal.http.ListJobExecutionsConverter;
import com.oracle.bmc.databasemanagement.internal.http.ListJobRunsConverter;
import com.oracle.bmc.databasemanagement.internal.http.ListJobsConverter;
import com.oracle.bmc.databasemanagement.internal.http.ListManagedDatabaseGroupsConverter;
import com.oracle.bmc.databasemanagement.internal.http.ListManagedDatabasesConverter;
import com.oracle.bmc.databasemanagement.internal.http.RemoveManagedDatabaseFromManagedDatabaseGroupConverter;
import com.oracle.bmc.databasemanagement.internal.http.UpdateManagedDatabaseGroupConverter;
import com.oracle.bmc.databasemanagement.requests.AddManagedDatabaseToManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.ChangeJobCompartmentRequest;
import com.oracle.bmc.databasemanagement.requests.ChangeManagedDatabaseGroupCompartmentRequest;
import com.oracle.bmc.databasemanagement.requests.CreateJobRequest;
import com.oracle.bmc.databasemanagement.requests.CreateManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.DeleteJobRequest;
import com.oracle.bmc.databasemanagement.requests.DeleteManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.GetDatabaseFleetHealthMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.GetDatabaseHomeMetricsRequest;
import com.oracle.bmc.databasemanagement.requests.GetJobExecutionRequest;
import com.oracle.bmc.databasemanagement.requests.GetJobRequest;
import com.oracle.bmc.databasemanagement.requests.GetJobRunRequest;
import com.oracle.bmc.databasemanagement.requests.GetManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.GetManagedDatabaseRequest;
import com.oracle.bmc.databasemanagement.requests.ListJobExecutionsRequest;
import com.oracle.bmc.databasemanagement.requests.ListJobRunsRequest;
import com.oracle.bmc.databasemanagement.requests.ListJobsRequest;
import com.oracle.bmc.databasemanagement.requests.ListManagedDatabaseGroupsRequest;
import com.oracle.bmc.databasemanagement.requests.ListManagedDatabasesRequest;
import com.oracle.bmc.databasemanagement.requests.RemoveManagedDatabaseFromManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.requests.UpdateManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.responses.AddManagedDatabaseToManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.ChangeJobCompartmentResponse;
import com.oracle.bmc.databasemanagement.responses.ChangeManagedDatabaseGroupCompartmentResponse;
import com.oracle.bmc.databasemanagement.responses.CreateJobResponse;
import com.oracle.bmc.databasemanagement.responses.CreateManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.DeleteJobResponse;
import com.oracle.bmc.databasemanagement.responses.DeleteManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.GetDatabaseFleetHealthMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.GetDatabaseHomeMetricsResponse;
import com.oracle.bmc.databasemanagement.responses.GetJobExecutionResponse;
import com.oracle.bmc.databasemanagement.responses.GetJobResponse;
import com.oracle.bmc.databasemanagement.responses.GetJobRunResponse;
import com.oracle.bmc.databasemanagement.responses.GetManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.GetManagedDatabaseResponse;
import com.oracle.bmc.databasemanagement.responses.ListJobExecutionsResponse;
import com.oracle.bmc.databasemanagement.responses.ListJobRunsResponse;
import com.oracle.bmc.databasemanagement.responses.ListJobsResponse;
import com.oracle.bmc.databasemanagement.responses.ListManagedDatabaseGroupsResponse;
import com.oracle.bmc.databasemanagement.responses.ListManagedDatabasesResponse;
import com.oracle.bmc.databasemanagement.responses.RemoveManagedDatabaseFromManagedDatabaseGroupResponse;
import com.oracle.bmc.databasemanagement.responses.UpdateManagedDatabaseGroupResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbManagementClient
implements DbManagement {
    private static final Logger LOG = LoggerFactory.getLogger(DbManagementClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DBMANAGEMENT").serviceEndpointPrefix("").serviceEndpointTemplate("https://dbmgmt.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final DbManagementWaiters waiters;
    private final DbManagementPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public DbManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DbManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DbManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DbManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DbManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DbManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DbManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public DbManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected DbManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DbManagement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DbManagementWaiters(executorService, this);
        this.paginators = new DbManagementPaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public AddManagedDatabaseToManagedDatabaseGroupResponse addManagedDatabaseToManagedDatabaseGroup(AddManagedDatabaseToManagedDatabaseGroupRequest request) {
        LOG.trace("Called addManagedDatabaseToManagedDatabaseGroup");
        AddManagedDatabaseToManagedDatabaseGroupRequest interceptedRequest = AddManagedDatabaseToManagedDatabaseGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = AddManagedDatabaseToManagedDatabaseGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, AddManagedDatabaseToManagedDatabaseGroupResponse> transformer = AddManagedDatabaseToManagedDatabaseGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (AddManagedDatabaseToManagedDatabaseGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (AddManagedDatabaseToManagedDatabaseGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAddManagedDatabaseToManagedDatabaseGroupDetails(), (BmcRequest)retriedRequest);
                return (AddManagedDatabaseToManagedDatabaseGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeJobCompartmentResponse changeJobCompartment(ChangeJobCompartmentRequest request) {
        LOG.trace("Called changeJobCompartment");
        ChangeJobCompartmentRequest interceptedRequest = ChangeJobCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeJobCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeJobCompartmentResponse> transformer = ChangeJobCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeJobCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeJobCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeJobCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeJobCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeManagedDatabaseGroupCompartmentResponse changeManagedDatabaseGroupCompartment(ChangeManagedDatabaseGroupCompartmentRequest request) {
        LOG.trace("Called changeManagedDatabaseGroupCompartment");
        ChangeManagedDatabaseGroupCompartmentRequest interceptedRequest = ChangeManagedDatabaseGroupCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeManagedDatabaseGroupCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeManagedDatabaseGroupCompartmentResponse> transformer = ChangeManagedDatabaseGroupCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeManagedDatabaseGroupCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeManagedDatabaseGroupCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeManagedDatabaseGroupCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeManagedDatabaseGroupCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateJobResponse createJob(CreateJobRequest request) {
        LOG.trace("Called createJob");
        CreateJobRequest interceptedRequest = CreateJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateJobResponse> transformer = CreateJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateJobResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateJobResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateJobDetails(), (BmcRequest)retriedRequest);
                return (CreateJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateManagedDatabaseGroupResponse createManagedDatabaseGroup(CreateManagedDatabaseGroupRequest request) {
        LOG.trace("Called createManagedDatabaseGroup");
        CreateManagedDatabaseGroupRequest interceptedRequest = CreateManagedDatabaseGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateManagedDatabaseGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateManagedDatabaseGroupResponse> transformer = CreateManagedDatabaseGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateManagedDatabaseGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateManagedDatabaseGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateManagedDatabaseGroupDetails(), (BmcRequest)retriedRequest);
                return (CreateManagedDatabaseGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteJobResponse deleteJob(DeleteJobRequest request) {
        LOG.trace("Called deleteJob");
        DeleteJobRequest interceptedRequest = DeleteJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteJobResponse> transformer = DeleteJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteJobResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteJobResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteManagedDatabaseGroupResponse deleteManagedDatabaseGroup(DeleteManagedDatabaseGroupRequest request) {
        LOG.trace("Called deleteManagedDatabaseGroup");
        DeleteManagedDatabaseGroupRequest interceptedRequest = DeleteManagedDatabaseGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteManagedDatabaseGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteManagedDatabaseGroupResponse> transformer = DeleteManagedDatabaseGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteManagedDatabaseGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteManagedDatabaseGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteManagedDatabaseGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDatabaseFleetHealthMetricsResponse getDatabaseFleetHealthMetrics(GetDatabaseFleetHealthMetricsRequest request) {
        LOG.trace("Called getDatabaseFleetHealthMetrics");
        GetDatabaseFleetHealthMetricsRequest interceptedRequest = GetDatabaseFleetHealthMetricsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDatabaseFleetHealthMetricsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDatabaseFleetHealthMetricsResponse> transformer = GetDatabaseFleetHealthMetricsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDatabaseFleetHealthMetricsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDatabaseFleetHealthMetricsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDatabaseFleetHealthMetricsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDatabaseHomeMetricsResponse getDatabaseHomeMetrics(GetDatabaseHomeMetricsRequest request) {
        LOG.trace("Called getDatabaseHomeMetrics");
        GetDatabaseHomeMetricsRequest interceptedRequest = GetDatabaseHomeMetricsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDatabaseHomeMetricsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDatabaseHomeMetricsResponse> transformer = GetDatabaseHomeMetricsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDatabaseHomeMetricsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDatabaseHomeMetricsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDatabaseHomeMetricsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobResponse getJob(GetJobRequest request) {
        LOG.trace("Called getJob");
        GetJobRequest interceptedRequest = GetJobConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobResponse> transformer = GetJobConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetJobResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobExecutionResponse getJobExecution(GetJobExecutionRequest request) {
        LOG.trace("Called getJobExecution");
        GetJobExecutionRequest interceptedRequest = GetJobExecutionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobExecutionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobExecutionResponse> transformer = GetJobExecutionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetJobExecutionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobExecutionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobExecutionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetJobRunResponse getJobRun(GetJobRunRequest request) {
        LOG.trace("Called getJobRun");
        GetJobRunRequest interceptedRequest = GetJobRunConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetJobRunConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetJobRunResponse> transformer = GetJobRunConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetJobRunResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetJobRunResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetJobRunResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetManagedDatabaseResponse getManagedDatabase(GetManagedDatabaseRequest request) {
        LOG.trace("Called getManagedDatabase");
        GetManagedDatabaseRequest interceptedRequest = GetManagedDatabaseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagedDatabaseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetManagedDatabaseResponse> transformer = GetManagedDatabaseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetManagedDatabaseResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetManagedDatabaseResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetManagedDatabaseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetManagedDatabaseGroupResponse getManagedDatabaseGroup(GetManagedDatabaseGroupRequest request) {
        LOG.trace("Called getManagedDatabaseGroup");
        GetManagedDatabaseGroupRequest interceptedRequest = GetManagedDatabaseGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetManagedDatabaseGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetManagedDatabaseGroupResponse> transformer = GetManagedDatabaseGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetManagedDatabaseGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetManagedDatabaseGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetManagedDatabaseGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListJobExecutionsResponse listJobExecutions(ListJobExecutionsRequest request) {
        LOG.trace("Called listJobExecutions");
        ListJobExecutionsRequest interceptedRequest = ListJobExecutionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobExecutionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListJobExecutionsResponse> transformer = ListJobExecutionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListJobExecutionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListJobExecutionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListJobExecutionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListJobRunsResponse listJobRuns(ListJobRunsRequest request) {
        LOG.trace("Called listJobRuns");
        ListJobRunsRequest interceptedRequest = ListJobRunsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobRunsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListJobRunsResponse> transformer = ListJobRunsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListJobRunsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListJobRunsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListJobRunsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest request) {
        LOG.trace("Called listJobs");
        ListJobsRequest interceptedRequest = ListJobsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListJobsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListJobsResponse> transformer = ListJobsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListJobsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListJobsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListJobsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListManagedDatabaseGroupsResponse listManagedDatabaseGroups(ListManagedDatabaseGroupsRequest request) {
        LOG.trace("Called listManagedDatabaseGroups");
        ListManagedDatabaseGroupsRequest interceptedRequest = ListManagedDatabaseGroupsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedDatabaseGroupsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListManagedDatabaseGroupsResponse> transformer = ListManagedDatabaseGroupsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListManagedDatabaseGroupsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListManagedDatabaseGroupsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListManagedDatabaseGroupsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListManagedDatabasesResponse listManagedDatabases(ListManagedDatabasesRequest request) {
        LOG.trace("Called listManagedDatabases");
        ListManagedDatabasesRequest interceptedRequest = ListManagedDatabasesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListManagedDatabasesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListManagedDatabasesResponse> transformer = ListManagedDatabasesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListManagedDatabasesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListManagedDatabasesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListManagedDatabasesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public RemoveManagedDatabaseFromManagedDatabaseGroupResponse removeManagedDatabaseFromManagedDatabaseGroup(RemoveManagedDatabaseFromManagedDatabaseGroupRequest request) {
        LOG.trace("Called removeManagedDatabaseFromManagedDatabaseGroup");
        RemoveManagedDatabaseFromManagedDatabaseGroupRequest interceptedRequest = RemoveManagedDatabaseFromManagedDatabaseGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RemoveManagedDatabaseFromManagedDatabaseGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RemoveManagedDatabaseFromManagedDatabaseGroupResponse> transformer = RemoveManagedDatabaseFromManagedDatabaseGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (RemoveManagedDatabaseFromManagedDatabaseGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RemoveManagedDatabaseFromManagedDatabaseGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRemoveManagedDatabaseFromManagedDatabaseGroupDetails(), (BmcRequest)retriedRequest);
                return (RemoveManagedDatabaseFromManagedDatabaseGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateManagedDatabaseGroupResponse updateManagedDatabaseGroup(UpdateManagedDatabaseGroupRequest request) {
        LOG.trace("Called updateManagedDatabaseGroup");
        UpdateManagedDatabaseGroupRequest interceptedRequest = UpdateManagedDatabaseGroupConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateManagedDatabaseGroupConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateManagedDatabaseGroupResponse> transformer = UpdateManagedDatabaseGroupConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateManagedDatabaseGroupResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateManagedDatabaseGroupResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateManagedDatabaseGroupDetails(), (BmcRequest)retriedRequest);
                return (UpdateManagedDatabaseGroupResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DbManagementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DbManagementPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DbManagementClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DbManagementClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DbManagementClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

