/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.databasemanagement.DbManagement;
import com.oracle.bmc.databasemanagement.model.Job;
import com.oracle.bmc.databasemanagement.model.LifecycleStates;
import com.oracle.bmc.databasemanagement.requests.GetJobRequest;
import com.oracle.bmc.databasemanagement.requests.GetManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.responses.GetJobResponse;
import com.oracle.bmc.databasemanagement.responses.GetManagedDatabaseGroupResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class DbManagementWaiters {
    private final ExecutorService executorService;
    private final DbManagement client;

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, Job.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forJob(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, Job.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetJobRequest, GetJobResponse> forJob(GetJobRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Job.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forJob(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetJobRequest, GetJobResponse> forJob(BmcGenericWaiter waiter, GetJobRequest request, Job.LifecycleState ... targetStates) {
        final HashSet<Job.LifecycleState> targetStatesSet = new HashSet<Job.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetJobRequest, GetJobResponse>(){

            public GetJobResponse apply(GetJobRequest request) {
                return DbManagementWaiters.this.client.getJob(request);
            }
        }, (Predicate)new Predicate<GetJobResponse>(){

            public boolean apply(GetJobResponse response) {
                return targetStatesSet.contains((Object)response.getJob().getLifecycleState());
            }
        }, false), (Object)request);
    }

    public Waiter<GetManagedDatabaseGroupRequest, GetManagedDatabaseGroupResponse> forManagedDatabaseGroup(GetManagedDatabaseGroupRequest request, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forManagedDatabaseGroup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetManagedDatabaseGroupRequest, GetManagedDatabaseGroupResponse> forManagedDatabaseGroup(GetManagedDatabaseGroupRequest request, LifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forManagedDatabaseGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetManagedDatabaseGroupRequest, GetManagedDatabaseGroupResponse> forManagedDatabaseGroup(GetManagedDatabaseGroupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forManagedDatabaseGroup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetManagedDatabaseGroupRequest, GetManagedDatabaseGroupResponse> forManagedDatabaseGroup(BmcGenericWaiter waiter, GetManagedDatabaseGroupRequest request, LifecycleStates ... targetStates) {
        final HashSet<LifecycleStates> targetStatesSet = new HashSet<LifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetManagedDatabaseGroupRequest, GetManagedDatabaseGroupResponse>(){

            public GetManagedDatabaseGroupResponse apply(GetManagedDatabaseGroupRequest request) {
                return DbManagementWaiters.this.client.getManagedDatabaseGroup(request);
            }
        }, (Predicate)new Predicate<GetManagedDatabaseGroupResponse>(){

            public boolean apply(GetManagedDatabaseGroupResponse response) {
                return targetStatesSet.contains((Object)response.getManagedDatabaseGroup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleStates.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public DbManagementWaiters(ExecutorService executorService, DbManagement client) {
        this.executorService = executorService;
        this.client = client;
    }
}

