/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.databasemanagement.model.ManagedDatabaseGroup;
import com.oracle.bmc.databasemanagement.requests.CreateManagedDatabaseGroupRequest;
import com.oracle.bmc.databasemanagement.responses.CreateManagedDatabaseGroupResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateManagedDatabaseGroupConverter {
    private static final Logger LOG = LoggerFactory.getLogger(CreateManagedDatabaseGroupConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static CreateManagedDatabaseGroupRequest interceptRequest(CreateManagedDatabaseGroupRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, CreateManagedDatabaseGroupRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCreateManagedDatabaseGroupDetails(), (String)"createManagedDatabaseGroupDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20201101").path("managedDatabaseGroups");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        return ib;
    }

    public static Function<Response, CreateManagedDatabaseGroupResponse> fromResponse() {
        Function<Response, CreateManagedDatabaseGroupResponse> transformer = new Function<Response, CreateManagedDatabaseGroupResponse>(){

            public CreateManagedDatabaseGroupResponse apply(Response rawResponse) {
                Optional etagHeader;
                Optional opcRequestIdHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.databasemanagement.responses.CreateManagedDatabaseGroupResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(ManagedDatabaseGroup.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                CreateManagedDatabaseGroupResponse.Builder builder = CreateManagedDatabaseGroupResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.managedDatabaseGroup((ManagedDatabaseGroup)response.getItem());
                Optional locationHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"location");
                if (locationHeader.isPresent()) {
                    builder.location((String)HeaderUtils.toValue((String)"location", (String)((String)((List)locationHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                CreateManagedDatabaseGroupResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

