/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetDatabaseHomeMetricsRequest
extends BmcRequest<Void> {
    private String managedDatabaseId;
    private String startTime;
    private String endTime;
    private String opcRequestId;

    @ConstructorProperties(value={"managedDatabaseId", "startTime", "endTime", "opcRequestId"})
    GetDatabaseHomeMetricsRequest(String managedDatabaseId, String startTime, String endTime, String opcRequestId) {
        this.managedDatabaseId = managedDatabaseId;
        this.startTime = startTime;
        this.endTime = endTime;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getManagedDatabaseId() {
        return this.managedDatabaseId;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getEndTime() {
        return this.endTime;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDatabaseHomeMetricsRequest, Void> {
        private String managedDatabaseId;
        private String startTime;
        private String endTime;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDatabaseHomeMetricsRequest o) {
            this.managedDatabaseId(o.getManagedDatabaseId());
            this.startTime(o.getStartTime());
            this.endTime(o.getEndTime());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDatabaseHomeMetricsRequest build() {
            GetDatabaseHomeMetricsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder managedDatabaseId(String managedDatabaseId) {
            this.managedDatabaseId = managedDatabaseId;
            return this;
        }

        public Builder startTime(String startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder endTime(String endTime) {
            this.endTime = endTime;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetDatabaseHomeMetricsRequest buildWithoutInvocationCallback() {
            return new GetDatabaseHomeMetricsRequest(this.managedDatabaseId, this.startTime, this.endTime, this.opcRequestId);
        }

        public String toString() {
            return "GetDatabaseHomeMetricsRequest.Builder(managedDatabaseId=" + this.managedDatabaseId + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

