/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.databasemanagement.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetJobExecutionRequest
extends BmcRequest<Void> {
    private String jobExecutionId;
    private String opcRequestId;

    @ConstructorProperties(value={"jobExecutionId", "opcRequestId"})
    GetJobExecutionRequest(String jobExecutionId, String opcRequestId) {
        this.jobExecutionId = jobExecutionId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getJobExecutionId() {
        return this.jobExecutionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetJobExecutionRequest, Void> {
        private String jobExecutionId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetJobExecutionRequest o) {
            this.jobExecutionId(o.getJobExecutionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetJobExecutionRequest build() {
            GetJobExecutionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder jobExecutionId(String jobExecutionId) {
            this.jobExecutionId = jobExecutionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetJobExecutionRequest buildWithoutInvocationCallback() {
            return new GetJobExecutionRequest(this.jobExecutionId, this.opcRequestId);
        }

        public String toString() {
            return "GetJobExecutionRequest.Builder(jobExecutionId=" + this.jobExecutionId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

