/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.dataflow.DataFlow;
import com.oracle.bmc.dataflow.model.ApplicationSummary;
import com.oracle.bmc.dataflow.model.PrivateEndpointSummary;
import com.oracle.bmc.dataflow.model.RunLogSummary;
import com.oracle.bmc.dataflow.model.RunSummary;
import com.oracle.bmc.dataflow.model.WorkRequestError;
import com.oracle.bmc.dataflow.model.WorkRequestLog;
import com.oracle.bmc.dataflow.model.WorkRequestSummary;
import com.oracle.bmc.dataflow.requests.ListApplicationsRequest;
import com.oracle.bmc.dataflow.requests.ListPrivateEndpointsRequest;
import com.oracle.bmc.dataflow.requests.ListRunLogsRequest;
import com.oracle.bmc.dataflow.requests.ListRunsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.dataflow.requests.ListWorkRequestsRequest;
import com.oracle.bmc.dataflow.responses.ListApplicationsResponse;
import com.oracle.bmc.dataflow.responses.ListPrivateEndpointsResponse;
import com.oracle.bmc.dataflow.responses.ListRunLogsResponse;
import com.oracle.bmc.dataflow.responses.ListRunsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.dataflow.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class DataFlowPaginators {
    private final DataFlow client;

    public Iterable<ListApplicationsResponse> listApplicationsResponseIterator(final ListApplicationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListApplicationsRequest.Builder>(){

            public ListApplicationsRequest.Builder get() {
                return ListApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApplicationsResponse, String>(){

            public String apply(ListApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApplicationsRequest.Builder>, ListApplicationsRequest>(){

            public ListApplicationsRequest apply(RequestBuilderAndToken<ListApplicationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListApplicationsRequest, ListApplicationsResponse>(){

            public ListApplicationsResponse apply(ListApplicationsRequest request) {
                return DataFlowPaginators.this.client.listApplications(request);
            }
        });
    }

    public Iterable<ApplicationSummary> listApplicationsRecordIterator(final ListApplicationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListApplicationsRequest.Builder>(){

            public ListApplicationsRequest.Builder get() {
                return ListApplicationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListApplicationsResponse, String>(){

            public String apply(ListApplicationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListApplicationsRequest.Builder>, ListApplicationsRequest>(){

            public ListApplicationsRequest apply(RequestBuilderAndToken<ListApplicationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListApplicationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListApplicationsRequest, ListApplicationsResponse>(){

            public ListApplicationsResponse apply(ListApplicationsRequest request) {
                return DataFlowPaginators.this.client.listApplications(request);
            }
        }, (Function)new Function<ListApplicationsResponse, List<ApplicationSummary>>(){

            public List<ApplicationSummary> apply(ListApplicationsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPrivateEndpointsResponse> listPrivateEndpointsResponseIterator(final ListPrivateEndpointsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPrivateEndpointsRequest.Builder>(){

            public ListPrivateEndpointsRequest.Builder get() {
                return ListPrivateEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPrivateEndpointsResponse, String>(){

            public String apply(ListPrivateEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPrivateEndpointsRequest.Builder>, ListPrivateEndpointsRequest>(){

            public ListPrivateEndpointsRequest apply(RequestBuilderAndToken<ListPrivateEndpointsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPrivateEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPrivateEndpointsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPrivateEndpointsRequest, ListPrivateEndpointsResponse>(){

            public ListPrivateEndpointsResponse apply(ListPrivateEndpointsRequest request) {
                return DataFlowPaginators.this.client.listPrivateEndpoints(request);
            }
        });
    }

    public Iterable<PrivateEndpointSummary> listPrivateEndpointsRecordIterator(final ListPrivateEndpointsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPrivateEndpointsRequest.Builder>(){

            public ListPrivateEndpointsRequest.Builder get() {
                return ListPrivateEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPrivateEndpointsResponse, String>(){

            public String apply(ListPrivateEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPrivateEndpointsRequest.Builder>, ListPrivateEndpointsRequest>(){

            public ListPrivateEndpointsRequest apply(RequestBuilderAndToken<ListPrivateEndpointsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPrivateEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPrivateEndpointsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPrivateEndpointsRequest, ListPrivateEndpointsResponse>(){

            public ListPrivateEndpointsResponse apply(ListPrivateEndpointsRequest request) {
                return DataFlowPaginators.this.client.listPrivateEndpoints(request);
            }
        }, (Function)new Function<ListPrivateEndpointsResponse, List<PrivateEndpointSummary>>(){

            public List<PrivateEndpointSummary> apply(ListPrivateEndpointsResponse response) {
                return response.getPrivateEndpointCollection().getItems();
            }
        });
    }

    public Iterable<ListRunLogsResponse> listRunLogsResponseIterator(final ListRunLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRunLogsRequest.Builder>(){

            public ListRunLogsRequest.Builder get() {
                return ListRunLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRunLogsResponse, String>(){

            public String apply(ListRunLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRunLogsRequest.Builder>, ListRunLogsRequest>(){

            public ListRunLogsRequest apply(RequestBuilderAndToken<ListRunLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRunLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRunLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRunLogsRequest, ListRunLogsResponse>(){

            public ListRunLogsResponse apply(ListRunLogsRequest request) {
                return DataFlowPaginators.this.client.listRunLogs(request);
            }
        });
    }

    public Iterable<RunLogSummary> listRunLogsRecordIterator(final ListRunLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRunLogsRequest.Builder>(){

            public ListRunLogsRequest.Builder get() {
                return ListRunLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRunLogsResponse, String>(){

            public String apply(ListRunLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRunLogsRequest.Builder>, ListRunLogsRequest>(){

            public ListRunLogsRequest apply(RequestBuilderAndToken<ListRunLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRunLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRunLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRunLogsRequest, ListRunLogsResponse>(){

            public ListRunLogsResponse apply(ListRunLogsRequest request) {
                return DataFlowPaginators.this.client.listRunLogs(request);
            }
        }, (Function)new Function<ListRunLogsResponse, List<RunLogSummary>>(){

            public List<RunLogSummary> apply(ListRunLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListRunsResponse> listRunsResponseIterator(final ListRunsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRunsRequest.Builder>(){

            public ListRunsRequest.Builder get() {
                return ListRunsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRunsResponse, String>(){

            public String apply(ListRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRunsRequest.Builder>, ListRunsRequest>(){

            public ListRunsRequest apply(RequestBuilderAndToken<ListRunsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRunsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRunsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRunsRequest, ListRunsResponse>(){

            public ListRunsResponse apply(ListRunsRequest request) {
                return DataFlowPaginators.this.client.listRuns(request);
            }
        });
    }

    public Iterable<RunSummary> listRunsRecordIterator(final ListRunsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRunsRequest.Builder>(){

            public ListRunsRequest.Builder get() {
                return ListRunsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRunsResponse, String>(){

            public String apply(ListRunsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRunsRequest.Builder>, ListRunsRequest>(){

            public ListRunsRequest apply(RequestBuilderAndToken<ListRunsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRunsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRunsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRunsRequest, ListRunsResponse>(){

            public ListRunsResponse apply(ListRunsRequest request) {
                return DataFlowPaginators.this.client.listRuns(request);
            }
        }, (Function)new Function<ListRunsResponse, List<RunSummary>>(){

            public List<RunSummary> apply(ListRunsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DataFlowPaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DataFlowPaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getWorkRequestErrorCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DataFlowPaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLog> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DataFlowPaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLog>>(){

            public List<WorkRequestLog> apply(ListWorkRequestLogsResponse response) {
                return response.getWorkRequestLogCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DataFlowPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DataFlowPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getWorkRequestCollection().getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public DataFlowPaginators(DataFlow client) {
        this.client = client;
    }
}

