/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dataflow.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.dataflow.requests.GetRunLogRequest;
import com.oracle.bmc.dataflow.responses.GetRunLogResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetRunLogConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetRunLogConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetRunLogRequest interceptRequest(GetRunLogRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetRunLogRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getRunId(), (String)"runId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getName(), (String)"name must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200129").path("runs").path(HttpUtils.encodePathSegment((String)request.getRunId())).path("logs").path(HttpUtils.encodePathSegment((String)request.getName()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/octet-stream"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetRunLogResponse> fromResponse() {
        Function<Response, GetRunLogResponse> transformer = new Function<Response, GetRunLogResponse>(){

            public GetRunLogResponse apply(Response rawResponse) {
                Optional contentEncodingHeader;
                Optional contentTypeHeader;
                Optional contentLengthHeader;
                Optional etagHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.dataflow.responses.GetRunLogResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(InputStream.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetRunLogResponse.Builder builder = GetRunLogResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.inputStream((InputStream)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((contentLengthHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"content-length")).isPresent()) {
                    builder.contentLength((Long)HeaderUtils.toValue((String)"content-length", (String)((String)((List)contentLengthHeader.get()).get(0)), Long.class));
                }
                if ((contentTypeHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"content-type")).isPresent()) {
                    builder.contentType((String)HeaderUtils.toValue((String)"content-type", (String)((String)((List)contentTypeHeader.get()).get(0)), String.class));
                }
                if ((contentEncodingHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"content-encoding")).isPresent()) {
                    builder.contentEncoding((String)HeaderUtils.toValue((String)"content-encoding", (String)((String)((List)contentEncodingHeader.get()).get(0)), String.class));
                }
                HashMap<String, String> opcMeta = new HashMap<String, String>();
                String opcMetaPattern = "opc-meta-".toLowerCase(Locale.ROOT);
                for (Map.Entry header : headers.entrySet()) {
                    if (!((String)header.getKey()).toLowerCase(Locale.ROOT).startsWith(opcMetaPattern)) continue;
                    opcMeta.put((String)header.getKey(), (String)((List)header.getValue()).get(0));
                }
                if (opcMeta.size() > 0) {
                    builder.opcMeta(opcMeta);
                }
                GetRunLogResponse responseWrapper = builder.build();
                return responseWrapper;
            }
        };
        return transformer;
    }
}

