/**
 * Copyright (c) 2016, 2021, Oracle and/or its affiliates.  All rights reserved.
 * This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
 */
package com.oracle.bmc.dataintegration.model;

/**
 * The configuration for handling schema drift in a Source or Target operator.
 * <br/>
 * Note: Objects should always be created or deserialized using the {@link Builder}. This model distinguishes fields
 * that are {@code null} because they are unset from fields that are explicitly set to {@code null}. This is done in
 * the setter methods of the {@link Builder}, which maintain a set of all explicitly set fields called
 * {@link #__explicitlySet__}. The {@link #hashCode()} and {@link #equals(Object)} methods are implemented to take
 * {@link #__explicitlySet__} into account. The constructor, on the other hand, does not set {@link #__explicitlySet__}
 * (since the constructor cannot distinguish explicit {@code null} from unset {@code null}).
 **/
@javax.annotation.Generated(value = "OracleSDKGenerator", comments = "API Version: 20200430")
@lombok.AllArgsConstructor(onConstructor = @__({@Deprecated}))
@lombok.Value
@com.fasterxml.jackson.databind.annotation.JsonDeserialize(
    builder = SchemaDriftConfig.Builder.class
)
@com.fasterxml.jackson.annotation.JsonFilter(com.oracle.bmc.http.internal.ExplicitlySetFilter.NAME)
@lombok.Builder(builderClassName = "Builder", toBuilder = true)
public class SchemaDriftConfig {
    @com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder(withPrefix = "")
    @lombok.experimental.Accessors(fluent = true)
    public static class Builder {
        @com.fasterxml.jackson.annotation.JsonProperty("extraColumnHandling")
        private ExtraColumnHandling extraColumnHandling;

        public Builder extraColumnHandling(ExtraColumnHandling extraColumnHandling) {
            this.extraColumnHandling = extraColumnHandling;
            this.__explicitlySet__.add("extraColumnHandling");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("missingColumnHandling")
        private MissingColumnHandling missingColumnHandling;

        public Builder missingColumnHandling(MissingColumnHandling missingColumnHandling) {
            this.missingColumnHandling = missingColumnHandling;
            this.__explicitlySet__.add("missingColumnHandling");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("dataTypeChangeHandling")
        private DataTypeChangeHandling dataTypeChangeHandling;

        public Builder dataTypeChangeHandling(DataTypeChangeHandling dataTypeChangeHandling) {
            this.dataTypeChangeHandling = dataTypeChangeHandling;
            this.__explicitlySet__.add("dataTypeChangeHandling");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonProperty("isValidationWarningIfAllowed")
        private Boolean isValidationWarningIfAllowed;

        public Builder isValidationWarningIfAllowed(Boolean isValidationWarningIfAllowed) {
            this.isValidationWarningIfAllowed = isValidationWarningIfAllowed;
            this.__explicitlySet__.add("isValidationWarningIfAllowed");
            return this;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();

        public SchemaDriftConfig build() {
            SchemaDriftConfig __instance__ =
                    new SchemaDriftConfig(
                            extraColumnHandling,
                            missingColumnHandling,
                            dataTypeChangeHandling,
                            isValidationWarningIfAllowed);
            __instance__.__explicitlySet__.addAll(__explicitlySet__);
            return __instance__;
        }

        @com.fasterxml.jackson.annotation.JsonIgnore
        public Builder copy(SchemaDriftConfig o) {
            Builder copiedBuilder =
                    extraColumnHandling(o.getExtraColumnHandling())
                            .missingColumnHandling(o.getMissingColumnHandling())
                            .dataTypeChangeHandling(o.getDataTypeChangeHandling())
                            .isValidationWarningIfAllowed(o.getIsValidationWarningIfAllowed());

            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }
    }

    /**
     * Create a new builder.
     */
    public static Builder builder() {
        return new Builder();
    }

    /**
     * The setting for how to handle extra columns/fields.  NULL_FILLUP means that nulls will be loaded into the target for extra columns.
     **/
    @lombok.extern.slf4j.Slf4j
    public enum ExtraColumnHandling {
        Allow("ALLOW"),
        NullFillup("NULL_FILLUP"),
        DoNotAllow("DO_NOT_ALLOW"),

        /**
         * This value is used if a service returns a value for this enum that is not recognized by this
         * version of the SDK.
         */
        UnknownEnumValue(null);

        private final String value;
        private static java.util.Map<String, ExtraColumnHandling> map;

        static {
            map = new java.util.HashMap<>();
            for (ExtraColumnHandling v : ExtraColumnHandling.values()) {
                if (v != UnknownEnumValue) {
                    map.put(v.getValue(), v);
                }
            }
        }

        ExtraColumnHandling(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static ExtraColumnHandling create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn(
                    "Received unknown value '{}' for enum 'ExtraColumnHandling', returning UnknownEnumValue",
                    key);
            return UnknownEnumValue;
        }
    };
    /**
     * The setting for how to handle extra columns/fields.  NULL_FILLUP means that nulls will be loaded into the target for extra columns.
     **/
    @com.fasterxml.jackson.annotation.JsonProperty("extraColumnHandling")
    ExtraColumnHandling extraColumnHandling;
    /**
     * The setting for how to handle missing columns/fields.  NULL_SELECT means that null values will be selected from the source for missing columns.
     **/
    @lombok.extern.slf4j.Slf4j
    public enum MissingColumnHandling {
        Allow("ALLOW"),
        NullSelect("NULL_SELECT"),
        DoNotAllow("DO_NOT_ALLOW"),

        /**
         * This value is used if a service returns a value for this enum that is not recognized by this
         * version of the SDK.
         */
        UnknownEnumValue(null);

        private final String value;
        private static java.util.Map<String, MissingColumnHandling> map;

        static {
            map = new java.util.HashMap<>();
            for (MissingColumnHandling v : MissingColumnHandling.values()) {
                if (v != UnknownEnumValue) {
                    map.put(v.getValue(), v);
                }
            }
        }

        MissingColumnHandling(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static MissingColumnHandling create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn(
                    "Received unknown value '{}' for enum 'MissingColumnHandling', returning UnknownEnumValue",
                    key);
            return UnknownEnumValue;
        }
    };
    /**
     * The setting for how to handle missing columns/fields.  NULL_SELECT means that null values will be selected from the source for missing columns.
     **/
    @com.fasterxml.jackson.annotation.JsonProperty("missingColumnHandling")
    MissingColumnHandling missingColumnHandling;
    /**
     * The setting for how to handle columns/fields with changed data types.
     **/
    @lombok.extern.slf4j.Slf4j
    public enum DataTypeChangeHandling {
        Allow("ALLOW"),
        DoCastIfPossible("DO_CAST_IF_POSSIBLE"),
        DoNotAllow("DO_NOT_ALLOW"),

        /**
         * This value is used if a service returns a value for this enum that is not recognized by this
         * version of the SDK.
         */
        UnknownEnumValue(null);

        private final String value;
        private static java.util.Map<String, DataTypeChangeHandling> map;

        static {
            map = new java.util.HashMap<>();
            for (DataTypeChangeHandling v : DataTypeChangeHandling.values()) {
                if (v != UnknownEnumValue) {
                    map.put(v.getValue(), v);
                }
            }
        }

        DataTypeChangeHandling(String value) {
            this.value = value;
        }

        @com.fasterxml.jackson.annotation.JsonValue
        public String getValue() {
            return value;
        }

        @com.fasterxml.jackson.annotation.JsonCreator
        public static DataTypeChangeHandling create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn(
                    "Received unknown value '{}' for enum 'DataTypeChangeHandling', returning UnknownEnumValue",
                    key);
            return UnknownEnumValue;
        }
    };
    /**
     * The setting for how to handle columns/fields with changed data types.
     **/
    @com.fasterxml.jackson.annotation.JsonProperty("dataTypeChangeHandling")
    DataTypeChangeHandling dataTypeChangeHandling;

    /**
     * If true, display a validation warning for schema changes, even if they are allowed.
     **/
    @com.fasterxml.jackson.annotation.JsonProperty("isValidationWarningIfAllowed")
    Boolean isValidationWarningIfAllowed;

    @com.fasterxml.jackson.annotation.JsonIgnore
    private final java.util.Set<String> __explicitlySet__ = new java.util.HashSet<String>();
}
