/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.datasafe.DataSafeAsync;
import com.oracle.bmc.datasafe.internal.http.ChangeDataSafePrivateEndpointCompartmentConverter;
import com.oracle.bmc.datasafe.internal.http.ChangeOnPremConnectorCompartmentConverter;
import com.oracle.bmc.datasafe.internal.http.CreateDataSafePrivateEndpointConverter;
import com.oracle.bmc.datasafe.internal.http.CreateOnPremConnectorConverter;
import com.oracle.bmc.datasafe.internal.http.DeleteDataSafePrivateEndpointConverter;
import com.oracle.bmc.datasafe.internal.http.DeleteOnPremConnectorConverter;
import com.oracle.bmc.datasafe.internal.http.EnableDataSafeConfigurationConverter;
import com.oracle.bmc.datasafe.internal.http.GenerateOnPremConnectorConfigurationConverter;
import com.oracle.bmc.datasafe.internal.http.GetDataSafeConfigurationConverter;
import com.oracle.bmc.datasafe.internal.http.GetDataSafePrivateEndpointConverter;
import com.oracle.bmc.datasafe.internal.http.GetOnPremConnectorConverter;
import com.oracle.bmc.datasafe.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.datasafe.internal.http.ListDataSafePrivateEndpointsConverter;
import com.oracle.bmc.datasafe.internal.http.ListOnPremConnectorsConverter;
import com.oracle.bmc.datasafe.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.datasafe.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.datasafe.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.datasafe.internal.http.UpdateDataSafePrivateEndpointConverter;
import com.oracle.bmc.datasafe.internal.http.UpdateOnPremConnectorConverter;
import com.oracle.bmc.datasafe.internal.http.UpdateOnPremConnectorWalletConverter;
import com.oracle.bmc.datasafe.requests.ChangeDataSafePrivateEndpointCompartmentRequest;
import com.oracle.bmc.datasafe.requests.ChangeOnPremConnectorCompartmentRequest;
import com.oracle.bmc.datasafe.requests.CreateDataSafePrivateEndpointRequest;
import com.oracle.bmc.datasafe.requests.CreateOnPremConnectorRequest;
import com.oracle.bmc.datasafe.requests.DeleteDataSafePrivateEndpointRequest;
import com.oracle.bmc.datasafe.requests.DeleteOnPremConnectorRequest;
import com.oracle.bmc.datasafe.requests.EnableDataSafeConfigurationRequest;
import com.oracle.bmc.datasafe.requests.GenerateOnPremConnectorConfigurationRequest;
import com.oracle.bmc.datasafe.requests.GetDataSafeConfigurationRequest;
import com.oracle.bmc.datasafe.requests.GetDataSafePrivateEndpointRequest;
import com.oracle.bmc.datasafe.requests.GetOnPremConnectorRequest;
import com.oracle.bmc.datasafe.requests.GetWorkRequestRequest;
import com.oracle.bmc.datasafe.requests.ListDataSafePrivateEndpointsRequest;
import com.oracle.bmc.datasafe.requests.ListOnPremConnectorsRequest;
import com.oracle.bmc.datasafe.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.datasafe.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.datasafe.requests.ListWorkRequestsRequest;
import com.oracle.bmc.datasafe.requests.UpdateDataSafePrivateEndpointRequest;
import com.oracle.bmc.datasafe.requests.UpdateOnPremConnectorRequest;
import com.oracle.bmc.datasafe.requests.UpdateOnPremConnectorWalletRequest;
import com.oracle.bmc.datasafe.responses.ChangeDataSafePrivateEndpointCompartmentResponse;
import com.oracle.bmc.datasafe.responses.ChangeOnPremConnectorCompartmentResponse;
import com.oracle.bmc.datasafe.responses.CreateDataSafePrivateEndpointResponse;
import com.oracle.bmc.datasafe.responses.CreateOnPremConnectorResponse;
import com.oracle.bmc.datasafe.responses.DeleteDataSafePrivateEndpointResponse;
import com.oracle.bmc.datasafe.responses.DeleteOnPremConnectorResponse;
import com.oracle.bmc.datasafe.responses.EnableDataSafeConfigurationResponse;
import com.oracle.bmc.datasafe.responses.GenerateOnPremConnectorConfigurationResponse;
import com.oracle.bmc.datasafe.responses.GetDataSafeConfigurationResponse;
import com.oracle.bmc.datasafe.responses.GetDataSafePrivateEndpointResponse;
import com.oracle.bmc.datasafe.responses.GetOnPremConnectorResponse;
import com.oracle.bmc.datasafe.responses.GetWorkRequestResponse;
import com.oracle.bmc.datasafe.responses.ListDataSafePrivateEndpointsResponse;
import com.oracle.bmc.datasafe.responses.ListOnPremConnectorsResponse;
import com.oracle.bmc.datasafe.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.datasafe.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.datasafe.responses.ListWorkRequestsResponse;
import com.oracle.bmc.datasafe.responses.UpdateDataSafePrivateEndpointResponse;
import com.oracle.bmc.datasafe.responses.UpdateOnPremConnectorResponse;
import com.oracle.bmc.datasafe.responses.UpdateOnPremConnectorWalletResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSafeAsyncClient
implements DataSafeAsync {
    private static final Logger LOG = LoggerFactory.getLogger(DataSafeAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATASAFE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datasafe.{region}.oci.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public DataSafeAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DataSafeAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DataSafeAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DataSafeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DataSafeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DataSafeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DataSafeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public DataSafeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeDataSafePrivateEndpointCompartmentResponse> changeDataSafePrivateEndpointCompartment(ChangeDataSafePrivateEndpointCompartmentRequest request, AsyncHandler<ChangeDataSafePrivateEndpointCompartmentRequest, ChangeDataSafePrivateEndpointCompartmentResponse> handler) {
        LOG.trace("Called async changeDataSafePrivateEndpointCompartment");
        ChangeDataSafePrivateEndpointCompartmentRequest interceptedRequest = ChangeDataSafePrivateEndpointCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeDataSafePrivateEndpointCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeDataSafePrivateEndpointCompartmentResponse> transformer = ChangeDataSafePrivateEndpointCompartmentConverter.fromResponse();
        AsyncHandler<ChangeDataSafePrivateEndpointCompartmentRequest, ChangeDataSafePrivateEndpointCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeDataSafePrivateEndpointCompartmentRequest, ChangeDataSafePrivateEndpointCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeOnPremConnectorCompartmentResponse> changeOnPremConnectorCompartment(ChangeOnPremConnectorCompartmentRequest request, AsyncHandler<ChangeOnPremConnectorCompartmentRequest, ChangeOnPremConnectorCompartmentResponse> handler) {
        LOG.trace("Called async changeOnPremConnectorCompartment");
        ChangeOnPremConnectorCompartmentRequest interceptedRequest = ChangeOnPremConnectorCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeOnPremConnectorCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeOnPremConnectorCompartmentResponse> transformer = ChangeOnPremConnectorCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeOnPremConnectorCompartmentRequest, ChangeOnPremConnectorCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeOnPremConnectorCompartmentRequest, ChangeOnPremConnectorCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateDataSafePrivateEndpointResponse> createDataSafePrivateEndpoint(CreateDataSafePrivateEndpointRequest request, AsyncHandler<CreateDataSafePrivateEndpointRequest, CreateDataSafePrivateEndpointResponse> handler) {
        LOG.trace("Called async createDataSafePrivateEndpoint");
        CreateDataSafePrivateEndpointRequest interceptedRequest = CreateDataSafePrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDataSafePrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDataSafePrivateEndpointResponse> transformer = CreateDataSafePrivateEndpointConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateDataSafePrivateEndpointRequest, CreateDataSafePrivateEndpointResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateDataSafePrivateEndpointRequest, CreateDataSafePrivateEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateOnPremConnectorResponse> createOnPremConnector(CreateOnPremConnectorRequest request, AsyncHandler<CreateOnPremConnectorRequest, CreateOnPremConnectorResponse> handler) {
        LOG.trace("Called async createOnPremConnector");
        CreateOnPremConnectorRequest interceptedRequest = CreateOnPremConnectorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateOnPremConnectorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateOnPremConnectorResponse> transformer = CreateOnPremConnectorConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateOnPremConnectorRequest, CreateOnPremConnectorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateOnPremConnectorRequest, CreateOnPremConnectorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteDataSafePrivateEndpointResponse> deleteDataSafePrivateEndpoint(DeleteDataSafePrivateEndpointRequest request, AsyncHandler<DeleteDataSafePrivateEndpointRequest, DeleteDataSafePrivateEndpointResponse> handler) {
        LOG.trace("Called async deleteDataSafePrivateEndpoint");
        DeleteDataSafePrivateEndpointRequest interceptedRequest = DeleteDataSafePrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDataSafePrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDataSafePrivateEndpointResponse> transformer = DeleteDataSafePrivateEndpointConverter.fromResponse();
        AsyncHandler<DeleteDataSafePrivateEndpointRequest, DeleteDataSafePrivateEndpointResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteDataSafePrivateEndpointRequest, DeleteDataSafePrivateEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteOnPremConnectorResponse> deleteOnPremConnector(DeleteOnPremConnectorRequest request, AsyncHandler<DeleteOnPremConnectorRequest, DeleteOnPremConnectorResponse> handler) {
        LOG.trace("Called async deleteOnPremConnector");
        DeleteOnPremConnectorRequest interceptedRequest = DeleteOnPremConnectorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteOnPremConnectorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteOnPremConnectorResponse> transformer = DeleteOnPremConnectorConverter.fromResponse();
        AsyncHandler<DeleteOnPremConnectorRequest, DeleteOnPremConnectorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteOnPremConnectorRequest, DeleteOnPremConnectorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<EnableDataSafeConfigurationResponse> enableDataSafeConfiguration(EnableDataSafeConfigurationRequest request, AsyncHandler<EnableDataSafeConfigurationRequest, EnableDataSafeConfigurationResponse> handler) {
        LOG.trace("Called async enableDataSafeConfiguration");
        EnableDataSafeConfigurationRequest interceptedRequest = EnableDataSafeConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = EnableDataSafeConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, EnableDataSafeConfigurationResponse> transformer = EnableDataSafeConfigurationConverter.fromResponse();
        AsyncHandler<EnableDataSafeConfigurationRequest, EnableDataSafeConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<EnableDataSafeConfigurationRequest, EnableDataSafeConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GenerateOnPremConnectorConfigurationResponse> generateOnPremConnectorConfiguration(GenerateOnPremConnectorConfigurationRequest request, AsyncHandler<GenerateOnPremConnectorConfigurationRequest, GenerateOnPremConnectorConfigurationResponse> handler) {
        LOG.trace("Called async generateOnPremConnectorConfiguration");
        GenerateOnPremConnectorConfigurationRequest interceptedRequest = GenerateOnPremConnectorConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GenerateOnPremConnectorConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GenerateOnPremConnectorConfigurationResponse> transformer = GenerateOnPremConnectorConfigurationConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<GenerateOnPremConnectorConfigurationRequest, GenerateOnPremConnectorConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GenerateOnPremConnectorConfigurationRequest, GenerateOnPremConnectorConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDataSafeConfigurationResponse> getDataSafeConfiguration(GetDataSafeConfigurationRequest request, AsyncHandler<GetDataSafeConfigurationRequest, GetDataSafeConfigurationResponse> handler) {
        LOG.trace("Called async getDataSafeConfiguration");
        GetDataSafeConfigurationRequest interceptedRequest = GetDataSafeConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataSafeConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDataSafeConfigurationResponse> transformer = GetDataSafeConfigurationConverter.fromResponse();
        AsyncHandler<GetDataSafeConfigurationRequest, GetDataSafeConfigurationResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDataSafeConfigurationRequest, GetDataSafeConfigurationResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetDataSafePrivateEndpointResponse> getDataSafePrivateEndpoint(GetDataSafePrivateEndpointRequest request, AsyncHandler<GetDataSafePrivateEndpointRequest, GetDataSafePrivateEndpointResponse> handler) {
        LOG.trace("Called async getDataSafePrivateEndpoint");
        GetDataSafePrivateEndpointRequest interceptedRequest = GetDataSafePrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataSafePrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDataSafePrivateEndpointResponse> transformer = GetDataSafePrivateEndpointConverter.fromResponse();
        AsyncHandler<GetDataSafePrivateEndpointRequest, GetDataSafePrivateEndpointResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetDataSafePrivateEndpointRequest, GetDataSafePrivateEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetOnPremConnectorResponse> getOnPremConnector(GetOnPremConnectorRequest request, AsyncHandler<GetOnPremConnectorRequest, GetOnPremConnectorResponse> handler) {
        LOG.trace("Called async getOnPremConnector");
        GetOnPremConnectorRequest interceptedRequest = GetOnPremConnectorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetOnPremConnectorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetOnPremConnectorResponse> transformer = GetOnPremConnectorConverter.fromResponse();
        AsyncHandler<GetOnPremConnectorRequest, GetOnPremConnectorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetOnPremConnectorRequest, GetOnPremConnectorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetWorkRequestResponse> getWorkRequest(GetWorkRequestRequest request, AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handler) {
        LOG.trace("Called async getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        AsyncHandler<GetWorkRequestRequest, GetWorkRequestResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetWorkRequestRequest, GetWorkRequestResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListDataSafePrivateEndpointsResponse> listDataSafePrivateEndpoints(ListDataSafePrivateEndpointsRequest request, AsyncHandler<ListDataSafePrivateEndpointsRequest, ListDataSafePrivateEndpointsResponse> handler) {
        LOG.trace("Called async listDataSafePrivateEndpoints");
        ListDataSafePrivateEndpointsRequest interceptedRequest = ListDataSafePrivateEndpointsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDataSafePrivateEndpointsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDataSafePrivateEndpointsResponse> transformer = ListDataSafePrivateEndpointsConverter.fromResponse();
        AsyncHandler<ListDataSafePrivateEndpointsRequest, ListDataSafePrivateEndpointsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListDataSafePrivateEndpointsRequest, ListDataSafePrivateEndpointsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListOnPremConnectorsResponse> listOnPremConnectors(ListOnPremConnectorsRequest request, AsyncHandler<ListOnPremConnectorsRequest, ListOnPremConnectorsResponse> handler) {
        LOG.trace("Called async listOnPremConnectors");
        ListOnPremConnectorsRequest interceptedRequest = ListOnPremConnectorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListOnPremConnectorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListOnPremConnectorsResponse> transformer = ListOnPremConnectorsConverter.fromResponse();
        AsyncHandler<ListOnPremConnectorsRequest, ListOnPremConnectorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListOnPremConnectorsRequest, ListOnPremConnectorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestErrorsResponse> listWorkRequestErrors(ListWorkRequestErrorsRequest request, AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handler) {
        LOG.trace("Called async listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        AsyncHandler<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestLogsResponse> listWorkRequestLogs(ListWorkRequestLogsRequest request, AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handler) {
        LOG.trace("Called async listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        AsyncHandler<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListWorkRequestsResponse> listWorkRequests(ListWorkRequestsRequest request, AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handler) {
        LOG.trace("Called async listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        AsyncHandler<ListWorkRequestsRequest, ListWorkRequestsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListWorkRequestsRequest, ListWorkRequestsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateDataSafePrivateEndpointResponse> updateDataSafePrivateEndpoint(UpdateDataSafePrivateEndpointRequest request, AsyncHandler<UpdateDataSafePrivateEndpointRequest, UpdateDataSafePrivateEndpointResponse> handler) {
        LOG.trace("Called async updateDataSafePrivateEndpoint");
        UpdateDataSafePrivateEndpointRequest interceptedRequest = UpdateDataSafePrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDataSafePrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDataSafePrivateEndpointResponse> transformer = UpdateDataSafePrivateEndpointConverter.fromResponse();
        AsyncHandler<UpdateDataSafePrivateEndpointRequest, UpdateDataSafePrivateEndpointResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateDataSafePrivateEndpointRequest, UpdateDataSafePrivateEndpointResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateOnPremConnectorResponse> updateOnPremConnector(UpdateOnPremConnectorRequest request, AsyncHandler<UpdateOnPremConnectorRequest, UpdateOnPremConnectorResponse> handler) {
        LOG.trace("Called async updateOnPremConnector");
        UpdateOnPremConnectorRequest interceptedRequest = UpdateOnPremConnectorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateOnPremConnectorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateOnPremConnectorResponse> transformer = UpdateOnPremConnectorConverter.fromResponse();
        AsyncHandler<UpdateOnPremConnectorRequest, UpdateOnPremConnectorResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateOnPremConnectorRequest, UpdateOnPremConnectorResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateOnPremConnectorWalletResponse> updateOnPremConnectorWallet(UpdateOnPremConnectorWalletRequest request, AsyncHandler<UpdateOnPremConnectorWalletRequest, UpdateOnPremConnectorWalletResponse> handler) {
        LOG.trace("Called async updateOnPremConnectorWallet");
        UpdateOnPremConnectorWalletRequest interceptedRequest = UpdateOnPremConnectorWalletConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateOnPremConnectorWalletConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateOnPremConnectorWalletResponse> transformer = UpdateOnPremConnectorWalletConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<UpdateOnPremConnectorWalletRequest, UpdateOnPremConnectorWalletResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateOnPremConnectorWalletRequest, UpdateOnPremConnectorWalletResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataSafeAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public DataSafeAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DataSafeAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

