/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.datasafe.DataSafe;
import com.oracle.bmc.datasafe.DataSafePaginators;
import com.oracle.bmc.datasafe.DataSafeWaiters;
import com.oracle.bmc.datasafe.internal.http.ChangeDataSafePrivateEndpointCompartmentConverter;
import com.oracle.bmc.datasafe.internal.http.ChangeOnPremConnectorCompartmentConverter;
import com.oracle.bmc.datasafe.internal.http.CreateDataSafePrivateEndpointConverter;
import com.oracle.bmc.datasafe.internal.http.CreateOnPremConnectorConverter;
import com.oracle.bmc.datasafe.internal.http.DeleteDataSafePrivateEndpointConverter;
import com.oracle.bmc.datasafe.internal.http.DeleteOnPremConnectorConverter;
import com.oracle.bmc.datasafe.internal.http.EnableDataSafeConfigurationConverter;
import com.oracle.bmc.datasafe.internal.http.GenerateOnPremConnectorConfigurationConverter;
import com.oracle.bmc.datasafe.internal.http.GetDataSafeConfigurationConverter;
import com.oracle.bmc.datasafe.internal.http.GetDataSafePrivateEndpointConverter;
import com.oracle.bmc.datasafe.internal.http.GetOnPremConnectorConverter;
import com.oracle.bmc.datasafe.internal.http.GetWorkRequestConverter;
import com.oracle.bmc.datasafe.internal.http.ListDataSafePrivateEndpointsConverter;
import com.oracle.bmc.datasafe.internal.http.ListOnPremConnectorsConverter;
import com.oracle.bmc.datasafe.internal.http.ListWorkRequestErrorsConverter;
import com.oracle.bmc.datasafe.internal.http.ListWorkRequestLogsConverter;
import com.oracle.bmc.datasafe.internal.http.ListWorkRequestsConverter;
import com.oracle.bmc.datasafe.internal.http.UpdateDataSafePrivateEndpointConverter;
import com.oracle.bmc.datasafe.internal.http.UpdateOnPremConnectorConverter;
import com.oracle.bmc.datasafe.internal.http.UpdateOnPremConnectorWalletConverter;
import com.oracle.bmc.datasafe.requests.ChangeDataSafePrivateEndpointCompartmentRequest;
import com.oracle.bmc.datasafe.requests.ChangeOnPremConnectorCompartmentRequest;
import com.oracle.bmc.datasafe.requests.CreateDataSafePrivateEndpointRequest;
import com.oracle.bmc.datasafe.requests.CreateOnPremConnectorRequest;
import com.oracle.bmc.datasafe.requests.DeleteDataSafePrivateEndpointRequest;
import com.oracle.bmc.datasafe.requests.DeleteOnPremConnectorRequest;
import com.oracle.bmc.datasafe.requests.EnableDataSafeConfigurationRequest;
import com.oracle.bmc.datasafe.requests.GenerateOnPremConnectorConfigurationRequest;
import com.oracle.bmc.datasafe.requests.GetDataSafeConfigurationRequest;
import com.oracle.bmc.datasafe.requests.GetDataSafePrivateEndpointRequest;
import com.oracle.bmc.datasafe.requests.GetOnPremConnectorRequest;
import com.oracle.bmc.datasafe.requests.GetWorkRequestRequest;
import com.oracle.bmc.datasafe.requests.ListDataSafePrivateEndpointsRequest;
import com.oracle.bmc.datasafe.requests.ListOnPremConnectorsRequest;
import com.oracle.bmc.datasafe.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.datasafe.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.datasafe.requests.ListWorkRequestsRequest;
import com.oracle.bmc.datasafe.requests.UpdateDataSafePrivateEndpointRequest;
import com.oracle.bmc.datasafe.requests.UpdateOnPremConnectorRequest;
import com.oracle.bmc.datasafe.requests.UpdateOnPremConnectorWalletRequest;
import com.oracle.bmc.datasafe.responses.ChangeDataSafePrivateEndpointCompartmentResponse;
import com.oracle.bmc.datasafe.responses.ChangeOnPremConnectorCompartmentResponse;
import com.oracle.bmc.datasafe.responses.CreateDataSafePrivateEndpointResponse;
import com.oracle.bmc.datasafe.responses.CreateOnPremConnectorResponse;
import com.oracle.bmc.datasafe.responses.DeleteDataSafePrivateEndpointResponse;
import com.oracle.bmc.datasafe.responses.DeleteOnPremConnectorResponse;
import com.oracle.bmc.datasafe.responses.EnableDataSafeConfigurationResponse;
import com.oracle.bmc.datasafe.responses.GenerateOnPremConnectorConfigurationResponse;
import com.oracle.bmc.datasafe.responses.GetDataSafeConfigurationResponse;
import com.oracle.bmc.datasafe.responses.GetDataSafePrivateEndpointResponse;
import com.oracle.bmc.datasafe.responses.GetOnPremConnectorResponse;
import com.oracle.bmc.datasafe.responses.GetWorkRequestResponse;
import com.oracle.bmc.datasafe.responses.ListDataSafePrivateEndpointsResponse;
import com.oracle.bmc.datasafe.responses.ListOnPremConnectorsResponse;
import com.oracle.bmc.datasafe.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.datasafe.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.datasafe.responses.ListWorkRequestsResponse;
import com.oracle.bmc.datasafe.responses.UpdateDataSafePrivateEndpointResponse;
import com.oracle.bmc.datasafe.responses.UpdateOnPremConnectorResponse;
import com.oracle.bmc.datasafe.responses.UpdateOnPremConnectorWalletResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataSafeClient
implements DataSafe {
    private static final Logger LOG = LoggerFactory.getLogger(DataSafeClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATASAFE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datasafe.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final DataSafeWaiters waiters;
    private final DataSafePaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public DataSafeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public DataSafeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public DataSafeClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public DataSafeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public DataSafeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public DataSafeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public DataSafeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public DataSafeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected DataSafeClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("DataSafe-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new DataSafeWaiters(executorService, this);
        this.paginators = new DataSafePaginators(this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public ChangeDataSafePrivateEndpointCompartmentResponse changeDataSafePrivateEndpointCompartment(ChangeDataSafePrivateEndpointCompartmentRequest request) {
        LOG.trace("Called changeDataSafePrivateEndpointCompartment");
        ChangeDataSafePrivateEndpointCompartmentRequest interceptedRequest = ChangeDataSafePrivateEndpointCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeDataSafePrivateEndpointCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeDataSafePrivateEndpointCompartmentResponse> transformer = ChangeDataSafePrivateEndpointCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ChangeDataSafePrivateEndpointCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeDataSafePrivateEndpointCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeDataSafePrivateEndpointCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeDataSafePrivateEndpointCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeOnPremConnectorCompartmentResponse changeOnPremConnectorCompartment(ChangeOnPremConnectorCompartmentRequest request) {
        LOG.trace("Called changeOnPremConnectorCompartment");
        ChangeOnPremConnectorCompartmentRequest interceptedRequest = ChangeOnPremConnectorCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeOnPremConnectorCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeOnPremConnectorCompartmentResponse> transformer = ChangeOnPremConnectorCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeOnPremConnectorCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeOnPremConnectorCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeOnPremConnectorCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeOnPremConnectorCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateDataSafePrivateEndpointResponse createDataSafePrivateEndpoint(CreateDataSafePrivateEndpointRequest request) {
        LOG.trace("Called createDataSafePrivateEndpoint");
        CreateDataSafePrivateEndpointRequest interceptedRequest = CreateDataSafePrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateDataSafePrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateDataSafePrivateEndpointResponse> transformer = CreateDataSafePrivateEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateDataSafePrivateEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateDataSafePrivateEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateDataSafePrivateEndpointDetails(), (BmcRequest)retriedRequest);
                return (CreateDataSafePrivateEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateOnPremConnectorResponse createOnPremConnector(CreateOnPremConnectorRequest request) {
        LOG.trace("Called createOnPremConnector");
        CreateOnPremConnectorRequest interceptedRequest = CreateOnPremConnectorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateOnPremConnectorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateOnPremConnectorResponse> transformer = CreateOnPremConnectorConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateOnPremConnectorResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateOnPremConnectorResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateOnPremConnectorDetails(), (BmcRequest)retriedRequest);
                return (CreateOnPremConnectorResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteDataSafePrivateEndpointResponse deleteDataSafePrivateEndpoint(DeleteDataSafePrivateEndpointRequest request) {
        LOG.trace("Called deleteDataSafePrivateEndpoint");
        DeleteDataSafePrivateEndpointRequest interceptedRequest = DeleteDataSafePrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteDataSafePrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteDataSafePrivateEndpointResponse> transformer = DeleteDataSafePrivateEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteDataSafePrivateEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteDataSafePrivateEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteDataSafePrivateEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteOnPremConnectorResponse deleteOnPremConnector(DeleteOnPremConnectorRequest request) {
        LOG.trace("Called deleteOnPremConnector");
        DeleteOnPremConnectorRequest interceptedRequest = DeleteOnPremConnectorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteOnPremConnectorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteOnPremConnectorResponse> transformer = DeleteOnPremConnectorConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteOnPremConnectorResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteOnPremConnectorResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteOnPremConnectorResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public EnableDataSafeConfigurationResponse enableDataSafeConfiguration(EnableDataSafeConfigurationRequest request) {
        LOG.trace("Called enableDataSafeConfiguration");
        EnableDataSafeConfigurationRequest interceptedRequest = EnableDataSafeConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = EnableDataSafeConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, EnableDataSafeConfigurationResponse> transformer = EnableDataSafeConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (EnableDataSafeConfigurationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (EnableDataSafeConfigurationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getEnableDataSafeConfigurationDetails(), (BmcRequest)retriedRequest);
                return (EnableDataSafeConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GenerateOnPremConnectorConfigurationResponse generateOnPremConnectorConfiguration(GenerateOnPremConnectorConfigurationRequest request) {
        LOG.trace("Called generateOnPremConnectorConfiguration");
        GenerateOnPremConnectorConfigurationRequest interceptedRequest = GenerateOnPremConnectorConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GenerateOnPremConnectorConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GenerateOnPremConnectorConfigurationResponse> transformer = GenerateOnPremConnectorConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (GenerateOnPremConnectorConfigurationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GenerateOnPremConnectorConfigurationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getGenerateOnPremConnectorConfigurationDetails(), (BmcRequest)retriedRequest);
                return (GenerateOnPremConnectorConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDataSafeConfigurationResponse getDataSafeConfiguration(GetDataSafeConfigurationRequest request) {
        LOG.trace("Called getDataSafeConfiguration");
        GetDataSafeConfigurationRequest interceptedRequest = GetDataSafeConfigurationConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataSafeConfigurationConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDataSafeConfigurationResponse> transformer = GetDataSafeConfigurationConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDataSafeConfigurationResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDataSafeConfigurationResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDataSafeConfigurationResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetDataSafePrivateEndpointResponse getDataSafePrivateEndpoint(GetDataSafePrivateEndpointRequest request) {
        LOG.trace("Called getDataSafePrivateEndpoint");
        GetDataSafePrivateEndpointRequest interceptedRequest = GetDataSafePrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetDataSafePrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetDataSafePrivateEndpointResponse> transformer = GetDataSafePrivateEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetDataSafePrivateEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetDataSafePrivateEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetDataSafePrivateEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetOnPremConnectorResponse getOnPremConnector(GetOnPremConnectorRequest request) {
        LOG.trace("Called getOnPremConnector");
        GetOnPremConnectorRequest interceptedRequest = GetOnPremConnectorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetOnPremConnectorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetOnPremConnectorResponse> transformer = GetOnPremConnectorConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetOnPremConnectorResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetOnPremConnectorResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetOnPremConnectorResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWorkRequestResponse getWorkRequest(GetWorkRequestRequest request) {
        LOG.trace("Called getWorkRequest");
        GetWorkRequestRequest interceptedRequest = GetWorkRequestConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWorkRequestConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWorkRequestResponse> transformer = GetWorkRequestConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWorkRequestResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWorkRequestResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWorkRequestResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListDataSafePrivateEndpointsResponse listDataSafePrivateEndpoints(ListDataSafePrivateEndpointsRequest request) {
        LOG.trace("Called listDataSafePrivateEndpoints");
        ListDataSafePrivateEndpointsRequest interceptedRequest = ListDataSafePrivateEndpointsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListDataSafePrivateEndpointsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListDataSafePrivateEndpointsResponse> transformer = ListDataSafePrivateEndpointsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListDataSafePrivateEndpointsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListDataSafePrivateEndpointsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListDataSafePrivateEndpointsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListOnPremConnectorsResponse listOnPremConnectors(ListOnPremConnectorsRequest request) {
        LOG.trace("Called listOnPremConnectors");
        ListOnPremConnectorsRequest interceptedRequest = ListOnPremConnectorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListOnPremConnectorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListOnPremConnectorsResponse> transformer = ListOnPremConnectorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListOnPremConnectorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListOnPremConnectorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListOnPremConnectorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestErrorsResponse listWorkRequestErrors(ListWorkRequestErrorsRequest request) {
        LOG.trace("Called listWorkRequestErrors");
        ListWorkRequestErrorsRequest interceptedRequest = ListWorkRequestErrorsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestErrorsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestErrorsResponse> transformer = ListWorkRequestErrorsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestErrorsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestErrorsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestErrorsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestLogsResponse listWorkRequestLogs(ListWorkRequestLogsRequest request) {
        LOG.trace("Called listWorkRequestLogs");
        ListWorkRequestLogsRequest interceptedRequest = ListWorkRequestLogsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestLogsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestLogsResponse> transformer = ListWorkRequestLogsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestLogsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestLogsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestLogsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListWorkRequestsResponse listWorkRequests(ListWorkRequestsRequest request) {
        LOG.trace("Called listWorkRequests");
        ListWorkRequestsRequest interceptedRequest = ListWorkRequestsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListWorkRequestsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListWorkRequestsResponse> transformer = ListWorkRequestsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListWorkRequestsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListWorkRequestsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListWorkRequestsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateDataSafePrivateEndpointResponse updateDataSafePrivateEndpoint(UpdateDataSafePrivateEndpointRequest request) {
        LOG.trace("Called updateDataSafePrivateEndpoint");
        UpdateDataSafePrivateEndpointRequest interceptedRequest = UpdateDataSafePrivateEndpointConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateDataSafePrivateEndpointConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateDataSafePrivateEndpointResponse> transformer = UpdateDataSafePrivateEndpointConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateDataSafePrivateEndpointResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateDataSafePrivateEndpointResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateDataSafePrivateEndpointDetails(), (BmcRequest)retriedRequest);
                return (UpdateDataSafePrivateEndpointResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateOnPremConnectorResponse updateOnPremConnector(UpdateOnPremConnectorRequest request) {
        LOG.trace("Called updateOnPremConnector");
        UpdateOnPremConnectorRequest interceptedRequest = UpdateOnPremConnectorConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateOnPremConnectorConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateOnPremConnectorResponse> transformer = UpdateOnPremConnectorConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateOnPremConnectorResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateOnPremConnectorResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateOnPremConnectorDetails(), (BmcRequest)retriedRequest);
                return (UpdateOnPremConnectorResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateOnPremConnectorWalletResponse updateOnPremConnectorWallet(UpdateOnPremConnectorWalletRequest request) {
        LOG.trace("Called updateOnPremConnectorWallet");
        UpdateOnPremConnectorWalletRequest interceptedRequest = UpdateOnPremConnectorWalletConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateOnPremConnectorWalletConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateOnPremConnectorWalletResponse> transformer = UpdateOnPremConnectorWalletConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (UpdateOnPremConnectorWalletResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateOnPremConnectorWalletResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateOnPremConnectorWalletDetails(), (BmcRequest)retriedRequest);
                return (UpdateOnPremConnectorWalletResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DataSafeWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public DataSafePaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataSafeClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public DataSafeClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new DataSafeClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

