/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.datasafe.DataSafe;
import com.oracle.bmc.datasafe.model.DataSafePrivateEndpointSummary;
import com.oracle.bmc.datasafe.model.OnPremConnectorSummary;
import com.oracle.bmc.datasafe.model.WorkRequestError;
import com.oracle.bmc.datasafe.model.WorkRequestLogEntry;
import com.oracle.bmc.datasafe.model.WorkRequestSummary;
import com.oracle.bmc.datasafe.requests.ListDataSafePrivateEndpointsRequest;
import com.oracle.bmc.datasafe.requests.ListOnPremConnectorsRequest;
import com.oracle.bmc.datasafe.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.datasafe.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.datasafe.requests.ListWorkRequestsRequest;
import com.oracle.bmc.datasafe.responses.ListDataSafePrivateEndpointsResponse;
import com.oracle.bmc.datasafe.responses.ListOnPremConnectorsResponse;
import com.oracle.bmc.datasafe.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.datasafe.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.datasafe.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class DataSafePaginators {
    private final DataSafe client;

    public Iterable<ListDataSafePrivateEndpointsResponse> listDataSafePrivateEndpointsResponseIterator(final ListDataSafePrivateEndpointsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDataSafePrivateEndpointsRequest.Builder>(){

            public ListDataSafePrivateEndpointsRequest.Builder get() {
                return ListDataSafePrivateEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataSafePrivateEndpointsResponse, String>(){

            public String apply(ListDataSafePrivateEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataSafePrivateEndpointsRequest.Builder>, ListDataSafePrivateEndpointsRequest>(){

            public ListDataSafePrivateEndpointsRequest apply(RequestBuilderAndToken<ListDataSafePrivateEndpointsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDataSafePrivateEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataSafePrivateEndpointsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDataSafePrivateEndpointsRequest, ListDataSafePrivateEndpointsResponse>(){

            public ListDataSafePrivateEndpointsResponse apply(ListDataSafePrivateEndpointsRequest request) {
                return DataSafePaginators.this.client.listDataSafePrivateEndpoints(request);
            }
        });
    }

    public Iterable<DataSafePrivateEndpointSummary> listDataSafePrivateEndpointsRecordIterator(final ListDataSafePrivateEndpointsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDataSafePrivateEndpointsRequest.Builder>(){

            public ListDataSafePrivateEndpointsRequest.Builder get() {
                return ListDataSafePrivateEndpointsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDataSafePrivateEndpointsResponse, String>(){

            public String apply(ListDataSafePrivateEndpointsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDataSafePrivateEndpointsRequest.Builder>, ListDataSafePrivateEndpointsRequest>(){

            public ListDataSafePrivateEndpointsRequest apply(RequestBuilderAndToken<ListDataSafePrivateEndpointsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDataSafePrivateEndpointsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDataSafePrivateEndpointsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDataSafePrivateEndpointsRequest, ListDataSafePrivateEndpointsResponse>(){

            public ListDataSafePrivateEndpointsResponse apply(ListDataSafePrivateEndpointsRequest request) {
                return DataSafePaginators.this.client.listDataSafePrivateEndpoints(request);
            }
        }, (Function)new Function<ListDataSafePrivateEndpointsResponse, List<DataSafePrivateEndpointSummary>>(){

            public List<DataSafePrivateEndpointSummary> apply(ListDataSafePrivateEndpointsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListOnPremConnectorsResponse> listOnPremConnectorsResponseIterator(final ListOnPremConnectorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListOnPremConnectorsRequest.Builder>(){

            public ListOnPremConnectorsRequest.Builder get() {
                return ListOnPremConnectorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOnPremConnectorsResponse, String>(){

            public String apply(ListOnPremConnectorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOnPremConnectorsRequest.Builder>, ListOnPremConnectorsRequest>(){

            public ListOnPremConnectorsRequest apply(RequestBuilderAndToken<ListOnPremConnectorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListOnPremConnectorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOnPremConnectorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListOnPremConnectorsRequest, ListOnPremConnectorsResponse>(){

            public ListOnPremConnectorsResponse apply(ListOnPremConnectorsRequest request) {
                return DataSafePaginators.this.client.listOnPremConnectors(request);
            }
        });
    }

    public Iterable<OnPremConnectorSummary> listOnPremConnectorsRecordIterator(final ListOnPremConnectorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListOnPremConnectorsRequest.Builder>(){

            public ListOnPremConnectorsRequest.Builder get() {
                return ListOnPremConnectorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListOnPremConnectorsResponse, String>(){

            public String apply(ListOnPremConnectorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListOnPremConnectorsRequest.Builder>, ListOnPremConnectorsRequest>(){

            public ListOnPremConnectorsRequest apply(RequestBuilderAndToken<ListOnPremConnectorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListOnPremConnectorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListOnPremConnectorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListOnPremConnectorsRequest, ListOnPremConnectorsResponse>(){

            public ListOnPremConnectorsResponse apply(ListOnPremConnectorsRequest request) {
                return DataSafePaginators.this.client.listOnPremConnectors(request);
            }
        }, (Function)new Function<ListOnPremConnectorsResponse, List<OnPremConnectorSummary>>(){

            public List<OnPremConnectorSummary> apply(ListOnPremConnectorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DataSafePaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return DataSafePaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DataSafePaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return DataSafePaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DataSafePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequestSummary> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return DataSafePaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequestSummary>>(){

            public List<WorkRequestSummary> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public DataSafePaginators(DataSafe client) {
        this.client = client;
    }
}

