/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.dns.model.CreateZoneBaseDetails;
import com.oracle.bmc.dns.model.ExternalMaster;
import com.oracle.bmc.dns.model.Scope;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="migrationSource")
@JsonFilter(value="explicitlySetFilter")
public final class CreateZoneDetails
extends CreateZoneBaseDetails {
    @JsonProperty(value="zoneType")
    private final ZoneType zoneType;
    @JsonProperty(value="viewId")
    private final String viewId;
    @JsonProperty(value="scope")
    private final Scope scope;
    @JsonProperty(value="externalMasters")
    private final List<ExternalMaster> externalMasters;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public CreateZoneDetails(String name, String compartmentId, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, ZoneType zoneType, String viewId, Scope scope, List<ExternalMaster> externalMasters) {
        super(name, compartmentId, freeformTags, definedTags);
        this.zoneType = zoneType;
        this.viewId = viewId;
        this.scope = scope;
        this.externalMasters = externalMasters;
    }

    public Builder toBuilder() {
        return new Builder().zoneType(this.zoneType).viewId(this.viewId).scope(this.scope).externalMasters(this.externalMasters);
    }

    public ZoneType getZoneType() {
        return this.zoneType;
    }

    public String getViewId() {
        return this.viewId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public List<ExternalMaster> getExternalMasters() {
        return this.externalMasters;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    @Override
    public String toString() {
        return "CreateZoneDetails(super=" + super.toString() + ", zoneType=" + (Object)((Object)this.getZoneType()) + ", viewId=" + this.getViewId() + ", scope=" + (Object)((Object)this.getScope()) + ", externalMasters=" + this.getExternalMasters() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateZoneDetails)) {
            return false;
        }
        CreateZoneDetails other = (CreateZoneDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ZoneType this$zoneType = this.getZoneType();
        ZoneType other$zoneType = other.getZoneType();
        if (this$zoneType == null ? other$zoneType != null : !((Object)((Object)this$zoneType)).equals((Object)other$zoneType)) {
            return false;
        }
        String this$viewId = this.getViewId();
        String other$viewId = other.getViewId();
        if (this$viewId == null ? other$viewId != null : !this$viewId.equals(other$viewId)) {
            return false;
        }
        Scope this$scope = this.getScope();
        Scope other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)((Object)this$scope)).equals((Object)other$scope)) {
            return false;
        }
        List<ExternalMaster> this$externalMasters = this.getExternalMasters();
        List<ExternalMaster> other$externalMasters = other.getExternalMasters();
        if (this$externalMasters == null ? other$externalMasters != null : !((Object)this$externalMasters).equals(other$externalMasters)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CreateZoneDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ZoneType $zoneType = this.getZoneType();
        result = result * 59 + ($zoneType == null ? 43 : ((Object)((Object)$zoneType)).hashCode());
        String $viewId = this.getViewId();
        result = result * 59 + ($viewId == null ? 43 : $viewId.hashCode());
        Scope $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)((Object)$scope)).hashCode());
        List<ExternalMaster> $externalMasters = this.getExternalMasters();
        result = result * 59 + ($externalMasters == null ? 43 : ((Object)$externalMasters).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public static enum ZoneType {
        Primary("PRIMARY"),
        Secondary("SECONDARY");

        private final String value;
        private static Map<String, ZoneType> map;

        private ZoneType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ZoneType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ZoneType: " + key);
        }

        static {
            map = new HashMap<String, ZoneType>();
            for (ZoneType v : ZoneType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="zoneType")
        private ZoneType zoneType;
        @JsonProperty(value="viewId")
        private String viewId;
        @JsonProperty(value="scope")
        private Scope scope;
        @JsonProperty(value="externalMasters")
        private List<ExternalMaster> externalMasters;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder zoneType(ZoneType zoneType) {
            this.zoneType = zoneType;
            this.__explicitlySet__.add("zoneType");
            return this;
        }

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            this.__explicitlySet__.add("viewId");
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            this.__explicitlySet__.add("scope");
            return this;
        }

        public Builder externalMasters(List<ExternalMaster> externalMasters) {
            this.externalMasters = externalMasters;
            this.__explicitlySet__.add("externalMasters");
            return this;
        }

        public CreateZoneDetails build() {
            CreateZoneDetails __instance__ = new CreateZoneDetails(this.name, this.compartmentId, this.freeformTags, this.definedTags, this.zoneType, this.viewId, this.scope, this.externalMasters);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(CreateZoneDetails o) {
            Builder copiedBuilder = this.name(o.getName()).compartmentId(o.getCompartmentId()).freeformTags(o.getFreeformTags()).definedTags(o.getDefinedTags()).zoneType(o.getZoneType()).viewId(o.getViewId()).scope(o.getScope()).externalMasters(o.getExternalMasters());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "CreateZoneDetails.Builder(zoneType=" + (Object)((Object)this.zoneType) + ", viewId=" + this.viewId + ", scope=" + (Object)((Object)this.scope) + ", externalMasters=" + this.externalMasters + ")";
        }
    }
}

