/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dns.requests;

import com.oracle.bmc.dns.model.Scope;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DeleteZoneRequest
extends BmcRequest<Void> {
    private String zoneNameOrId;
    private String ifMatch;
    private String ifUnmodifiedSince;
    private String opcRequestId;
    private Scope scope;
    private String viewId;
    private String compartmentId;

    @ConstructorProperties(value={"zoneNameOrId", "ifMatch", "ifUnmodifiedSince", "opcRequestId", "scope", "viewId", "compartmentId"})
    DeleteZoneRequest(String zoneNameOrId, String ifMatch, String ifUnmodifiedSince, String opcRequestId, Scope scope, String viewId, String compartmentId) {
        this.zoneNameOrId = zoneNameOrId;
        this.ifMatch = ifMatch;
        this.ifUnmodifiedSince = ifUnmodifiedSince;
        this.opcRequestId = opcRequestId;
        this.scope = scope;
        this.viewId = viewId;
        this.compartmentId = compartmentId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getZoneNameOrId() {
        return this.zoneNameOrId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getIfUnmodifiedSince() {
        return this.ifUnmodifiedSince;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Scope getScope() {
        return this.scope;
    }

    public String getViewId() {
        return this.viewId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteZoneRequest, Void> {
        private String zoneNameOrId;
        private String ifMatch;
        private String ifUnmodifiedSince;
        private String opcRequestId;
        private Scope scope;
        private String viewId;
        private String compartmentId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteZoneRequest o) {
            this.zoneNameOrId(o.getZoneNameOrId());
            this.ifMatch(o.getIfMatch());
            this.ifUnmodifiedSince(o.getIfUnmodifiedSince());
            this.opcRequestId(o.getOpcRequestId());
            this.scope(o.getScope());
            this.viewId(o.getViewId());
            this.compartmentId(o.getCompartmentId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteZoneRequest build() {
            DeleteZoneRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder zoneNameOrId(String zoneNameOrId) {
            this.zoneNameOrId = zoneNameOrId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder ifUnmodifiedSince(String ifUnmodifiedSince) {
            this.ifUnmodifiedSince = ifUnmodifiedSince;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public DeleteZoneRequest buildWithoutInvocationCallback() {
            return new DeleteZoneRequest(this.zoneNameOrId, this.ifMatch, this.ifUnmodifiedSince, this.opcRequestId, this.scope, this.viewId, this.compartmentId);
        }

        public String toString() {
            return "DeleteZoneRequest.Builder(zoneNameOrId=" + this.zoneNameOrId + ", ifMatch=" + this.ifMatch + ", ifUnmodifiedSince=" + this.ifUnmodifiedSince + ", opcRequestId=" + this.opcRequestId + ", scope=" + (Object)((Object)this.scope) + ", viewId=" + this.viewId + ", compartmentId=" + this.compartmentId + ")";
        }
    }
}

