/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.dts;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.dts.TransferAppliance;
import com.oracle.bmc.dts.TransferApplianceWaiters;
import com.oracle.bmc.dts.internal.http.CreateTransferApplianceAdminCredentialsConverter;
import com.oracle.bmc.dts.internal.http.CreateTransferApplianceConverter;
import com.oracle.bmc.dts.internal.http.DeleteTransferApplianceConverter;
import com.oracle.bmc.dts.internal.http.GetTransferApplianceCertificateAuthorityCertificateConverter;
import com.oracle.bmc.dts.internal.http.GetTransferApplianceConverter;
import com.oracle.bmc.dts.internal.http.GetTransferApplianceEncryptionPassphraseConverter;
import com.oracle.bmc.dts.internal.http.ListTransferAppliancesConverter;
import com.oracle.bmc.dts.internal.http.UpdateTransferApplianceConverter;
import com.oracle.bmc.dts.requests.CreateTransferApplianceAdminCredentialsRequest;
import com.oracle.bmc.dts.requests.CreateTransferApplianceRequest;
import com.oracle.bmc.dts.requests.DeleteTransferApplianceRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceCertificateAuthorityCertificateRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceEncryptionPassphraseRequest;
import com.oracle.bmc.dts.requests.GetTransferApplianceRequest;
import com.oracle.bmc.dts.requests.ListTransferAppliancesRequest;
import com.oracle.bmc.dts.requests.UpdateTransferApplianceRequest;
import com.oracle.bmc.dts.responses.CreateTransferApplianceAdminCredentialsResponse;
import com.oracle.bmc.dts.responses.CreateTransferApplianceResponse;
import com.oracle.bmc.dts.responses.DeleteTransferApplianceResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceCertificateAuthorityCertificateResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceEncryptionPassphraseResponse;
import com.oracle.bmc.dts.responses.GetTransferApplianceResponse;
import com.oracle.bmc.dts.responses.ListTransferAppliancesResponse;
import com.oracle.bmc.dts.responses.UpdateTransferApplianceResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferApplianceClient
implements TransferAppliance {
    private static final Logger LOG = LoggerFactory.getLogger(TransferApplianceClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("TRANSFERAPPLIANCE").serviceEndpointPrefix("").serviceEndpointTemplate("https://datatransfer.{region}.oci.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final TransferApplianceWaiters waiters;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public TransferApplianceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public TransferApplianceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public TransferApplianceClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public TransferApplianceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public TransferApplianceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public TransferApplianceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public TransferApplianceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public TransferApplianceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected TransferApplianceClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("TransferAppliance-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new TransferApplianceWaiters(executorService, this);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public CreateTransferApplianceResponse createTransferAppliance(CreateTransferApplianceRequest request) {
        LOG.trace("Called createTransferAppliance");
        CreateTransferApplianceRequest interceptedRequest = CreateTransferApplianceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTransferApplianceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTransferApplianceResponse> transformer = CreateTransferApplianceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateTransferApplianceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTransferApplianceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateTransferApplianceDetails(), (BmcRequest)retriedRequest);
                return (CreateTransferApplianceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateTransferApplianceAdminCredentialsResponse createTransferApplianceAdminCredentials(CreateTransferApplianceAdminCredentialsRequest request) {
        LOG.trace("Called createTransferApplianceAdminCredentials");
        CreateTransferApplianceAdminCredentialsRequest interceptedRequest = CreateTransferApplianceAdminCredentialsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateTransferApplianceAdminCredentialsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateTransferApplianceAdminCredentialsResponse> transformer = CreateTransferApplianceAdminCredentialsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (CreateTransferApplianceAdminCredentialsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateTransferApplianceAdminCredentialsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getAdminPublicKey(), (BmcRequest)retriedRequest);
                return (CreateTransferApplianceAdminCredentialsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DeleteTransferApplianceResponse deleteTransferAppliance(DeleteTransferApplianceRequest request) {
        LOG.trace("Called deleteTransferAppliance");
        DeleteTransferApplianceRequest interceptedRequest = DeleteTransferApplianceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteTransferApplianceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteTransferApplianceResponse> transformer = DeleteTransferApplianceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (DeleteTransferApplianceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DeleteTransferApplianceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.delete(ib, (BmcRequest)retriedRequest);
                return (DeleteTransferApplianceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTransferApplianceResponse getTransferAppliance(GetTransferApplianceRequest request) {
        LOG.trace("Called getTransferAppliance");
        GetTransferApplianceRequest interceptedRequest = GetTransferApplianceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTransferApplianceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTransferApplianceResponse> transformer = GetTransferApplianceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTransferApplianceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTransferApplianceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTransferApplianceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTransferApplianceCertificateAuthorityCertificateResponse getTransferApplianceCertificateAuthorityCertificate(GetTransferApplianceCertificateAuthorityCertificateRequest request) {
        LOG.trace("Called getTransferApplianceCertificateAuthorityCertificate");
        GetTransferApplianceCertificateAuthorityCertificateRequest interceptedRequest = GetTransferApplianceCertificateAuthorityCertificateConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTransferApplianceCertificateAuthorityCertificateConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTransferApplianceCertificateAuthorityCertificateResponse> transformer = GetTransferApplianceCertificateAuthorityCertificateConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTransferApplianceCertificateAuthorityCertificateResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTransferApplianceCertificateAuthorityCertificateResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTransferApplianceCertificateAuthorityCertificateResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetTransferApplianceEncryptionPassphraseResponse getTransferApplianceEncryptionPassphrase(GetTransferApplianceEncryptionPassphraseRequest request) {
        LOG.trace("Called getTransferApplianceEncryptionPassphrase");
        GetTransferApplianceEncryptionPassphraseRequest interceptedRequest = GetTransferApplianceEncryptionPassphraseConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetTransferApplianceEncryptionPassphraseConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetTransferApplianceEncryptionPassphraseResponse> transformer = GetTransferApplianceEncryptionPassphraseConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetTransferApplianceEncryptionPassphraseResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetTransferApplianceEncryptionPassphraseResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetTransferApplianceEncryptionPassphraseResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListTransferAppliancesResponse listTransferAppliances(ListTransferAppliancesRequest request) {
        LOG.trace("Called listTransferAppliances");
        ListTransferAppliancesRequest interceptedRequest = ListTransferAppliancesConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListTransferAppliancesConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListTransferAppliancesResponse> transformer = ListTransferAppliancesConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListTransferAppliancesResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListTransferAppliancesResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListTransferAppliancesResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateTransferApplianceResponse updateTransferAppliance(UpdateTransferApplianceRequest request) {
        LOG.trace("Called updateTransferAppliance");
        UpdateTransferApplianceRequest interceptedRequest = UpdateTransferApplianceConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateTransferApplianceConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateTransferApplianceResponse> transformer = UpdateTransferApplianceConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateTransferApplianceResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateTransferApplianceResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateTransferApplianceDetails(), (BmcRequest)retriedRequest);
                return (UpdateTransferApplianceResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public TransferApplianceWaiters getWaiters() {
        return this.waiters;
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, TransferApplianceClient> {
        private ExecutorService executorService;

        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public TransferApplianceClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new TransferApplianceClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint, this.executorService);
        }
    }
}

