/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.email.EmailAsync;
import com.oracle.bmc.email.internal.http.ChangeSenderCompartmentConverter;
import com.oracle.bmc.email.internal.http.CreateSenderConverter;
import com.oracle.bmc.email.internal.http.CreateSuppressionConverter;
import com.oracle.bmc.email.internal.http.DeleteSenderConverter;
import com.oracle.bmc.email.internal.http.DeleteSuppressionConverter;
import com.oracle.bmc.email.internal.http.GetSenderConverter;
import com.oracle.bmc.email.internal.http.GetSuppressionConverter;
import com.oracle.bmc.email.internal.http.ListSendersConverter;
import com.oracle.bmc.email.internal.http.ListSuppressionsConverter;
import com.oracle.bmc.email.internal.http.UpdateSenderConverter;
import com.oracle.bmc.email.requests.ChangeSenderCompartmentRequest;
import com.oracle.bmc.email.requests.CreateSenderRequest;
import com.oracle.bmc.email.requests.CreateSuppressionRequest;
import com.oracle.bmc.email.requests.DeleteSenderRequest;
import com.oracle.bmc.email.requests.DeleteSuppressionRequest;
import com.oracle.bmc.email.requests.GetSenderRequest;
import com.oracle.bmc.email.requests.GetSuppressionRequest;
import com.oracle.bmc.email.requests.ListSendersRequest;
import com.oracle.bmc.email.requests.ListSuppressionsRequest;
import com.oracle.bmc.email.requests.UpdateSenderRequest;
import com.oracle.bmc.email.responses.ChangeSenderCompartmentResponse;
import com.oracle.bmc.email.responses.CreateSenderResponse;
import com.oracle.bmc.email.responses.CreateSuppressionResponse;
import com.oracle.bmc.email.responses.DeleteSenderResponse;
import com.oracle.bmc.email.responses.DeleteSuppressionResponse;
import com.oracle.bmc.email.responses.GetSenderResponse;
import com.oracle.bmc.email.responses.GetSuppressionResponse;
import com.oracle.bmc.email.responses.ListSendersResponse;
import com.oracle.bmc.email.responses.ListSuppressionsResponse;
import com.oracle.bmc.email.responses.UpdateSenderResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmailAsyncClient
implements EmailAsync {
    private static final Logger LOG = LoggerFactory.getLogger(EmailAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("EMAIL").serviceEndpointPrefix("email").serviceEndpointTemplate("https://email.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public EmailAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public EmailAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public EmailAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public EmailAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public EmailAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public EmailAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public EmailAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public EmailAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<ChangeSenderCompartmentResponse> changeSenderCompartment(ChangeSenderCompartmentRequest request, AsyncHandler<ChangeSenderCompartmentRequest, ChangeSenderCompartmentResponse> handler) {
        LOG.trace("Called async changeSenderCompartment");
        ChangeSenderCompartmentRequest interceptedRequest = ChangeSenderCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeSenderCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeSenderCompartmentResponse> transformer = ChangeSenderCompartmentConverter.fromResponse();
        AsyncHandler<ChangeSenderCompartmentRequest, ChangeSenderCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeSenderCompartmentRequest, ChangeSenderCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateSenderResponse> createSender(CreateSenderRequest request, AsyncHandler<CreateSenderRequest, CreateSenderResponse> handler) {
        LOG.trace("Called async createSender");
        CreateSenderRequest interceptedRequest = CreateSenderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSenderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSenderResponse> transformer = CreateSenderConverter.fromResponse();
        AsyncHandler<CreateSenderRequest, CreateSenderResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateSenderRequest, CreateSenderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateSuppressionResponse> createSuppression(CreateSuppressionRequest request, AsyncHandler<CreateSuppressionRequest, CreateSuppressionResponse> handler) {
        LOG.trace("Called async createSuppression");
        CreateSuppressionRequest interceptedRequest = CreateSuppressionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateSuppressionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateSuppressionResponse> transformer = CreateSuppressionConverter.fromResponse();
        AsyncHandler<CreateSuppressionRequest, CreateSuppressionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateSuppressionRequest, CreateSuppressionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteSenderResponse> deleteSender(DeleteSenderRequest request, AsyncHandler<DeleteSenderRequest, DeleteSenderResponse> handler) {
        LOG.trace("Called async deleteSender");
        DeleteSenderRequest interceptedRequest = DeleteSenderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSenderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSenderResponse> transformer = DeleteSenderConverter.fromResponse();
        AsyncHandler<DeleteSenderRequest, DeleteSenderResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteSenderRequest, DeleteSenderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<DeleteSuppressionResponse> deleteSuppression(DeleteSuppressionRequest request, AsyncHandler<DeleteSuppressionRequest, DeleteSuppressionResponse> handler) {
        LOG.trace("Called async deleteSuppression");
        DeleteSuppressionRequest interceptedRequest = DeleteSuppressionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DeleteSuppressionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DeleteSuppressionResponse> transformer = DeleteSuppressionConverter.fromResponse();
        AsyncHandler<DeleteSuppressionRequest, DeleteSuppressionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.deleteFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<DeleteSuppressionRequest, DeleteSuppressionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetSenderResponse> getSender(GetSenderRequest request, AsyncHandler<GetSenderRequest, GetSenderResponse> handler) {
        LOG.trace("Called async getSender");
        GetSenderRequest interceptedRequest = GetSenderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSenderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSenderResponse> transformer = GetSenderConverter.fromResponse();
        AsyncHandler<GetSenderRequest, GetSenderResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetSenderRequest, GetSenderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetSuppressionResponse> getSuppression(GetSuppressionRequest request, AsyncHandler<GetSuppressionRequest, GetSuppressionResponse> handler) {
        LOG.trace("Called async getSuppression");
        GetSuppressionRequest interceptedRequest = GetSuppressionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetSuppressionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetSuppressionResponse> transformer = GetSuppressionConverter.fromResponse();
        AsyncHandler<GetSuppressionRequest, GetSuppressionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetSuppressionRequest, GetSuppressionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSendersResponse> listSenders(ListSendersRequest request, AsyncHandler<ListSendersRequest, ListSendersResponse> handler) {
        LOG.trace("Called async listSenders");
        ListSendersRequest interceptedRequest = ListSendersConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSendersConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSendersResponse> transformer = ListSendersConverter.fromResponse();
        AsyncHandler<ListSendersRequest, ListSendersResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSendersRequest, ListSendersResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListSuppressionsResponse> listSuppressions(ListSuppressionsRequest request, AsyncHandler<ListSuppressionsRequest, ListSuppressionsResponse> handler) {
        LOG.trace("Called async listSuppressions");
        ListSuppressionsRequest interceptedRequest = ListSuppressionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListSuppressionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListSuppressionsResponse> transformer = ListSuppressionsConverter.fromResponse();
        AsyncHandler<ListSuppressionsRequest, ListSuppressionsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListSuppressionsRequest, ListSuppressionsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateSenderResponse> updateSender(UpdateSenderRequest request, AsyncHandler<UpdateSenderRequest, UpdateSenderResponse> handler) {
        LOG.trace("Called async updateSender");
        UpdateSenderRequest interceptedRequest = UpdateSenderConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateSenderConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateSenderResponse> transformer = UpdateSenderConverter.fromResponse();
        AsyncHandler<UpdateSenderRequest, UpdateSenderResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateSenderRequest, UpdateSenderResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, EmailAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public EmailAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new EmailAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

