/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.email.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.email.model.Suppression;
import com.oracle.bmc.email.requests.GetSuppressionRequest;
import com.oracle.bmc.email.responses.GetSuppressionResponse;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSuppressionConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetSuppressionConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetSuppressionRequest interceptRequest(GetSuppressionRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetSuppressionRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getSuppressionId(), (String)"suppressionId must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20170907").path("suppressions").path(HttpUtils.encodePathSegment((String)request.getSuppressionId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetSuppressionResponse> fromResponse() {
        Function<Response, GetSuppressionResponse> transformer = new Function<Response, GetSuppressionResponse>(){

            public GetSuppressionResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.email.responses.GetSuppressionResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Suppression.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetSuppressionResponse.Builder builder = GetSuppressionResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.suppression((Suppression)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetSuppressionResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

