/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.events.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetRuleRequest
extends BmcRequest<Void> {
    private String ruleId;
    private String opcRequestId;

    @ConstructorProperties(value={"ruleId", "opcRequestId"})
    GetRuleRequest(String ruleId, String opcRequestId) {
        this.ruleId = ruleId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRuleRequest, Void> {
        private String ruleId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRuleRequest o) {
            this.ruleId(o.getRuleId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRuleRequest build() {
            GetRuleRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetRuleRequest buildWithoutInvocationCallback() {
            return new GetRuleRequest(this.ruleId, this.opcRequestId);
        }

        public String toString() {
            return "GetRuleRequest.Builder(ruleId=" + this.ruleId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

