/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.filestorage.FileStorage;
import com.oracle.bmc.filestorage.model.ExportSetSummary;
import com.oracle.bmc.filestorage.model.ExportSummary;
import com.oracle.bmc.filestorage.model.FileSystemSummary;
import com.oracle.bmc.filestorage.model.MountTargetSummary;
import com.oracle.bmc.filestorage.model.SnapshotSummary;
import com.oracle.bmc.filestorage.requests.ListExportSetsRequest;
import com.oracle.bmc.filestorage.requests.ListExportsRequest;
import com.oracle.bmc.filestorage.requests.ListFileSystemsRequest;
import com.oracle.bmc.filestorage.requests.ListMountTargetsRequest;
import com.oracle.bmc.filestorage.requests.ListSnapshotsRequest;
import com.oracle.bmc.filestorage.responses.ListExportSetsResponse;
import com.oracle.bmc.filestorage.responses.ListExportsResponse;
import com.oracle.bmc.filestorage.responses.ListFileSystemsResponse;
import com.oracle.bmc.filestorage.responses.ListMountTargetsResponse;
import com.oracle.bmc.filestorage.responses.ListSnapshotsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class FileStoragePaginators {
    private final FileStorage client;

    public Iterable<ListExportSetsResponse> listExportSetsResponseIterator(final ListExportSetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListExportSetsRequest.Builder>(){

            public ListExportSetsRequest.Builder get() {
                return ListExportSetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListExportSetsResponse, String>(){

            public String apply(ListExportSetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListExportSetsRequest.Builder>, ListExportSetsRequest>(){

            public ListExportSetsRequest apply(RequestBuilderAndToken<ListExportSetsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListExportSetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListExportSetsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListExportSetsRequest, ListExportSetsResponse>(){

            public ListExportSetsResponse apply(ListExportSetsRequest request) {
                return FileStoragePaginators.this.client.listExportSets(request);
            }
        });
    }

    public Iterable<ExportSetSummary> listExportSetsRecordIterator(final ListExportSetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListExportSetsRequest.Builder>(){

            public ListExportSetsRequest.Builder get() {
                return ListExportSetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListExportSetsResponse, String>(){

            public String apply(ListExportSetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListExportSetsRequest.Builder>, ListExportSetsRequest>(){

            public ListExportSetsRequest apply(RequestBuilderAndToken<ListExportSetsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListExportSetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListExportSetsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListExportSetsRequest, ListExportSetsResponse>(){

            public ListExportSetsResponse apply(ListExportSetsRequest request) {
                return FileStoragePaginators.this.client.listExportSets(request);
            }
        }, (Function)new Function<ListExportSetsResponse, List<ExportSetSummary>>(){

            public List<ExportSetSummary> apply(ListExportSetsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListExportsResponse> listExportsResponseIterator(final ListExportsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListExportsRequest.Builder>(){

            public ListExportsRequest.Builder get() {
                return ListExportsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListExportsResponse, String>(){

            public String apply(ListExportsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListExportsRequest.Builder>, ListExportsRequest>(){

            public ListExportsRequest apply(RequestBuilderAndToken<ListExportsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListExportsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListExportsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListExportsRequest, ListExportsResponse>(){

            public ListExportsResponse apply(ListExportsRequest request) {
                return FileStoragePaginators.this.client.listExports(request);
            }
        });
    }

    public Iterable<ExportSummary> listExportsRecordIterator(final ListExportsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListExportsRequest.Builder>(){

            public ListExportsRequest.Builder get() {
                return ListExportsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListExportsResponse, String>(){

            public String apply(ListExportsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListExportsRequest.Builder>, ListExportsRequest>(){

            public ListExportsRequest apply(RequestBuilderAndToken<ListExportsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListExportsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListExportsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListExportsRequest, ListExportsResponse>(){

            public ListExportsResponse apply(ListExportsRequest request) {
                return FileStoragePaginators.this.client.listExports(request);
            }
        }, (Function)new Function<ListExportsResponse, List<ExportSummary>>(){

            public List<ExportSummary> apply(ListExportsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListFileSystemsResponse> listFileSystemsResponseIterator(final ListFileSystemsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListFileSystemsRequest.Builder>(){

            public ListFileSystemsRequest.Builder get() {
                return ListFileSystemsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListFileSystemsResponse, String>(){

            public String apply(ListFileSystemsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListFileSystemsRequest.Builder>, ListFileSystemsRequest>(){

            public ListFileSystemsRequest apply(RequestBuilderAndToken<ListFileSystemsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListFileSystemsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListFileSystemsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListFileSystemsRequest, ListFileSystemsResponse>(){

            public ListFileSystemsResponse apply(ListFileSystemsRequest request) {
                return FileStoragePaginators.this.client.listFileSystems(request);
            }
        });
    }

    public Iterable<FileSystemSummary> listFileSystemsRecordIterator(final ListFileSystemsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListFileSystemsRequest.Builder>(){

            public ListFileSystemsRequest.Builder get() {
                return ListFileSystemsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListFileSystemsResponse, String>(){

            public String apply(ListFileSystemsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListFileSystemsRequest.Builder>, ListFileSystemsRequest>(){

            public ListFileSystemsRequest apply(RequestBuilderAndToken<ListFileSystemsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListFileSystemsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListFileSystemsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListFileSystemsRequest, ListFileSystemsResponse>(){

            public ListFileSystemsResponse apply(ListFileSystemsRequest request) {
                return FileStoragePaginators.this.client.listFileSystems(request);
            }
        }, (Function)new Function<ListFileSystemsResponse, List<FileSystemSummary>>(){

            public List<FileSystemSummary> apply(ListFileSystemsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListMountTargetsResponse> listMountTargetsResponseIterator(final ListMountTargetsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListMountTargetsRequest.Builder>(){

            public ListMountTargetsRequest.Builder get() {
                return ListMountTargetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMountTargetsResponse, String>(){

            public String apply(ListMountTargetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMountTargetsRequest.Builder>, ListMountTargetsRequest>(){

            public ListMountTargetsRequest apply(RequestBuilderAndToken<ListMountTargetsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListMountTargetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMountTargetsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListMountTargetsRequest, ListMountTargetsResponse>(){

            public ListMountTargetsResponse apply(ListMountTargetsRequest request) {
                return FileStoragePaginators.this.client.listMountTargets(request);
            }
        });
    }

    public Iterable<MountTargetSummary> listMountTargetsRecordIterator(final ListMountTargetsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListMountTargetsRequest.Builder>(){

            public ListMountTargetsRequest.Builder get() {
                return ListMountTargetsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListMountTargetsResponse, String>(){

            public String apply(ListMountTargetsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListMountTargetsRequest.Builder>, ListMountTargetsRequest>(){

            public ListMountTargetsRequest apply(RequestBuilderAndToken<ListMountTargetsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListMountTargetsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListMountTargetsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListMountTargetsRequest, ListMountTargetsResponse>(){

            public ListMountTargetsResponse apply(ListMountTargetsRequest request) {
                return FileStoragePaginators.this.client.listMountTargets(request);
            }
        }, (Function)new Function<ListMountTargetsResponse, List<MountTargetSummary>>(){

            public List<MountTargetSummary> apply(ListMountTargetsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListSnapshotsResponse> listSnapshotsResponseIterator(final ListSnapshotsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListSnapshotsRequest.Builder>(){

            public ListSnapshotsRequest.Builder get() {
                return ListSnapshotsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSnapshotsResponse, String>(){

            public String apply(ListSnapshotsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSnapshotsRequest.Builder>, ListSnapshotsRequest>(){

            public ListSnapshotsRequest apply(RequestBuilderAndToken<ListSnapshotsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSnapshotsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSnapshotsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSnapshotsRequest, ListSnapshotsResponse>(){

            public ListSnapshotsResponse apply(ListSnapshotsRequest request) {
                return FileStoragePaginators.this.client.listSnapshots(request);
            }
        });
    }

    public Iterable<SnapshotSummary> listSnapshotsRecordIterator(final ListSnapshotsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListSnapshotsRequest.Builder>(){

            public ListSnapshotsRequest.Builder get() {
                return ListSnapshotsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListSnapshotsResponse, String>(){

            public String apply(ListSnapshotsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListSnapshotsRequest.Builder>, ListSnapshotsRequest>(){

            public ListSnapshotsRequest apply(RequestBuilderAndToken<ListSnapshotsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListSnapshotsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListSnapshotsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListSnapshotsRequest, ListSnapshotsResponse>(){

            public ListSnapshotsResponse apply(ListSnapshotsRequest request) {
                return FileStoragePaginators.this.client.listSnapshots(request);
            }
        }, (Function)new Function<ListSnapshotsResponse, List<SnapshotSummary>>(){

            public List<SnapshotSummary> apply(ListSnapshotsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public FileStoragePaginators(FileStorage client) {
        this.client = client;
    }
}

