/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetMountTargetRequest
extends BmcRequest<Void> {
    private String mountTargetId;
    private String opcRequestId;

    @ConstructorProperties(value={"mountTargetId", "opcRequestId"})
    GetMountTargetRequest(String mountTargetId, String opcRequestId) {
        this.mountTargetId = mountTargetId;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getMountTargetId() {
        return this.mountTargetId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetMountTargetRequest, Void> {
        private String mountTargetId;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetMountTargetRequest o) {
            this.mountTargetId(o.getMountTargetId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetMountTargetRequest build() {
            GetMountTargetRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder mountTargetId(String mountTargetId) {
            this.mountTargetId = mountTargetId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetMountTargetRequest buildWithoutInvocationCallback() {
            return new GetMountTargetRequest(this.mountTargetId, this.opcRequestId);
        }

        public String toString() {
            return "GetMountTargetRequest.Builder(mountTargetId=" + this.mountTargetId + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

