/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.client.Invocation;

public class ListSnapshotsRequest
extends BmcRequest<Void> {
    private String fileSystemId;
    private Integer limit;
    private String page;
    private LifecycleState lifecycleState;
    private String id;
    private SortOrder sortOrder;
    private String opcRequestId;

    @ConstructorProperties(value={"fileSystemId", "limit", "page", "lifecycleState", "id", "sortOrder", "opcRequestId"})
    ListSnapshotsRequest(String fileSystemId, Integer limit, String page, LifecycleState lifecycleState, String id, SortOrder sortOrder, String opcRequestId) {
        this.fileSystemId = fileSystemId;
        this.limit = limit;
        this.page = page;
        this.lifecycleState = lifecycleState;
        this.id = id;
        this.sortOrder = sortOrder;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getFileSystemId() {
        return this.fileSystemId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getId() {
        return this.id;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSnapshotsRequest, Void> {
        private String fileSystemId;
        private Integer limit;
        private String page;
        private LifecycleState lifecycleState;
        private String id;
        private SortOrder sortOrder;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSnapshotsRequest o) {
            this.fileSystemId(o.getFileSystemId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.lifecycleState(o.getLifecycleState());
            this.id(o.getId());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSnapshotsRequest build() {
            ListSnapshotsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public ListSnapshotsRequest buildWithoutInvocationCallback() {
            return new ListSnapshotsRequest(this.fileSystemId, this.limit, this.page, this.lifecycleState, this.id, this.sortOrder, this.opcRequestId);
        }

        public String toString() {
            return "ListSnapshotsRequest.Builder(fileSystemId=" + this.fileSystemId + ", limit=" + this.limit + ", page=" + this.page + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", id=" + this.id + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }

    public static enum SortOrder {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState {
        Creating("CREATING"),
        Active("ACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED");

        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid LifecycleState: " + key);
        }

        static {
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

