/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.filestorage.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.filestorage.model.UpdateFileSystemDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class UpdateFileSystemRequest
extends BmcRequest<UpdateFileSystemDetails> {
    private String fileSystemId;
    private UpdateFileSystemDetails updateFileSystemDetails;
    private String ifMatch;
    private String opcRequestId;

    @InternalSdk
    public UpdateFileSystemDetails getBody$() {
        return this.updateFileSystemDetails;
    }

    @ConstructorProperties(value={"fileSystemId", "updateFileSystemDetails", "ifMatch", "opcRequestId"})
    UpdateFileSystemRequest(String fileSystemId, UpdateFileSystemDetails updateFileSystemDetails, String ifMatch, String opcRequestId) {
        this.fileSystemId = fileSystemId;
        this.updateFileSystemDetails = updateFileSystemDetails;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getFileSystemId() {
        return this.fileSystemId;
    }

    public UpdateFileSystemDetails getUpdateFileSystemDetails() {
        return this.updateFileSystemDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateFileSystemRequest, UpdateFileSystemDetails> {
        private String fileSystemId;
        private UpdateFileSystemDetails updateFileSystemDetails;
        private String ifMatch;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateFileSystemRequest o) {
            this.fileSystemId(o.getFileSystemId());
            this.updateFileSystemDetails(o.getUpdateFileSystemDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateFileSystemRequest build() {
            UpdateFileSystemRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateFileSystemDetails body) {
            this.updateFileSystemDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder fileSystemId(String fileSystemId) {
            this.fileSystemId = fileSystemId;
            return this;
        }

        public Builder updateFileSystemDetails(UpdateFileSystemDetails updateFileSystemDetails) {
            this.updateFileSystemDetails = updateFileSystemDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public UpdateFileSystemRequest buildWithoutInvocationCallback() {
            return new UpdateFileSystemRequest(this.fileSystemId, this.updateFileSystemDetails, this.ifMatch, this.opcRequestId);
        }

        public String toString() {
            return "UpdateFileSystemRequest.Builder(fileSystemId=" + this.fileSystemId + ", updateFileSystemDetails=" + this.updateFileSystemDetails + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

