/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.goldengate.GoldenGate;
import com.oracle.bmc.goldengate.model.DatabaseRegistrationSummary;
import com.oracle.bmc.goldengate.model.DeploymentBackupSummary;
import com.oracle.bmc.goldengate.model.DeploymentSummary;
import com.oracle.bmc.goldengate.model.WorkRequest;
import com.oracle.bmc.goldengate.model.WorkRequestError;
import com.oracle.bmc.goldengate.model.WorkRequestLogEntry;
import com.oracle.bmc.goldengate.requests.ListDatabaseRegistrationsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentBackupsRequest;
import com.oracle.bmc.goldengate.requests.ListDeploymentsRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestErrorsRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestLogsRequest;
import com.oracle.bmc.goldengate.requests.ListWorkRequestsRequest;
import com.oracle.bmc.goldengate.responses.ListDatabaseRegistrationsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentBackupsResponse;
import com.oracle.bmc.goldengate.responses.ListDeploymentsResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestErrorsResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestLogsResponse;
import com.oracle.bmc.goldengate.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class GoldenGatePaginators {
    private final GoldenGate client;

    public Iterable<ListDatabaseRegistrationsResponse> listDatabaseRegistrationsResponseIterator(final ListDatabaseRegistrationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDatabaseRegistrationsRequest.Builder>(){

            public ListDatabaseRegistrationsRequest.Builder get() {
                return ListDatabaseRegistrationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDatabaseRegistrationsResponse, String>(){

            public String apply(ListDatabaseRegistrationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDatabaseRegistrationsRequest.Builder>, ListDatabaseRegistrationsRequest>(){

            public ListDatabaseRegistrationsRequest apply(RequestBuilderAndToken<ListDatabaseRegistrationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDatabaseRegistrationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDatabaseRegistrationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDatabaseRegistrationsRequest, ListDatabaseRegistrationsResponse>(){

            public ListDatabaseRegistrationsResponse apply(ListDatabaseRegistrationsRequest request) {
                return GoldenGatePaginators.this.client.listDatabaseRegistrations(request);
            }
        });
    }

    public Iterable<DatabaseRegistrationSummary> listDatabaseRegistrationsRecordIterator(final ListDatabaseRegistrationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDatabaseRegistrationsRequest.Builder>(){

            public ListDatabaseRegistrationsRequest.Builder get() {
                return ListDatabaseRegistrationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDatabaseRegistrationsResponse, String>(){

            public String apply(ListDatabaseRegistrationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDatabaseRegistrationsRequest.Builder>, ListDatabaseRegistrationsRequest>(){

            public ListDatabaseRegistrationsRequest apply(RequestBuilderAndToken<ListDatabaseRegistrationsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDatabaseRegistrationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDatabaseRegistrationsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDatabaseRegistrationsRequest, ListDatabaseRegistrationsResponse>(){

            public ListDatabaseRegistrationsResponse apply(ListDatabaseRegistrationsRequest request) {
                return GoldenGatePaginators.this.client.listDatabaseRegistrations(request);
            }
        }, (Function)new Function<ListDatabaseRegistrationsResponse, List<DatabaseRegistrationSummary>>(){

            public List<DatabaseRegistrationSummary> apply(ListDatabaseRegistrationsResponse response) {
                return response.getDatabaseRegistrationCollection().getItems();
            }
        });
    }

    public Iterable<ListDeploymentBackupsResponse> listDeploymentBackupsResponseIterator(final ListDeploymentBackupsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDeploymentBackupsRequest.Builder>(){

            public ListDeploymentBackupsRequest.Builder get() {
                return ListDeploymentBackupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentBackupsResponse, String>(){

            public String apply(ListDeploymentBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentBackupsRequest.Builder>, ListDeploymentBackupsRequest>(){

            public ListDeploymentBackupsRequest apply(RequestBuilderAndToken<ListDeploymentBackupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDeploymentBackupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentBackupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDeploymentBackupsRequest, ListDeploymentBackupsResponse>(){

            public ListDeploymentBackupsResponse apply(ListDeploymentBackupsRequest request) {
                return GoldenGatePaginators.this.client.listDeploymentBackups(request);
            }
        });
    }

    public Iterable<DeploymentBackupSummary> listDeploymentBackupsRecordIterator(final ListDeploymentBackupsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDeploymentBackupsRequest.Builder>(){

            public ListDeploymentBackupsRequest.Builder get() {
                return ListDeploymentBackupsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentBackupsResponse, String>(){

            public String apply(ListDeploymentBackupsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentBackupsRequest.Builder>, ListDeploymentBackupsRequest>(){

            public ListDeploymentBackupsRequest apply(RequestBuilderAndToken<ListDeploymentBackupsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDeploymentBackupsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentBackupsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDeploymentBackupsRequest, ListDeploymentBackupsResponse>(){

            public ListDeploymentBackupsResponse apply(ListDeploymentBackupsRequest request) {
                return GoldenGatePaginators.this.client.listDeploymentBackups(request);
            }
        }, (Function)new Function<ListDeploymentBackupsResponse, List<DeploymentBackupSummary>>(){

            public List<DeploymentBackupSummary> apply(ListDeploymentBackupsResponse response) {
                return response.getDeploymentBackupCollection().getItems();
            }
        });
    }

    public Iterable<ListDeploymentsResponse> listDeploymentsResponseIterator(final ListDeploymentsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListDeploymentsRequest.Builder>(){

            public ListDeploymentsRequest.Builder get() {
                return ListDeploymentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentsResponse, String>(){

            public String apply(ListDeploymentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentsRequest.Builder>, ListDeploymentsRequest>(){

            public ListDeploymentsRequest apply(RequestBuilderAndToken<ListDeploymentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDeploymentsRequest, ListDeploymentsResponse>(){

            public ListDeploymentsResponse apply(ListDeploymentsRequest request) {
                return GoldenGatePaginators.this.client.listDeployments(request);
            }
        });
    }

    public Iterable<DeploymentSummary> listDeploymentsRecordIterator(final ListDeploymentsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListDeploymentsRequest.Builder>(){

            public ListDeploymentsRequest.Builder get() {
                return ListDeploymentsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListDeploymentsResponse, String>(){

            public String apply(ListDeploymentsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListDeploymentsRequest.Builder>, ListDeploymentsRequest>(){

            public ListDeploymentsRequest apply(RequestBuilderAndToken<ListDeploymentsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListDeploymentsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListDeploymentsRequest, ListDeploymentsResponse>(){

            public ListDeploymentsResponse apply(ListDeploymentsRequest request) {
                return GoldenGatePaginators.this.client.listDeployments(request);
            }
        }, (Function)new Function<ListDeploymentsResponse, List<DeploymentSummary>>(){

            public List<DeploymentSummary> apply(ListDeploymentsResponse response) {
                return response.getDeploymentCollection().getItems();
            }
        });
    }

    public Iterable<ListWorkRequestErrorsResponse> listWorkRequestErrorsResponseIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return GoldenGatePaginators.this.client.listWorkRequestErrors(request);
            }
        });
    }

    public Iterable<WorkRequestError> listWorkRequestErrorsRecordIterator(final ListWorkRequestErrorsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestErrorsRequest.Builder>(){

            public ListWorkRequestErrorsRequest.Builder get() {
                return ListWorkRequestErrorsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, String>(){

            public String apply(ListWorkRequestErrorsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder>, ListWorkRequestErrorsRequest>(){

            public ListWorkRequestErrorsRequest apply(RequestBuilderAndToken<ListWorkRequestErrorsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestErrorsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestErrorsRequest, ListWorkRequestErrorsResponse>(){

            public ListWorkRequestErrorsResponse apply(ListWorkRequestErrorsRequest request) {
                return GoldenGatePaginators.this.client.listWorkRequestErrors(request);
            }
        }, (Function)new Function<ListWorkRequestErrorsResponse, List<WorkRequestError>>(){

            public List<WorkRequestError> apply(ListWorkRequestErrorsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestLogsResponse> listWorkRequestLogsResponseIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return GoldenGatePaginators.this.client.listWorkRequestLogs(request);
            }
        });
    }

    public Iterable<WorkRequestLogEntry> listWorkRequestLogsRecordIterator(final ListWorkRequestLogsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestLogsRequest.Builder>(){

            public ListWorkRequestLogsRequest.Builder get() {
                return ListWorkRequestLogsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, String>(){

            public String apply(ListWorkRequestLogsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder>, ListWorkRequestLogsRequest>(){

            public ListWorkRequestLogsRequest apply(RequestBuilderAndToken<ListWorkRequestLogsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestLogsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestLogsRequest, ListWorkRequestLogsResponse>(){

            public ListWorkRequestLogsResponse apply(ListWorkRequestLogsRequest request) {
                return GoldenGatePaginators.this.client.listWorkRequestLogs(request);
            }
        }, (Function)new Function<ListWorkRequestLogsResponse, List<WorkRequestLogEntry>>(){

            public List<WorkRequestLogEntry> apply(ListWorkRequestLogsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return GoldenGatePaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequest> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return GoldenGatePaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequest>>(){

            public List<WorkRequest> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public GoldenGatePaginators(GoldenGate client) {
        this.client = client;
    }
}

