/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.goldengate;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.goldengate.GoldenGate;
import com.oracle.bmc.goldengate.model.LifecycleState;
import com.oracle.bmc.goldengate.requests.GetDatabaseRegistrationRequest;
import com.oracle.bmc.goldengate.requests.GetDeploymentBackupRequest;
import com.oracle.bmc.goldengate.requests.GetDeploymentRequest;
import com.oracle.bmc.goldengate.requests.GetWorkRequestRequest;
import com.oracle.bmc.goldengate.responses.GetDatabaseRegistrationResponse;
import com.oracle.bmc.goldengate.responses.GetDeploymentBackupResponse;
import com.oracle.bmc.goldengate.responses.GetDeploymentResponse;
import com.oracle.bmc.goldengate.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class GoldenGateWaiters {
    private final ExecutorService executorService;
    private final GoldenGate client;

    public Waiter<GetDatabaseRegistrationRequest, GetDatabaseRegistrationResponse> forDatabaseRegistration(GetDatabaseRegistrationRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDatabaseRegistration(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDatabaseRegistrationRequest, GetDatabaseRegistrationResponse> forDatabaseRegistration(GetDatabaseRegistrationRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDatabaseRegistration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDatabaseRegistrationRequest, GetDatabaseRegistrationResponse> forDatabaseRegistration(GetDatabaseRegistrationRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDatabaseRegistration(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDatabaseRegistrationRequest, GetDatabaseRegistrationResponse> forDatabaseRegistration(BmcGenericWaiter waiter, GetDatabaseRegistrationRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDatabaseRegistrationRequest, GetDatabaseRegistrationResponse>(){

            public GetDatabaseRegistrationResponse apply(GetDatabaseRegistrationRequest request) {
                return GoldenGateWaiters.this.client.getDatabaseRegistration(request);
            }
        }, (Predicate)new Predicate<GetDatabaseRegistrationResponse>(){

            public boolean apply(GetDatabaseRegistrationResponse response) {
                return targetStatesSet.contains((Object)response.getDatabaseRegistration().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDeploymentRequest, GetDeploymentResponse> forDeployment(GetDeploymentRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDeployment(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDeploymentRequest, GetDeploymentResponse> forDeployment(GetDeploymentRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDeployment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDeploymentRequest, GetDeploymentResponse> forDeployment(GetDeploymentRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDeployment(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDeploymentRequest, GetDeploymentResponse> forDeployment(BmcGenericWaiter waiter, GetDeploymentRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDeploymentRequest, GetDeploymentResponse>(){

            public GetDeploymentResponse apply(GetDeploymentRequest request) {
                return GoldenGateWaiters.this.client.getDeployment(request);
            }
        }, (Predicate)new Predicate<GetDeploymentResponse>(){

            public boolean apply(GetDeploymentResponse response) {
                return targetStatesSet.contains((Object)response.getDeployment().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetDeploymentBackupRequest, GetDeploymentBackupResponse> forDeploymentBackup(GetDeploymentBackupRequest request, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDeploymentBackup(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetDeploymentBackupRequest, GetDeploymentBackupResponse> forDeploymentBackup(GetDeploymentBackupRequest request, LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forDeploymentBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetDeploymentBackupRequest, GetDeploymentBackupResponse> forDeploymentBackup(GetDeploymentBackupRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forDeploymentBackup(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetDeploymentBackupRequest, GetDeploymentBackupResponse> forDeploymentBackup(BmcGenericWaiter waiter, GetDeploymentBackupRequest request, LifecycleState ... targetStates) {
        final HashSet<LifecycleState> targetStatesSet = new HashSet<LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetDeploymentBackupRequest, GetDeploymentBackupResponse>(){

            public GetDeploymentBackupResponse apply(GetDeploymentBackupRequest request) {
                return GoldenGateWaiters.this.client.getDeploymentBackup(request);
            }
        }, (Predicate)new Predicate<GetDeploymentBackupResponse>(){

            public boolean apply(GetDeploymentBackupResponse response) {
                return targetStatesSet.contains((Object)response.getDeploymentBackup().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return GoldenGateWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public GoldenGateWaiters(ExecutorService executorService, GoldenGate client) {
        this.executorService = executorService;
        this.client = client;
    }
}

