/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.integration.model.CustomEndpointDetails;
import com.oracle.bmc.integration.model.NetworkEndpointDetails;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class IntegrationInstance {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="integrationInstanceType")
    private final IntegrationInstanceType integrationInstanceType;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="stateMessage")
    private final String stateMessage;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="isByol")
    private final Boolean isByol;
    @JsonProperty(value="instanceUrl")
    private final String instanceUrl;
    @JsonProperty(value="messagePacks")
    private final Integer messagePacks;
    @JsonProperty(value="isFileServerEnabled")
    private final Boolean isFileServerEnabled;
    @JsonProperty(value="isVisualBuilderEnabled")
    private final Boolean isVisualBuilderEnabled;
    @JsonProperty(value="customEndpoint")
    private final CustomEndpointDetails customEndpoint;
    @JsonProperty(value="alternateCustomEndpoints")
    private final List<CustomEndpointDetails> alternateCustomEndpoints;
    @JsonProperty(value="consumptionModel")
    private final ConsumptionModel consumptionModel;
    @JsonProperty(value="networkEndpointDetails")
    private final NetworkEndpointDetails networkEndpointDetails;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().id(this.id).displayName(this.displayName).compartmentId(this.compartmentId).integrationInstanceType(this.integrationInstanceType).timeCreated(this.timeCreated).timeUpdated(this.timeUpdated).lifecycleState(this.lifecycleState).stateMessage(this.stateMessage).freeformTags(this.freeformTags).definedTags(this.definedTags).isByol(this.isByol).instanceUrl(this.instanceUrl).messagePacks(this.messagePacks).isFileServerEnabled(this.isFileServerEnabled).isVisualBuilderEnabled(this.isVisualBuilderEnabled).customEndpoint(this.customEndpoint).alternateCustomEndpoints(this.alternateCustomEndpoints).consumptionModel(this.consumptionModel).networkEndpointDetails(this.networkEndpointDetails);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public IntegrationInstanceType getIntegrationInstanceType() {
        return this.integrationInstanceType;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getStateMessage() {
        return this.stateMessage;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Boolean getIsByol() {
        return this.isByol;
    }

    public String getInstanceUrl() {
        return this.instanceUrl;
    }

    public Integer getMessagePacks() {
        return this.messagePacks;
    }

    public Boolean getIsFileServerEnabled() {
        return this.isFileServerEnabled;
    }

    public Boolean getIsVisualBuilderEnabled() {
        return this.isVisualBuilderEnabled;
    }

    public CustomEndpointDetails getCustomEndpoint() {
        return this.customEndpoint;
    }

    public List<CustomEndpointDetails> getAlternateCustomEndpoints() {
        return this.alternateCustomEndpoints;
    }

    public ConsumptionModel getConsumptionModel() {
        return this.consumptionModel;
    }

    public NetworkEndpointDetails getNetworkEndpointDetails() {
        return this.networkEndpointDetails;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IntegrationInstance)) {
            return false;
        }
        IntegrationInstance other = (IntegrationInstance)o;
        Boolean this$isByol = this.getIsByol();
        Boolean other$isByol = other.getIsByol();
        if (this$isByol == null ? other$isByol != null : !((Object)this$isByol).equals(other$isByol)) {
            return false;
        }
        Integer this$messagePacks = this.getMessagePacks();
        Integer other$messagePacks = other.getMessagePacks();
        if (this$messagePacks == null ? other$messagePacks != null : !((Object)this$messagePacks).equals(other$messagePacks)) {
            return false;
        }
        Boolean this$isFileServerEnabled = this.getIsFileServerEnabled();
        Boolean other$isFileServerEnabled = other.getIsFileServerEnabled();
        if (this$isFileServerEnabled == null ? other$isFileServerEnabled != null : !((Object)this$isFileServerEnabled).equals(other$isFileServerEnabled)) {
            return false;
        }
        Boolean this$isVisualBuilderEnabled = this.getIsVisualBuilderEnabled();
        Boolean other$isVisualBuilderEnabled = other.getIsVisualBuilderEnabled();
        if (this$isVisualBuilderEnabled == null ? other$isVisualBuilderEnabled != null : !((Object)this$isVisualBuilderEnabled).equals(other$isVisualBuilderEnabled)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$compartmentId = this.getCompartmentId();
        String other$compartmentId = other.getCompartmentId();
        if (this$compartmentId == null ? other$compartmentId != null : !this$compartmentId.equals(other$compartmentId)) {
            return false;
        }
        IntegrationInstanceType this$integrationInstanceType = this.getIntegrationInstanceType();
        IntegrationInstanceType other$integrationInstanceType = other.getIntegrationInstanceType();
        if (this$integrationInstanceType == null ? other$integrationInstanceType != null : !((Object)((Object)this$integrationInstanceType)).equals((Object)other$integrationInstanceType)) {
            return false;
        }
        Date this$timeCreated = this.getTimeCreated();
        Date other$timeCreated = other.getTimeCreated();
        if (this$timeCreated == null ? other$timeCreated != null : !((Object)this$timeCreated).equals(other$timeCreated)) {
            return false;
        }
        Date this$timeUpdated = this.getTimeUpdated();
        Date other$timeUpdated = other.getTimeUpdated();
        if (this$timeUpdated == null ? other$timeUpdated != null : !((Object)this$timeUpdated).equals(other$timeUpdated)) {
            return false;
        }
        LifecycleState this$lifecycleState = this.getLifecycleState();
        LifecycleState other$lifecycleState = other.getLifecycleState();
        if (this$lifecycleState == null ? other$lifecycleState != null : !((Object)((Object)this$lifecycleState)).equals((Object)other$lifecycleState)) {
            return false;
        }
        String this$stateMessage = this.getStateMessage();
        String other$stateMessage = other.getStateMessage();
        if (this$stateMessage == null ? other$stateMessage != null : !this$stateMessage.equals(other$stateMessage)) {
            return false;
        }
        Map<String, String> this$freeformTags = this.getFreeformTags();
        Map<String, String> other$freeformTags = other.getFreeformTags();
        if (this$freeformTags == null ? other$freeformTags != null : !((Object)this$freeformTags).equals(other$freeformTags)) {
            return false;
        }
        Map<String, Map<String, Object>> this$definedTags = this.getDefinedTags();
        Map<String, Map<String, Object>> other$definedTags = other.getDefinedTags();
        if (this$definedTags == null ? other$definedTags != null : !((Object)this$definedTags).equals(other$definedTags)) {
            return false;
        }
        String this$instanceUrl = this.getInstanceUrl();
        String other$instanceUrl = other.getInstanceUrl();
        if (this$instanceUrl == null ? other$instanceUrl != null : !this$instanceUrl.equals(other$instanceUrl)) {
            return false;
        }
        CustomEndpointDetails this$customEndpoint = this.getCustomEndpoint();
        CustomEndpointDetails other$customEndpoint = other.getCustomEndpoint();
        if (this$customEndpoint == null ? other$customEndpoint != null : !((Object)this$customEndpoint).equals(other$customEndpoint)) {
            return false;
        }
        List<CustomEndpointDetails> this$alternateCustomEndpoints = this.getAlternateCustomEndpoints();
        List<CustomEndpointDetails> other$alternateCustomEndpoints = other.getAlternateCustomEndpoints();
        if (this$alternateCustomEndpoints == null ? other$alternateCustomEndpoints != null : !((Object)this$alternateCustomEndpoints).equals(other$alternateCustomEndpoints)) {
            return false;
        }
        ConsumptionModel this$consumptionModel = this.getConsumptionModel();
        ConsumptionModel other$consumptionModel = other.getConsumptionModel();
        if (this$consumptionModel == null ? other$consumptionModel != null : !((Object)((Object)this$consumptionModel)).equals((Object)other$consumptionModel)) {
            return false;
        }
        NetworkEndpointDetails this$networkEndpointDetails = this.getNetworkEndpointDetails();
        NetworkEndpointDetails other$networkEndpointDetails = other.getNetworkEndpointDetails();
        if (this$networkEndpointDetails == null ? other$networkEndpointDetails != null : !((Object)this$networkEndpointDetails).equals(other$networkEndpointDetails)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isByol = this.getIsByol();
        result = result * 59 + ($isByol == null ? 43 : ((Object)$isByol).hashCode());
        Integer $messagePacks = this.getMessagePacks();
        result = result * 59 + ($messagePacks == null ? 43 : ((Object)$messagePacks).hashCode());
        Boolean $isFileServerEnabled = this.getIsFileServerEnabled();
        result = result * 59 + ($isFileServerEnabled == null ? 43 : ((Object)$isFileServerEnabled).hashCode());
        Boolean $isVisualBuilderEnabled = this.getIsVisualBuilderEnabled();
        result = result * 59 + ($isVisualBuilderEnabled == null ? 43 : ((Object)$isVisualBuilderEnabled).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $compartmentId = this.getCompartmentId();
        result = result * 59 + ($compartmentId == null ? 43 : $compartmentId.hashCode());
        IntegrationInstanceType $integrationInstanceType = this.getIntegrationInstanceType();
        result = result * 59 + ($integrationInstanceType == null ? 43 : ((Object)((Object)$integrationInstanceType)).hashCode());
        Date $timeCreated = this.getTimeCreated();
        result = result * 59 + ($timeCreated == null ? 43 : ((Object)$timeCreated).hashCode());
        Date $timeUpdated = this.getTimeUpdated();
        result = result * 59 + ($timeUpdated == null ? 43 : ((Object)$timeUpdated).hashCode());
        LifecycleState $lifecycleState = this.getLifecycleState();
        result = result * 59 + ($lifecycleState == null ? 43 : ((Object)((Object)$lifecycleState)).hashCode());
        String $stateMessage = this.getStateMessage();
        result = result * 59 + ($stateMessage == null ? 43 : $stateMessage.hashCode());
        Map<String, String> $freeformTags = this.getFreeformTags();
        result = result * 59 + ($freeformTags == null ? 43 : ((Object)$freeformTags).hashCode());
        Map<String, Map<String, Object>> $definedTags = this.getDefinedTags();
        result = result * 59 + ($definedTags == null ? 43 : ((Object)$definedTags).hashCode());
        String $instanceUrl = this.getInstanceUrl();
        result = result * 59 + ($instanceUrl == null ? 43 : $instanceUrl.hashCode());
        CustomEndpointDetails $customEndpoint = this.getCustomEndpoint();
        result = result * 59 + ($customEndpoint == null ? 43 : ((Object)$customEndpoint).hashCode());
        List<CustomEndpointDetails> $alternateCustomEndpoints = this.getAlternateCustomEndpoints();
        result = result * 59 + ($alternateCustomEndpoints == null ? 43 : ((Object)$alternateCustomEndpoints).hashCode());
        ConsumptionModel $consumptionModel = this.getConsumptionModel();
        result = result * 59 + ($consumptionModel == null ? 43 : ((Object)((Object)$consumptionModel)).hashCode());
        NetworkEndpointDetails $networkEndpointDetails = this.getNetworkEndpointDetails();
        result = result * 59 + ($networkEndpointDetails == null ? 43 : ((Object)$networkEndpointDetails).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "IntegrationInstance(id=" + this.getId() + ", displayName=" + this.getDisplayName() + ", compartmentId=" + this.getCompartmentId() + ", integrationInstanceType=" + (Object)((Object)this.getIntegrationInstanceType()) + ", timeCreated=" + this.getTimeCreated() + ", timeUpdated=" + this.getTimeUpdated() + ", lifecycleState=" + (Object)((Object)this.getLifecycleState()) + ", stateMessage=" + this.getStateMessage() + ", freeformTags=" + this.getFreeformTags() + ", definedTags=" + this.getDefinedTags() + ", isByol=" + this.getIsByol() + ", instanceUrl=" + this.getInstanceUrl() + ", messagePacks=" + this.getMessagePacks() + ", isFileServerEnabled=" + this.getIsFileServerEnabled() + ", isVisualBuilderEnabled=" + this.getIsVisualBuilderEnabled() + ", customEndpoint=" + this.getCustomEndpoint() + ", alternateCustomEndpoints=" + this.getAlternateCustomEndpoints() + ", consumptionModel=" + (Object)((Object)this.getConsumptionModel()) + ", networkEndpointDetails=" + this.getNetworkEndpointDetails() + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"id", "displayName", "compartmentId", "integrationInstanceType", "timeCreated", "timeUpdated", "lifecycleState", "stateMessage", "freeformTags", "definedTags", "isByol", "instanceUrl", "messagePacks", "isFileServerEnabled", "isVisualBuilderEnabled", "customEndpoint", "alternateCustomEndpoints", "consumptionModel", "networkEndpointDetails"})
    @Deprecated
    public IntegrationInstance(String id, String displayName, String compartmentId, IntegrationInstanceType integrationInstanceType, Date timeCreated, Date timeUpdated, LifecycleState lifecycleState, String stateMessage, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Boolean isByol, String instanceUrl, Integer messagePacks, Boolean isFileServerEnabled, Boolean isVisualBuilderEnabled, CustomEndpointDetails customEndpoint, List<CustomEndpointDetails> alternateCustomEndpoints, ConsumptionModel consumptionModel, NetworkEndpointDetails networkEndpointDetails) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.integrationInstanceType = integrationInstanceType;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.lifecycleState = lifecycleState;
        this.stateMessage = stateMessage;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.isByol = isByol;
        this.instanceUrl = instanceUrl;
        this.messagePacks = messagePacks;
        this.isFileServerEnabled = isFileServerEnabled;
        this.isVisualBuilderEnabled = isVisualBuilderEnabled;
        this.customEndpoint = customEndpoint;
        this.alternateCustomEndpoints = alternateCustomEndpoints;
        this.consumptionModel = consumptionModel;
        this.networkEndpointDetails = networkEndpointDetails;
    }

    public static enum ConsumptionModel {
        Ucm("UCM"),
        Gov("GOV"),
        Oic4Saas("OIC4SAAS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ConsumptionModel> map;

        private ConsumptionModel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ConsumptionModel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ConsumptionModel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ConsumptionModel.class);
            map = new HashMap<String, ConsumptionModel>();
            for (ConsumptionModel v : ConsumptionModel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum LifecycleState {
        Creating("CREATING"),
        Updating("UPDATING"),
        Active("ACTIVE"),
        Inactive("INACTIVE"),
        Deleting("DELETING"),
        Deleted("DELETED"),
        Failed("FAILED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum IntegrationInstanceType {
        Standard("STANDARD"),
        Enterprise("ENTERPRISE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, IntegrationInstanceType> map;

        private IntegrationInstanceType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static IntegrationInstanceType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'IntegrationInstanceType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(IntegrationInstanceType.class);
            map = new HashMap<String, IntegrationInstanceType>();
            for (IntegrationInstanceType v : IntegrationInstanceType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="integrationInstanceType")
        private IntegrationInstanceType integrationInstanceType;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="stateMessage")
        private String stateMessage;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="isByol")
        private Boolean isByol;
        @JsonProperty(value="instanceUrl")
        private String instanceUrl;
        @JsonProperty(value="messagePacks")
        private Integer messagePacks;
        @JsonProperty(value="isFileServerEnabled")
        private Boolean isFileServerEnabled;
        @JsonProperty(value="isVisualBuilderEnabled")
        private Boolean isVisualBuilderEnabled;
        @JsonProperty(value="customEndpoint")
        private CustomEndpointDetails customEndpoint;
        @JsonProperty(value="alternateCustomEndpoints")
        private List<CustomEndpointDetails> alternateCustomEndpoints;
        @JsonProperty(value="consumptionModel")
        private ConsumptionModel consumptionModel;
        @JsonProperty(value="networkEndpointDetails")
        private NetworkEndpointDetails networkEndpointDetails;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder integrationInstanceType(IntegrationInstanceType integrationInstanceType) {
            this.integrationInstanceType = integrationInstanceType;
            this.__explicitlySet__.add("integrationInstanceType");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder stateMessage(String stateMessage) {
            this.stateMessage = stateMessage;
            this.__explicitlySet__.add("stateMessage");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder isByol(Boolean isByol) {
            this.isByol = isByol;
            this.__explicitlySet__.add("isByol");
            return this;
        }

        public Builder instanceUrl(String instanceUrl) {
            this.instanceUrl = instanceUrl;
            this.__explicitlySet__.add("instanceUrl");
            return this;
        }

        public Builder messagePacks(Integer messagePacks) {
            this.messagePacks = messagePacks;
            this.__explicitlySet__.add("messagePacks");
            return this;
        }

        public Builder isFileServerEnabled(Boolean isFileServerEnabled) {
            this.isFileServerEnabled = isFileServerEnabled;
            this.__explicitlySet__.add("isFileServerEnabled");
            return this;
        }

        public Builder isVisualBuilderEnabled(Boolean isVisualBuilderEnabled) {
            this.isVisualBuilderEnabled = isVisualBuilderEnabled;
            this.__explicitlySet__.add("isVisualBuilderEnabled");
            return this;
        }

        public Builder customEndpoint(CustomEndpointDetails customEndpoint) {
            this.customEndpoint = customEndpoint;
            this.__explicitlySet__.add("customEndpoint");
            return this;
        }

        public Builder alternateCustomEndpoints(List<CustomEndpointDetails> alternateCustomEndpoints) {
            this.alternateCustomEndpoints = alternateCustomEndpoints;
            this.__explicitlySet__.add("alternateCustomEndpoints");
            return this;
        }

        public Builder consumptionModel(ConsumptionModel consumptionModel) {
            this.consumptionModel = consumptionModel;
            this.__explicitlySet__.add("consumptionModel");
            return this;
        }

        public Builder networkEndpointDetails(NetworkEndpointDetails networkEndpointDetails) {
            this.networkEndpointDetails = networkEndpointDetails;
            this.__explicitlySet__.add("networkEndpointDetails");
            return this;
        }

        public IntegrationInstance build() {
            IntegrationInstance __instance__ = new IntegrationInstance(this.id, this.displayName, this.compartmentId, this.integrationInstanceType, this.timeCreated, this.timeUpdated, this.lifecycleState, this.stateMessage, this.freeformTags, this.definedTags, this.isByol, this.instanceUrl, this.messagePacks, this.isFileServerEnabled, this.isVisualBuilderEnabled, this.customEndpoint, this.alternateCustomEndpoints, this.consumptionModel, this.networkEndpointDetails);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(IntegrationInstance o) {
            Builder copiedBuilder = this.id(o.getId()).displayName(o.getDisplayName()).compartmentId(o.getCompartmentId()).integrationInstanceType(o.getIntegrationInstanceType()).timeCreated(o.getTimeCreated()).timeUpdated(o.getTimeUpdated()).lifecycleState(o.getLifecycleState()).stateMessage(o.getStateMessage()).freeformTags(o.getFreeformTags()).definedTags(o.getDefinedTags()).isByol(o.getIsByol()).instanceUrl(o.getInstanceUrl()).messagePacks(o.getMessagePacks()).isFileServerEnabled(o.getIsFileServerEnabled()).isVisualBuilderEnabled(o.getIsVisualBuilderEnabled()).customEndpoint(o.getCustomEndpoint()).alternateCustomEndpoints(o.getAlternateCustomEndpoints()).consumptionModel(o.getConsumptionModel()).networkEndpointDetails(o.getNetworkEndpointDetails());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "IntegrationInstance.Builder(id=" + this.id + ", displayName=" + this.displayName + ", compartmentId=" + this.compartmentId + ", integrationInstanceType=" + (Object)((Object)this.integrationInstanceType) + ", timeCreated=" + this.timeCreated + ", timeUpdated=" + this.timeUpdated + ", lifecycleState=" + (Object)((Object)this.lifecycleState) + ", stateMessage=" + this.stateMessage + ", freeformTags=" + this.freeformTags + ", definedTags=" + this.definedTags + ", isByol=" + this.isByol + ", instanceUrl=" + this.instanceUrl + ", messagePacks=" + this.messagePacks + ", isFileServerEnabled=" + this.isFileServerEnabled + ", isVisualBuilderEnabled=" + this.isVisualBuilderEnabled + ", customEndpoint=" + this.customEndpoint + ", alternateCustomEndpoints=" + this.alternateCustomEndpoints + ", consumptionModel=" + (Object)((Object)this.consumptionModel) + ", networkEndpointDetails=" + this.networkEndpointDetails + ")";
        }
    }
}

