/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.integration.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class StartIntegrationInstanceRequest
extends BmcRequest<Void> {
    private String integrationInstanceId;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    @ConstructorProperties(value={"integrationInstanceId", "ifMatch", "opcRequestId", "opcRetryToken"})
    StartIntegrationInstanceRequest(String integrationInstanceId, String ifMatch, String opcRequestId, String opcRetryToken) {
        this.integrationInstanceId = integrationInstanceId;
        this.ifMatch = ifMatch;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getIntegrationInstanceId() {
        return this.integrationInstanceId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<StartIntegrationInstanceRequest, Void> {
        private String integrationInstanceId;
        private String ifMatch;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(StartIntegrationInstanceRequest o) {
            this.integrationInstanceId(o.getIntegrationInstanceId());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public StartIntegrationInstanceRequest build() {
            StartIntegrationInstanceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder integrationInstanceId(String integrationInstanceId) {
            this.integrationInstanceId = integrationInstanceId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public StartIntegrationInstanceRequest buildWithoutInvocationCallback() {
            return new StartIntegrationInstanceRequest(this.integrationInstanceId, this.ifMatch, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "StartIntegrationInstanceRequest.Builder(integrationInstanceId=" + this.integrationInstanceId + ", ifMatch=" + this.ifMatch + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

