/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.google.common.base.Function;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.io.internal.KeepOpenInputStream;
import com.oracle.bmc.keymanagement.KmsManagement;
import com.oracle.bmc.keymanagement.KmsManagementClientBuilder;
import com.oracle.bmc.keymanagement.KmsManagementPaginators;
import com.oracle.bmc.keymanagement.KmsManagementWaiters;
import com.oracle.bmc.keymanagement.internal.http.BackupKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.CancelKeyDeletionConverter;
import com.oracle.bmc.keymanagement.internal.http.CancelKeyVersionDeletionConverter;
import com.oracle.bmc.keymanagement.internal.http.ChangeKeyCompartmentConverter;
import com.oracle.bmc.keymanagement.internal.http.CreateKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.CreateKeyVersionConverter;
import com.oracle.bmc.keymanagement.internal.http.DisableKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.EnableKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.GetKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.GetKeyVersionConverter;
import com.oracle.bmc.keymanagement.internal.http.GetWrappingKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.ImportKeyConverter;
import com.oracle.bmc.keymanagement.internal.http.ImportKeyVersionConverter;
import com.oracle.bmc.keymanagement.internal.http.ListKeyVersionsConverter;
import com.oracle.bmc.keymanagement.internal.http.ListKeysConverter;
import com.oracle.bmc.keymanagement.internal.http.RestoreKeyFromFileConverter;
import com.oracle.bmc.keymanagement.internal.http.RestoreKeyFromObjectStoreConverter;
import com.oracle.bmc.keymanagement.internal.http.ScheduleKeyDeletionConverter;
import com.oracle.bmc.keymanagement.internal.http.ScheduleKeyVersionDeletionConverter;
import com.oracle.bmc.keymanagement.internal.http.UpdateKeyConverter;
import com.oracle.bmc.keymanagement.requests.BackupKeyRequest;
import com.oracle.bmc.keymanagement.requests.CancelKeyDeletionRequest;
import com.oracle.bmc.keymanagement.requests.CancelKeyVersionDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ChangeKeyCompartmentRequest;
import com.oracle.bmc.keymanagement.requests.CreateKeyRequest;
import com.oracle.bmc.keymanagement.requests.CreateKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.DisableKeyRequest;
import com.oracle.bmc.keymanagement.requests.EnableKeyRequest;
import com.oracle.bmc.keymanagement.requests.GetKeyRequest;
import com.oracle.bmc.keymanagement.requests.GetKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.GetWrappingKeyRequest;
import com.oracle.bmc.keymanagement.requests.ImportKeyRequest;
import com.oracle.bmc.keymanagement.requests.ImportKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.ListKeyVersionsRequest;
import com.oracle.bmc.keymanagement.requests.ListKeysRequest;
import com.oracle.bmc.keymanagement.requests.RestoreKeyFromFileRequest;
import com.oracle.bmc.keymanagement.requests.RestoreKeyFromObjectStoreRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleKeyDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleKeyVersionDeletionRequest;
import com.oracle.bmc.keymanagement.requests.UpdateKeyRequest;
import com.oracle.bmc.keymanagement.responses.BackupKeyResponse;
import com.oracle.bmc.keymanagement.responses.CancelKeyDeletionResponse;
import com.oracle.bmc.keymanagement.responses.CancelKeyVersionDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ChangeKeyCompartmentResponse;
import com.oracle.bmc.keymanagement.responses.CreateKeyResponse;
import com.oracle.bmc.keymanagement.responses.CreateKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.DisableKeyResponse;
import com.oracle.bmc.keymanagement.responses.EnableKeyResponse;
import com.oracle.bmc.keymanagement.responses.GetKeyResponse;
import com.oracle.bmc.keymanagement.responses.GetKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.GetWrappingKeyResponse;
import com.oracle.bmc.keymanagement.responses.ImportKeyResponse;
import com.oracle.bmc.keymanagement.responses.ImportKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.ListKeyVersionsResponse;
import com.oracle.bmc.keymanagement.responses.ListKeysResponse;
import com.oracle.bmc.keymanagement.responses.RestoreKeyFromFileResponse;
import com.oracle.bmc.keymanagement.responses.RestoreKeyFromObjectStoreResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleKeyDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleKeyVersionDeletionResponse;
import com.oracle.bmc.keymanagement.responses.UpdateKeyResponse;
import com.oracle.bmc.model.BmcException;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.BmcGenericRetrier;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.retrier.TokenRefreshRetrier;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsManagementClient
implements KmsManagement {
    private static final Logger LOG = LoggerFactory.getLogger(KmsManagementClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("KMSMANAGEMENT").serviceEndpointPrefix("kms").serviceEndpointTemplate("https://kms.{region}.{secondLevelDomain}").build();
    private static final int MAX_IMMEDIATE_RETRIES_IF_USING_INSTANCE_PRINCIPALS = 2;
    private final KmsManagementWaiters waiters;
    private final KmsManagementPaginators paginators;
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;
    private final RetryConfiguration retryConfiguration;

    public KmsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public KmsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public KmsManagementClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public KmsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public KmsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public KmsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public KmsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, null);
    }

    public KmsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, executorService, RestClientFactoryBuilder.builder());
    }

    protected KmsManagementClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, ExecutorService executorService, RestClientFactoryBuilder restClientFactoryBuilder) {
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        ClientConfiguration clientConfigurationToUse = configuration != null ? configuration : ClientConfiguration.builder().build();
        this.retryConfiguration = clientConfigurationToUse.getRetryConfiguration();
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, clientConfigurationToUse);
        if (executorService == null) {
            ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(50, 50, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("KmsManagement-waiters-%d").build());
            threadPoolExecutor.allowCoreThreadTimeOut(true);
            executorService = threadPoolExecutor;
        }
        this.waiters = new KmsManagementWaiters(executorService, this);
        this.paginators = new KmsManagementPaginators(this);
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static KmsManagementClientBuilder builder() {
        return new KmsManagementClientBuilder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public BackupKeyResponse backupKey(BackupKeyRequest request) {
        LOG.trace("Called backupKey");
        BackupKeyRequest interceptedRequest = BackupKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BackupKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, BackupKeyResponse> transformer = BackupKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (BackupKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (BackupKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getBackupKeyDetails(), (BmcRequest)retriedRequest);
                return (BackupKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CancelKeyDeletionResponse cancelKeyDeletion(CancelKeyDeletionRequest request) {
        LOG.trace("Called cancelKeyDeletion");
        CancelKeyDeletionRequest interceptedRequest = CancelKeyDeletionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelKeyDeletionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelKeyDeletionResponse> transformer = CancelKeyDeletionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CancelKeyDeletionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CancelKeyDeletionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (CancelKeyDeletionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CancelKeyVersionDeletionResponse cancelKeyVersionDeletion(CancelKeyVersionDeletionRequest request) {
        LOG.trace("Called cancelKeyVersionDeletion");
        CancelKeyVersionDeletionRequest interceptedRequest = CancelKeyVersionDeletionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelKeyVersionDeletionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelKeyVersionDeletionResponse> transformer = CancelKeyVersionDeletionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CancelKeyVersionDeletionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CancelKeyVersionDeletionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (CancelKeyVersionDeletionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ChangeKeyCompartmentResponse changeKeyCompartment(ChangeKeyCompartmentRequest request) {
        LOG.trace("Called changeKeyCompartment");
        ChangeKeyCompartmentRequest interceptedRequest = ChangeKeyCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeKeyCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeKeyCompartmentResponse> transformer = ChangeKeyCompartmentConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ChangeKeyCompartmentResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ChangeKeyCompartmentResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getChangeKeyCompartmentDetails(), (BmcRequest)retriedRequest);
                return (ChangeKeyCompartmentResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateKeyResponse createKey(CreateKeyRequest request) {
        LOG.trace("Called createKey");
        CreateKeyRequest interceptedRequest = CreateKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateKeyResponse> transformer = CreateKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getCreateKeyDetails(), (BmcRequest)retriedRequest);
                return (CreateKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public CreateKeyVersionResponse createKeyVersion(CreateKeyVersionRequest request) {
        LOG.trace("Called createKeyVersion");
        CreateKeyVersionRequest interceptedRequest = CreateKeyVersionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateKeyVersionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateKeyVersionResponse> transformer = CreateKeyVersionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (CreateKeyVersionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (CreateKeyVersionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (CreateKeyVersionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public DisableKeyResponse disableKey(DisableKeyRequest request) {
        LOG.trace("Called disableKey");
        DisableKeyRequest interceptedRequest = DisableKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = DisableKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, DisableKeyResponse> transformer = DisableKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (DisableKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (DisableKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (DisableKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public EnableKeyResponse enableKey(EnableKeyRequest request) {
        LOG.trace("Called enableKey");
        EnableKeyRequest interceptedRequest = EnableKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = EnableKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, EnableKeyResponse> transformer = EnableKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (EnableKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (EnableKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (BmcRequest)retriedRequest);
                return (EnableKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetKeyResponse getKey(GetKeyRequest request) {
        LOG.trace("Called getKey");
        GetKeyRequest interceptedRequest = GetKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetKeyResponse> transformer = GetKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetKeyVersionResponse getKeyVersion(GetKeyVersionRequest request) {
        LOG.trace("Called getKeyVersion");
        GetKeyVersionRequest interceptedRequest = GetKeyVersionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetKeyVersionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetKeyVersionResponse> transformer = GetKeyVersionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetKeyVersionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetKeyVersionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetKeyVersionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public GetWrappingKeyResponse getWrappingKey(GetWrappingKeyRequest request) {
        LOG.trace("Called getWrappingKey");
        GetWrappingKeyRequest interceptedRequest = GetWrappingKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetWrappingKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetWrappingKeyResponse> transformer = GetWrappingKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (GetWrappingKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (GetWrappingKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (GetWrappingKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ImportKeyResponse importKey(ImportKeyRequest request) {
        LOG.trace("Called importKey");
        ImportKeyRequest interceptedRequest = ImportKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ImportKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ImportKeyResponse> transformer = ImportKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ImportKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ImportKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getImportKeyDetails(), (BmcRequest)retriedRequest);
                return (ImportKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ImportKeyVersionResponse importKeyVersion(ImportKeyVersionRequest request) {
        LOG.trace("Called importKeyVersion");
        ImportKeyVersionRequest interceptedRequest = ImportKeyVersionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ImportKeyVersionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ImportKeyVersionResponse> transformer = ImportKeyVersionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ImportKeyVersionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ImportKeyVersionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getImportKeyVersionDetails(), (BmcRequest)retriedRequest);
                return (ImportKeyVersionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListKeyVersionsResponse listKeyVersions(ListKeyVersionsRequest request) {
        LOG.trace("Called listKeyVersions");
        ListKeyVersionsRequest interceptedRequest = ListKeyVersionsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListKeyVersionsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListKeyVersionsResponse> transformer = ListKeyVersionsConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListKeyVersionsResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListKeyVersionsResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListKeyVersionsResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ListKeysResponse listKeys(ListKeysRequest request) {
        LOG.trace("Called listKeys");
        ListKeysRequest interceptedRequest = ListKeysConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListKeysConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListKeysResponse> transformer = ListKeysConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (ListKeysResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ListKeysResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.get(ib, (BmcRequest)retriedRequest);
                return (ListKeysResponse)transformer.apply((Object)response);
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreKeyFromFileResponse restoreKeyFromFile(RestoreKeyFromFileRequest request) {
        LOG.trace("Called restoreKeyFromFile");
        try {
            if (request.getRetryConfiguration() != null || this.retryConfiguration != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
                request = (RestoreKeyFromFileRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)RestoreKeyFromFileRequest.builder());
            }
            RestoreKeyFromFileRequest interceptedRequest = RestoreKeyFromFileConverter.interceptRequest(request);
            WrappedInvocationBuilder ib = RestoreKeyFromFileConverter.fromRequest(this.client, interceptedRequest);
            Function<Response, RestoreKeyFromFileResponse> transformer = RestoreKeyFromFileConverter.fromResponse();
            BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
            RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
            RestoreKeyFromFileResponse restoreKeyFromFileResponse = (RestoreKeyFromFileResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
                TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
                return (RestoreKeyFromFileResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                    try {
                        Response response = this.client.post(ib, (Object)retriedRequest.getRestoreKeyFromFileDetails(), (BmcRequest)retriedRequest);
                        return (RestoreKeyFromFileResponse)transformer.apply((Object)response);
                    }
                    catch (RuntimeException e) {
                        if (interceptedRequest.getRetryConfiguration() != null || this.retryConfiguration != null || e instanceof BmcException && tokenRefreshRetrier.getRetryCondition().shouldBeRetried((BmcException)e)) {
                            Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getRestoreKeyFromFileDetails(), (boolean)true);
                        }
                        throw e;
                    }
                });
            });
            return restoreKeyFromFileResponse;
        }
        finally {
            KeepOpenInputStream.closeStream((InputStream)request.getRestoreKeyFromFileDetails());
        }
    }

    @Override
    public RestoreKeyFromObjectStoreResponse restoreKeyFromObjectStore(RestoreKeyFromObjectStoreRequest request) {
        LOG.trace("Called restoreKeyFromObjectStore");
        RestoreKeyFromObjectStoreRequest interceptedRequest = RestoreKeyFromObjectStoreConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreKeyFromObjectStoreConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestoreKeyFromObjectStoreResponse> transformer = RestoreKeyFromObjectStoreConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (RestoreKeyFromObjectStoreResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (RestoreKeyFromObjectStoreResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getRestoreKeyFromObjectStoreDetails(), (BmcRequest)retriedRequest);
                return (RestoreKeyFromObjectStoreResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ScheduleKeyDeletionResponse scheduleKeyDeletion(ScheduleKeyDeletionRequest request) {
        LOG.trace("Called scheduleKeyDeletion");
        ScheduleKeyDeletionRequest interceptedRequest = ScheduleKeyDeletionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ScheduleKeyDeletionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ScheduleKeyDeletionResponse> transformer = ScheduleKeyDeletionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ScheduleKeyDeletionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ScheduleKeyDeletionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getScheduleKeyDeletionDetails(), (BmcRequest)retriedRequest);
                return (ScheduleKeyDeletionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public ScheduleKeyVersionDeletionResponse scheduleKeyVersionDeletion(ScheduleKeyVersionDeletionRequest request) {
        LOG.trace("Called scheduleKeyVersionDeletion");
        ScheduleKeyVersionDeletionRequest interceptedRequest = ScheduleKeyVersionDeletionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ScheduleKeyVersionDeletionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ScheduleKeyVersionDeletionResponse> transformer = ScheduleKeyVersionDeletionConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        return (ScheduleKeyVersionDeletionResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (ScheduleKeyVersionDeletionResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.post(ib, (Object)retriedRequest.getScheduleKeyVersionDeletionDetails(), (BmcRequest)retriedRequest);
                return (ScheduleKeyVersionDeletionResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public UpdateKeyResponse updateKey(UpdateKeyRequest request) {
        LOG.trace("Called updateKey");
        UpdateKeyRequest interceptedRequest = UpdateKeyConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateKeyConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateKeyResponse> transformer = UpdateKeyConverter.fromResponse();
        BmcGenericRetrier retrier = Retriers.createPreferredRetrier((RetryConfiguration)interceptedRequest.getRetryConfiguration(), (RetryConfiguration)this.retryConfiguration);
        return (UpdateKeyResponse)retrier.execute((Object)interceptedRequest, retryRequest -> {
            TokenRefreshRetrier tokenRefreshRetrier = new TokenRefreshRetrier(this.authenticationDetailsProvider);
            return (UpdateKeyResponse)tokenRefreshRetrier.execute((Object)retryRequest, retriedRequest -> {
                Response response = this.client.put(ib, (Object)retriedRequest.getUpdateKeyDetails(), (BmcRequest)retriedRequest);
                return (UpdateKeyResponse)transformer.apply((Object)response);
            });
        });
    }

    @Override
    public KmsManagementWaiters getWaiters() {
        return this.waiters;
    }

    @Override
    public KmsManagementPaginators getPaginators() {
        return this.paginators;
    }

    RestClient getClient() {
        return this.client;
    }
}

