/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.keymanagement.KmsManagement;
import com.oracle.bmc.keymanagement.model.KeySummary;
import com.oracle.bmc.keymanagement.model.KeyVersionSummary;
import com.oracle.bmc.keymanagement.requests.ListKeyVersionsRequest;
import com.oracle.bmc.keymanagement.requests.ListKeysRequest;
import com.oracle.bmc.keymanagement.responses.ListKeyVersionsResponse;
import com.oracle.bmc.keymanagement.responses.ListKeysResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class KmsManagementPaginators {
    private final KmsManagement client;

    public Iterable<ListKeyVersionsResponse> listKeyVersionsResponseIterator(final ListKeyVersionsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListKeyVersionsRequest.Builder>(){

            public ListKeyVersionsRequest.Builder get() {
                return ListKeyVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListKeyVersionsResponse, String>(){

            public String apply(ListKeyVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListKeyVersionsRequest.Builder>, ListKeyVersionsRequest>(){

            public ListKeyVersionsRequest apply(RequestBuilderAndToken<ListKeyVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListKeyVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListKeyVersionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListKeyVersionsRequest, ListKeyVersionsResponse>(){

            public ListKeyVersionsResponse apply(ListKeyVersionsRequest request) {
                return KmsManagementPaginators.this.client.listKeyVersions(request);
            }
        });
    }

    public Iterable<KeyVersionSummary> listKeyVersionsRecordIterator(final ListKeyVersionsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListKeyVersionsRequest.Builder>(){

            public ListKeyVersionsRequest.Builder get() {
                return ListKeyVersionsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListKeyVersionsResponse, String>(){

            public String apply(ListKeyVersionsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListKeyVersionsRequest.Builder>, ListKeyVersionsRequest>(){

            public ListKeyVersionsRequest apply(RequestBuilderAndToken<ListKeyVersionsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListKeyVersionsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListKeyVersionsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListKeyVersionsRequest, ListKeyVersionsResponse>(){

            public ListKeyVersionsResponse apply(ListKeyVersionsRequest request) {
                return KmsManagementPaginators.this.client.listKeyVersions(request);
            }
        }, (Function)new Function<ListKeyVersionsResponse, List<KeyVersionSummary>>(){

            public List<KeyVersionSummary> apply(ListKeyVersionsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListKeysResponse> listKeysResponseIterator(final ListKeysRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListKeysRequest.Builder>(){

            public ListKeysRequest.Builder get() {
                return ListKeysRequest.builder().copy(request);
            }
        }, (Function)new Function<ListKeysResponse, String>(){

            public String apply(ListKeysResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListKeysRequest.Builder>, ListKeysRequest>(){

            public ListKeysRequest apply(RequestBuilderAndToken<ListKeysRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListKeysRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListKeysRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListKeysRequest, ListKeysResponse>(){

            public ListKeysResponse apply(ListKeysRequest request) {
                return KmsManagementPaginators.this.client.listKeys(request);
            }
        });
    }

    public Iterable<KeySummary> listKeysRecordIterator(final ListKeysRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListKeysRequest.Builder>(){

            public ListKeysRequest.Builder get() {
                return ListKeysRequest.builder().copy(request);
            }
        }, (Function)new Function<ListKeysResponse, String>(){

            public String apply(ListKeysResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListKeysRequest.Builder>, ListKeysRequest>(){

            public ListKeysRequest apply(RequestBuilderAndToken<ListKeysRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListKeysRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListKeysRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListKeysRequest, ListKeysResponse>(){

            public ListKeysResponse apply(ListKeysRequest request) {
                return KmsManagementPaginators.this.client.listKeys(request);
            }
        }, (Function)new Function<ListKeysResponse, List<KeySummary>>(){

            public List<KeySummary> apply(ListKeysResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public KmsManagementPaginators(KmsManagement client) {
        this.client = client;
    }
}

