/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.keymanagement.KmsManagement;
import com.oracle.bmc.keymanagement.model.Key;
import com.oracle.bmc.keymanagement.model.KeyVersion;
import com.oracle.bmc.keymanagement.model.WrappingKey;
import com.oracle.bmc.keymanagement.requests.GetKeyRequest;
import com.oracle.bmc.keymanagement.requests.GetKeyVersionRequest;
import com.oracle.bmc.keymanagement.requests.GetWrappingKeyRequest;
import com.oracle.bmc.keymanagement.responses.GetKeyResponse;
import com.oracle.bmc.keymanagement.responses.GetKeyVersionResponse;
import com.oracle.bmc.keymanagement.responses.GetWrappingKeyResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class KmsManagementWaiters {
    private final ExecutorService executorService;
    private final KmsManagement client;

    public Waiter<GetKeyRequest, GetKeyResponse> forKey(GetKeyRequest request, Key.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forKey(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetKeyRequest, GetKeyResponse> forKey(GetKeyRequest request, Key.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forKey(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetKeyRequest, GetKeyResponse> forKey(GetKeyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Key.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forKey(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetKeyRequest, GetKeyResponse> forKey(BmcGenericWaiter waiter, GetKeyRequest request, Key.LifecycleState ... targetStates) {
        final HashSet<Key.LifecycleState> targetStatesSet = new HashSet<Key.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetKeyRequest, GetKeyResponse>(){

            public GetKeyResponse apply(GetKeyRequest request) {
                return KmsManagementWaiters.this.client.getKey(request);
            }
        }, (Predicate)new Predicate<GetKeyResponse>(){

            public boolean apply(GetKeyResponse response) {
                return targetStatesSet.contains((Object)response.getKey().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Key.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetKeyVersionRequest, GetKeyVersionResponse> forKeyVersion(GetKeyVersionRequest request, KeyVersion.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forKeyVersion(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetKeyVersionRequest, GetKeyVersionResponse> forKeyVersion(GetKeyVersionRequest request, KeyVersion.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forKeyVersion(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetKeyVersionRequest, GetKeyVersionResponse> forKeyVersion(GetKeyVersionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, KeyVersion.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forKeyVersion(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetKeyVersionRequest, GetKeyVersionResponse> forKeyVersion(BmcGenericWaiter waiter, GetKeyVersionRequest request, KeyVersion.LifecycleState ... targetStates) {
        final HashSet<KeyVersion.LifecycleState> targetStatesSet = new HashSet<KeyVersion.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetKeyVersionRequest, GetKeyVersionResponse>(){

            public GetKeyVersionResponse apply(GetKeyVersionRequest request) {
                return KmsManagementWaiters.this.client.getKeyVersion(request);
            }
        }, (Predicate)new Predicate<GetKeyVersionResponse>(){

            public boolean apply(GetKeyVersionResponse response) {
                return targetStatesSet.contains((Object)response.getKeyVersion().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)KeyVersion.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetWrappingKeyRequest, GetWrappingKeyResponse> forWrappingKey(GetWrappingKeyRequest request, WrappingKey.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forWrappingKey(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetWrappingKeyRequest, GetWrappingKeyResponse> forWrappingKey(GetWrappingKeyRequest request, WrappingKey.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forWrappingKey(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetWrappingKeyRequest, GetWrappingKeyResponse> forWrappingKey(GetWrappingKeyRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, WrappingKey.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forWrappingKey(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetWrappingKeyRequest, GetWrappingKeyResponse> forWrappingKey(BmcGenericWaiter waiter, GetWrappingKeyRequest request, WrappingKey.LifecycleState ... targetStates) {
        final HashSet<WrappingKey.LifecycleState> targetStatesSet = new HashSet<WrappingKey.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWrappingKeyRequest, GetWrappingKeyResponse>(){

            public GetWrappingKeyResponse apply(GetWrappingKeyRequest request) {
                return KmsManagementWaiters.this.client.getWrappingKey(request);
            }
        }, (Predicate)new Predicate<GetWrappingKeyResponse>(){

            public boolean apply(GetWrappingKeyResponse response) {
                return targetStatesSet.contains((Object)response.getWrappingKey().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)WrappingKey.LifecycleState.Deleted)), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public KmsManagementWaiters(ExecutorService executorService, KmsManagement client) {
        this.executorService = executorService;
        this.client = client;
    }
}

