/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ProvidesClientConfigurators;
import com.oracle.bmc.auth.RefreshableOnNotAuthenticatedProvider;
import com.oracle.bmc.auth.RegionProvider;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.RestClientFactory;
import com.oracle.bmc.http.internal.RestClientFactoryBuilder;
import com.oracle.bmc.http.internal.RetryTokenUtils;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.signing.RequestSigner;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.keymanagement.KmsVaultAsync;
import com.oracle.bmc.keymanagement.internal.http.BackupVaultConverter;
import com.oracle.bmc.keymanagement.internal.http.CancelVaultDeletionConverter;
import com.oracle.bmc.keymanagement.internal.http.ChangeVaultCompartmentConverter;
import com.oracle.bmc.keymanagement.internal.http.CreateVaultConverter;
import com.oracle.bmc.keymanagement.internal.http.GetVaultConverter;
import com.oracle.bmc.keymanagement.internal.http.GetVaultUsageConverter;
import com.oracle.bmc.keymanagement.internal.http.ListVaultsConverter;
import com.oracle.bmc.keymanagement.internal.http.RestoreVaultFromFileConverter;
import com.oracle.bmc.keymanagement.internal.http.RestoreVaultFromObjectStoreConverter;
import com.oracle.bmc.keymanagement.internal.http.ScheduleVaultDeletionConverter;
import com.oracle.bmc.keymanagement.internal.http.UpdateVaultConverter;
import com.oracle.bmc.keymanagement.requests.BackupVaultRequest;
import com.oracle.bmc.keymanagement.requests.CancelVaultDeletionRequest;
import com.oracle.bmc.keymanagement.requests.ChangeVaultCompartmentRequest;
import com.oracle.bmc.keymanagement.requests.CreateVaultRequest;
import com.oracle.bmc.keymanagement.requests.GetVaultRequest;
import com.oracle.bmc.keymanagement.requests.GetVaultUsageRequest;
import com.oracle.bmc.keymanagement.requests.ListVaultsRequest;
import com.oracle.bmc.keymanagement.requests.RestoreVaultFromFileRequest;
import com.oracle.bmc.keymanagement.requests.RestoreVaultFromObjectStoreRequest;
import com.oracle.bmc.keymanagement.requests.ScheduleVaultDeletionRequest;
import com.oracle.bmc.keymanagement.requests.UpdateVaultRequest;
import com.oracle.bmc.keymanagement.responses.BackupVaultResponse;
import com.oracle.bmc.keymanagement.responses.CancelVaultDeletionResponse;
import com.oracle.bmc.keymanagement.responses.ChangeVaultCompartmentResponse;
import com.oracle.bmc.keymanagement.responses.CreateVaultResponse;
import com.oracle.bmc.keymanagement.responses.GetVaultResponse;
import com.oracle.bmc.keymanagement.responses.GetVaultUsageResponse;
import com.oracle.bmc.keymanagement.responses.ListVaultsResponse;
import com.oracle.bmc.keymanagement.responses.RestoreVaultFromFileResponse;
import com.oracle.bmc.keymanagement.responses.RestoreVaultFromObjectStoreResponse;
import com.oracle.bmc.keymanagement.responses.ScheduleVaultDeletionResponse;
import com.oracle.bmc.keymanagement.responses.UpdateVaultResponse;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.responses.internal.StreamClosingAsyncHandler;
import com.oracle.bmc.retrier.Retriers;
import com.oracle.bmc.util.internal.RefreshAuthTokenWrapper;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Future;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KmsVaultAsyncClient
implements KmsVaultAsync {
    private static final Logger LOG = LoggerFactory.getLogger(KmsVaultAsyncClient.class);
    public static final Service SERVICE = Services.serviceBuilder().serviceName("KMSVAULT").serviceEndpointPrefix("kms").serviceEndpointTemplate("https://kms.{region}.{secondLevelDomain}").build();
    private final RestClient client;
    private final AbstractAuthenticationDetailsProvider authenticationDetailsProvider;

    public KmsVaultAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(authenticationDetailsProvider, null);
    }

    public KmsVaultAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(authenticationDetailsProvider, configuration, null);
    }

    public KmsVaultAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this((AbstractAuthenticationDetailsProvider)authenticationDetailsProvider, configuration, clientConfigurator, (RequestSignerFactory)new DefaultRequestSignerFactory(SigningStrategy.STANDARD));
    }

    public KmsVaultAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, new ArrayList<ClientConfigurator>());
    }

    public KmsVaultAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, additionalClientConfigurators, null);
    }

    public KmsVaultAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, DefaultRequestSignerFactory.createDefaultRequestSignerFactories(), additionalClientConfigurators, endpoint);
    }

    public KmsVaultAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(authenticationDetailsProvider, configuration, clientConfigurator, defaultRequestSignerFactory, signingStrategyRequestSignerFactories, additionalClientConfigurators, endpoint, RestClientFactoryBuilder.builder());
    }

    public KmsVaultAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint, RestClientFactoryBuilder restClientFactoryBuilder) {
        RegionProvider provider;
        this.authenticationDetailsProvider = authenticationDetailsProvider;
        ArrayList authenticationDetailsConfigurators = new ArrayList();
        if (this.authenticationDetailsProvider instanceof ProvidesClientConfigurators) {
            authenticationDetailsConfigurators.addAll(((ProvidesClientConfigurators)this.authenticationDetailsProvider).getClientConfigurators());
        }
        ArrayList<ClientConfigurator> allConfigurators = new ArrayList<ClientConfigurator>(additionalClientConfigurators);
        allConfigurators.addAll(authenticationDetailsConfigurators);
        RestClientFactory restClientFactory = restClientFactoryBuilder.clientConfigurator(clientConfigurator).additionalClientConfigurators(allConfigurators).build();
        RequestSigner defaultRequestSigner = defaultRequestSignerFactory.createRequestSigner(SERVICE, this.authenticationDetailsProvider);
        HashMap<SigningStrategy, RequestSigner> requestSigners = new HashMap<SigningStrategy, RequestSigner>();
        if (this.authenticationDetailsProvider instanceof BasicAuthenticationDetailsProvider) {
            for (SigningStrategy s : SigningStrategy.values()) {
                requestSigners.put(s, signingStrategyRequestSignerFactories.get(s).createRequestSigner(SERVICE, authenticationDetailsProvider));
            }
        }
        this.client = restClientFactory.create(defaultRequestSigner, requestSigners, configuration);
        if (this.authenticationDetailsProvider instanceof RegionProvider && (provider = (RegionProvider)this.authenticationDetailsProvider).getRegion() != null) {
            this.setRegion(provider.getRegion());
            if (endpoint != null) {
                LOG.info("Authentication details provider configured for region '{}', but endpoint specifically set to '{}'. Using endpoint setting instead of region.", (Object)provider.getRegion(), (Object)endpoint);
            }
        }
        if (endpoint != null) {
            this.setEndpoint(endpoint);
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setEndpoint(String endpoint) {
        LOG.info("Setting endpoint to {}", (Object)endpoint);
        this.client.setEndpoint(endpoint);
    }

    @Override
    public String getEndpoint() {
        String endpoint = null;
        URI uri = this.client.getBaseTarget().getUri();
        if (uri != null) {
            endpoint = uri.toString();
        }
        return endpoint;
    }

    @Override
    public void setRegion(Region region) {
        Optional endpoint = region.getEndpoint(SERVICE);
        if (!endpoint.isPresent()) {
            throw new IllegalArgumentException("Endpoint for " + SERVICE + " is not known in region " + region);
        }
        this.setEndpoint((String)endpoint.get());
    }

    @Override
    public void setRegion(String regionId) {
        regionId = regionId.toLowerCase(Locale.ENGLISH);
        try {
            Region region = Region.fromRegionId((String)regionId);
            this.setRegion(region);
        }
        catch (IllegalArgumentException e) {
            LOG.info("Unknown regionId '{}', falling back to default endpoint format", (Object)regionId);
            String endpoint = Region.formatDefaultRegionEndpoint((Service)SERVICE, (String)regionId);
            this.setEndpoint(endpoint);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    @Override
    public Future<BackupVaultResponse> backupVault(BackupVaultRequest request, AsyncHandler<BackupVaultRequest, BackupVaultResponse> handler) {
        LOG.trace("Called async backupVault");
        BackupVaultRequest interceptedRequest = BackupVaultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = BackupVaultConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, BackupVaultResponse> transformer = BackupVaultConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<BackupVaultRequest, BackupVaultResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<BackupVaultRequest, BackupVaultResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CancelVaultDeletionResponse> cancelVaultDeletion(CancelVaultDeletionRequest request, AsyncHandler<CancelVaultDeletionRequest, CancelVaultDeletionResponse> handler) {
        LOG.trace("Called async cancelVaultDeletion");
        CancelVaultDeletionRequest interceptedRequest = CancelVaultDeletionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CancelVaultDeletionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CancelVaultDeletionResponse> transformer = CancelVaultDeletionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CancelVaultDeletionRequest, CancelVaultDeletionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CancelVaultDeletionRequest, CancelVaultDeletionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ChangeVaultCompartmentResponse> changeVaultCompartment(ChangeVaultCompartmentRequest request, AsyncHandler<ChangeVaultCompartmentRequest, ChangeVaultCompartmentResponse> handler) {
        LOG.trace("Called async changeVaultCompartment");
        ChangeVaultCompartmentRequest interceptedRequest = ChangeVaultCompartmentConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ChangeVaultCompartmentConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ChangeVaultCompartmentResponse> transformer = ChangeVaultCompartmentConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ChangeVaultCompartmentRequest, ChangeVaultCompartmentResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ChangeVaultCompartmentRequest, ChangeVaultCompartmentResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<CreateVaultResponse> createVault(CreateVaultRequest request, AsyncHandler<CreateVaultRequest, CreateVaultResponse> handler) {
        LOG.trace("Called async createVault");
        CreateVaultRequest interceptedRequest = CreateVaultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = CreateVaultConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, CreateVaultResponse> transformer = CreateVaultConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<CreateVaultRequest, CreateVaultResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<CreateVaultRequest, CreateVaultResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetVaultResponse> getVault(GetVaultRequest request, AsyncHandler<GetVaultRequest, GetVaultResponse> handler) {
        LOG.trace("Called async getVault");
        GetVaultRequest interceptedRequest = GetVaultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVaultConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVaultResponse> transformer = GetVaultConverter.fromResponse();
        AsyncHandler<GetVaultRequest, GetVaultResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetVaultRequest, GetVaultResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<GetVaultUsageResponse> getVaultUsage(GetVaultUsageRequest request, AsyncHandler<GetVaultUsageRequest, GetVaultUsageResponse> handler) {
        LOG.trace("Called async getVaultUsage");
        GetVaultUsageRequest interceptedRequest = GetVaultUsageConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = GetVaultUsageConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, GetVaultUsageResponse> transformer = GetVaultUsageConverter.fromResponse();
        AsyncHandler<GetVaultUsageRequest, GetVaultUsageResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<GetVaultUsageRequest, GetVaultUsageResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ListVaultsResponse> listVaults(ListVaultsRequest request, AsyncHandler<ListVaultsRequest, ListVaultsResponse> handler) {
        LOG.trace("Called async listVaults");
        ListVaultsRequest interceptedRequest = ListVaultsConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ListVaultsConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ListVaultsResponse> transformer = ListVaultsConverter.fromResponse();
        AsyncHandler<ListVaultsRequest, ListVaultsResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.getFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ListVaultsRequest, ListVaultsResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RestoreVaultFromFileResponse> restoreVaultFromFile(RestoreVaultFromFileRequest request, AsyncHandler<RestoreVaultFromFileRequest, RestoreVaultFromFileResponse> handler) {
        LOG.trace("Called async restoreVaultFromFile");
        if (request.getRetryConfiguration() != null || this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            request = (RestoreVaultFromFileRequest)Retriers.wrapBodyInputStreamIfNecessary((BmcRequest)request, (BmcRequest.Builder)RestoreVaultFromFileRequest.builder());
        }
        final RestoreVaultFromFileRequest interceptedRequest = RestoreVaultFromFileConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreVaultFromFileConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestoreVaultFromFileResponse> transformer = RestoreVaultFromFileConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        StreamClosingAsyncHandler handlerToUse = new StreamClosingAsyncHandler(handler);
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RestoreVaultFromFileRequest, RestoreVaultFromFileResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, (AsyncHandler)handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                    LOG.debug("Resetting stream");
                    Retriers.tryResetStreamForRetry((InputStream)interceptedRequest.getRestoreVaultFromFileDetails(), (boolean)true);
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<RestoreVaultFromObjectStoreResponse> restoreVaultFromObjectStore(RestoreVaultFromObjectStoreRequest request, AsyncHandler<RestoreVaultFromObjectStoreRequest, RestoreVaultFromObjectStoreResponse> handler) {
        LOG.trace("Called async restoreVaultFromObjectStore");
        RestoreVaultFromObjectStoreRequest interceptedRequest = RestoreVaultFromObjectStoreConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = RestoreVaultFromObjectStoreConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, RestoreVaultFromObjectStoreResponse> transformer = RestoreVaultFromObjectStoreConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<RestoreVaultFromObjectStoreRequest, RestoreVaultFromObjectStoreResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<RestoreVaultFromObjectStoreRequest, RestoreVaultFromObjectStoreResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<ScheduleVaultDeletionResponse> scheduleVaultDeletion(ScheduleVaultDeletionRequest request, AsyncHandler<ScheduleVaultDeletionRequest, ScheduleVaultDeletionResponse> handler) {
        LOG.trace("Called async scheduleVaultDeletion");
        ScheduleVaultDeletionRequest interceptedRequest = ScheduleVaultDeletionConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = ScheduleVaultDeletionConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, ScheduleVaultDeletionResponse> transformer = ScheduleVaultDeletionConverter.fromResponse();
        RetryTokenUtils.addRetryToken((WrappedInvocationBuilder)ib);
        AsyncHandler<ScheduleVaultDeletionRequest, ScheduleVaultDeletionResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.postFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<ScheduleVaultDeletionRequest, ScheduleVaultDeletionResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    @Override
    public Future<UpdateVaultResponse> updateVault(UpdateVaultRequest request, AsyncHandler<UpdateVaultRequest, UpdateVaultResponse> handler) {
        LOG.trace("Called async updateVault");
        UpdateVaultRequest interceptedRequest = UpdateVaultConverter.interceptRequest(request);
        WrappedInvocationBuilder ib = UpdateVaultConverter.fromRequest(this.client, interceptedRequest);
        Function<Response, UpdateVaultResponse> transformer = UpdateVaultConverter.fromResponse();
        AsyncHandler<UpdateVaultRequest, UpdateVaultResponse> handlerToUse = handler;
        java.util.function.Function futureSupplier = this.client.putFutureSupplier((BmcRequest)interceptedRequest, ib, transformer);
        if (this.authenticationDetailsProvider instanceof RefreshableOnNotAuthenticatedProvider) {
            return new RefreshAuthTokenWrapper<UpdateVaultRequest, UpdateVaultResponse>((RefreshableOnNotAuthenticatedProvider)this.authenticationDetailsProvider, handlerToUse, futureSupplier){

                protected void beforeRetryAction() {
                }
            };
        }
        return (Future)futureSupplier.apply(handlerToUse);
    }

    RestClient getClient() {
        return this.client;
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, KmsVaultAsyncClient> {
        private Builder(Service service) {
            super(service);
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public KmsVaultAsyncClient build(@NonNull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            if (authenticationDetailsProvider == null) {
                throw new NullPointerException("authenticationDetailsProvider is marked non-null but is null");
            }
            return new KmsVaultAsyncClient(authenticationDetailsProvider, this.configuration, this.clientConfigurator, this.requestSignerFactory, this.signingStrategyRequestSignerFactories, this.additionalClientConfigurators, this.endpoint);
        }
    }
}

