/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.keymanagement.model.GeneratedKey;
import com.oracle.bmc.keymanagement.requests.GenerateDataEncryptionKeyRequest;
import com.oracle.bmc.keymanagement.responses.GenerateDataEncryptionKeyResponse;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateDataEncryptionKeyConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GenerateDataEncryptionKeyConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GenerateDataEncryptionKeyRequest interceptRequest(GenerateDataEncryptionKeyRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GenerateDataEncryptionKeyRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notNull((Object)request.getGenerateKeyDetails(), (String)"generateKeyDetails is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/").path("20180608").path("generateDataEncryptionKey");
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GenerateDataEncryptionKeyResponse> fromResponse() {
        Function<Response, GenerateDataEncryptionKeyResponse> transformer = new Function<Response, GenerateDataEncryptionKeyResponse>(){

            public GenerateDataEncryptionKeyResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.keymanagement.responses.GenerateDataEncryptionKeyResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(GeneratedKey.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GenerateDataEncryptionKeyResponse.Builder builder = GenerateDataEncryptionKeyResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.generatedKey((GeneratedKey)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GenerateDataEncryptionKeyResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

