/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ExportedKeyData {
    @JsonProperty(value="keyVersionId")
    private final String keyVersionId;
    @JsonProperty(value="keyId")
    private final String keyId;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="vaultId")
    private final String vaultId;
    @JsonProperty(value="encryptedKey")
    private final String encryptedKey;
    @JsonProperty(value="algorithm")
    private final Algorithm algorithm;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().keyVersionId(this.keyVersionId).keyId(this.keyId).timeCreated(this.timeCreated).vaultId(this.vaultId).encryptedKey(this.encryptedKey).algorithm(this.algorithm);
    }

    public String getKeyVersionId() {
        return this.keyVersionId;
    }

    public String getKeyId() {
        return this.keyId;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getVaultId() {
        return this.vaultId;
    }

    public String getEncryptedKey() {
        return this.encryptedKey;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExportedKeyData)) {
            return false;
        }
        ExportedKeyData other = (ExportedKeyData)o;
        String this$keyVersionId = this.getKeyVersionId();
        String other$keyVersionId = other.getKeyVersionId();
        if (this$keyVersionId == null ? other$keyVersionId != null : !this$keyVersionId.equals(other$keyVersionId)) {
            return false;
        }
        String this$keyId = this.getKeyId();
        String other$keyId = other.getKeyId();
        if (this$keyId == null ? other$keyId != null : !this$keyId.equals(other$keyId)) {
            return false;
        }
        Date this$timeCreated = this.getTimeCreated();
        Date other$timeCreated = other.getTimeCreated();
        if (this$timeCreated == null ? other$timeCreated != null : !((Object)this$timeCreated).equals(other$timeCreated)) {
            return false;
        }
        String this$vaultId = this.getVaultId();
        String other$vaultId = other.getVaultId();
        if (this$vaultId == null ? other$vaultId != null : !this$vaultId.equals(other$vaultId)) {
            return false;
        }
        String this$encryptedKey = this.getEncryptedKey();
        String other$encryptedKey = other.getEncryptedKey();
        if (this$encryptedKey == null ? other$encryptedKey != null : !this$encryptedKey.equals(other$encryptedKey)) {
            return false;
        }
        Algorithm this$algorithm = this.getAlgorithm();
        Algorithm other$algorithm = other.getAlgorithm();
        if (this$algorithm == null ? other$algorithm != null : !((Object)((Object)this$algorithm)).equals((Object)other$algorithm)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyVersionId = this.getKeyVersionId();
        result = result * 59 + ($keyVersionId == null ? 43 : $keyVersionId.hashCode());
        String $keyId = this.getKeyId();
        result = result * 59 + ($keyId == null ? 43 : $keyId.hashCode());
        Date $timeCreated = this.getTimeCreated();
        result = result * 59 + ($timeCreated == null ? 43 : ((Object)$timeCreated).hashCode());
        String $vaultId = this.getVaultId();
        result = result * 59 + ($vaultId == null ? 43 : $vaultId.hashCode());
        String $encryptedKey = this.getEncryptedKey();
        result = result * 59 + ($encryptedKey == null ? 43 : $encryptedKey.hashCode());
        Algorithm $algorithm = this.getAlgorithm();
        result = result * 59 + ($algorithm == null ? 43 : ((Object)((Object)$algorithm)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "ExportedKeyData(keyVersionId=" + this.getKeyVersionId() + ", keyId=" + this.getKeyId() + ", timeCreated=" + this.getTimeCreated() + ", vaultId=" + this.getVaultId() + ", encryptedKey=" + this.getEncryptedKey() + ", algorithm=" + (Object)((Object)this.getAlgorithm()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"keyVersionId", "keyId", "timeCreated", "vaultId", "encryptedKey", "algorithm"})
    @Deprecated
    public ExportedKeyData(String keyVersionId, String keyId, Date timeCreated, String vaultId, String encryptedKey, Algorithm algorithm) {
        this.keyVersionId = keyVersionId;
        this.keyId = keyId;
        this.timeCreated = timeCreated;
        this.vaultId = vaultId;
        this.encryptedKey = encryptedKey;
        this.algorithm = algorithm;
    }

    public static enum Algorithm {
        RsaOaepAesSha256("RSA_OAEP_AES_SHA256"),
        RsaOaepSha256("RSA_OAEP_SHA256"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Algorithm> map;

        private Algorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Algorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Algorithm', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Algorithm.class);
            map = new HashMap<String, Algorithm>();
            for (Algorithm v : Algorithm.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="keyVersionId")
        private String keyVersionId;
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="vaultId")
        private String vaultId;
        @JsonProperty(value="encryptedKey")
        private String encryptedKey;
        @JsonProperty(value="algorithm")
        private Algorithm algorithm;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder keyVersionId(String keyVersionId) {
            this.keyVersionId = keyVersionId;
            this.__explicitlySet__.add("keyVersionId");
            return this;
        }

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder vaultId(String vaultId) {
            this.vaultId = vaultId;
            this.__explicitlySet__.add("vaultId");
            return this;
        }

        public Builder encryptedKey(String encryptedKey) {
            this.encryptedKey = encryptedKey;
            this.__explicitlySet__.add("encryptedKey");
            return this;
        }

        public Builder algorithm(Algorithm algorithm) {
            this.algorithm = algorithm;
            this.__explicitlySet__.add("algorithm");
            return this;
        }

        public ExportedKeyData build() {
            ExportedKeyData __instance__ = new ExportedKeyData(this.keyVersionId, this.keyId, this.timeCreated, this.vaultId, this.encryptedKey, this.algorithm);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(ExportedKeyData o) {
            Builder copiedBuilder = this.keyVersionId(o.getKeyVersionId()).keyId(o.getKeyId()).timeCreated(o.getTimeCreated()).vaultId(o.getVaultId()).encryptedKey(o.getEncryptedKey()).algorithm(o.getAlgorithm());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "ExportedKeyData.Builder(keyVersionId=" + this.keyVersionId + ", keyId=" + this.keyId + ", timeCreated=" + this.timeCreated + ", vaultId=" + this.vaultId + ", encryptedKey=" + this.encryptedKey + ", algorithm=" + (Object)((Object)this.algorithm) + ")";
        }
    }
}

