/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SignedData {
    @JsonProperty(value="keyId")
    private final String keyId;
    @JsonProperty(value="keyVersionId")
    private final String keyVersionId;
    @JsonProperty(value="signature")
    private final String signature;
    @JsonProperty(value="signingAlgorithm")
    private final SigningAlgorithm signingAlgorithm;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().keyId(this.keyId).keyVersionId(this.keyVersionId).signature(this.signature).signingAlgorithm(this.signingAlgorithm);
    }

    public String getKeyId() {
        return this.keyId;
    }

    public String getKeyVersionId() {
        return this.keyVersionId;
    }

    public String getSignature() {
        return this.signature;
    }

    public SigningAlgorithm getSigningAlgorithm() {
        return this.signingAlgorithm;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SignedData)) {
            return false;
        }
        SignedData other = (SignedData)o;
        String this$keyId = this.getKeyId();
        String other$keyId = other.getKeyId();
        if (this$keyId == null ? other$keyId != null : !this$keyId.equals(other$keyId)) {
            return false;
        }
        String this$keyVersionId = this.getKeyVersionId();
        String other$keyVersionId = other.getKeyVersionId();
        if (this$keyVersionId == null ? other$keyVersionId != null : !this$keyVersionId.equals(other$keyVersionId)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        if (this$signature == null ? other$signature != null : !this$signature.equals(other$signature)) {
            return false;
        }
        SigningAlgorithm this$signingAlgorithm = this.getSigningAlgorithm();
        SigningAlgorithm other$signingAlgorithm = other.getSigningAlgorithm();
        if (this$signingAlgorithm == null ? other$signingAlgorithm != null : !((Object)((Object)this$signingAlgorithm)).equals((Object)other$signingAlgorithm)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyId = this.getKeyId();
        result = result * 59 + ($keyId == null ? 43 : $keyId.hashCode());
        String $keyVersionId = this.getKeyVersionId();
        result = result * 59 + ($keyVersionId == null ? 43 : $keyVersionId.hashCode());
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 43 : $signature.hashCode());
        SigningAlgorithm $signingAlgorithm = this.getSigningAlgorithm();
        result = result * 59 + ($signingAlgorithm == null ? 43 : ((Object)((Object)$signingAlgorithm)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "SignedData(keyId=" + this.getKeyId() + ", keyVersionId=" + this.getKeyVersionId() + ", signature=" + this.getSignature() + ", signingAlgorithm=" + (Object)((Object)this.getSigningAlgorithm()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"keyId", "keyVersionId", "signature", "signingAlgorithm"})
    @Deprecated
    public SignedData(String keyId, String keyVersionId, String signature, SigningAlgorithm signingAlgorithm) {
        this.keyId = keyId;
        this.keyVersionId = keyVersionId;
        this.signature = signature;
        this.signingAlgorithm = signingAlgorithm;
    }

    public static enum SigningAlgorithm {
        Sha224RsaPkcsPss("SHA_224_RSA_PKCS_PSS"),
        Sha256RsaPkcsPss("SHA_256_RSA_PKCS_PSS"),
        Sha384RsaPkcsPss("SHA_384_RSA_PKCS_PSS"),
        Sha512RsaPkcsPss("SHA_512_RSA_PKCS_PSS"),
        Sha224RsaPkcs1V15("SHA_224_RSA_PKCS1_V1_5"),
        Sha256RsaPkcs1V15("SHA_256_RSA_PKCS1_V1_5"),
        Sha384RsaPkcs1V15("SHA_384_RSA_PKCS1_V1_5"),
        Sha512RsaPkcs1V15("SHA_512_RSA_PKCS1_V1_5"),
        EcdsaSha256("ECDSA_SHA_256"),
        EcdsaSha384("ECDSA_SHA_384"),
        EcdsaSha512("ECDSA_SHA_512"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SigningAlgorithm> map;

        private SigningAlgorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SigningAlgorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SigningAlgorithm', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SigningAlgorithm.class);
            map = new HashMap<String, SigningAlgorithm>();
            for (SigningAlgorithm v : SigningAlgorithm.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="keyId")
        private String keyId;
        @JsonProperty(value="keyVersionId")
        private String keyVersionId;
        @JsonProperty(value="signature")
        private String signature;
        @JsonProperty(value="signingAlgorithm")
        private SigningAlgorithm signingAlgorithm;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder keyId(String keyId) {
            this.keyId = keyId;
            this.__explicitlySet__.add("keyId");
            return this;
        }

        public Builder keyVersionId(String keyVersionId) {
            this.keyVersionId = keyVersionId;
            this.__explicitlySet__.add("keyVersionId");
            return this;
        }

        public Builder signature(String signature) {
            this.signature = signature;
            this.__explicitlySet__.add("signature");
            return this;
        }

        public Builder signingAlgorithm(SigningAlgorithm signingAlgorithm) {
            this.signingAlgorithm = signingAlgorithm;
            this.__explicitlySet__.add("signingAlgorithm");
            return this;
        }

        public SignedData build() {
            SignedData __instance__ = new SignedData(this.keyId, this.keyVersionId, this.signature, this.signingAlgorithm);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(SignedData o) {
            Builder copiedBuilder = this.keyId(o.getKeyId()).keyVersionId(o.getKeyVersionId()).signature(o.getSignature()).signingAlgorithm(o.getSigningAlgorithm());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "SignedData.Builder(keyId=" + this.keyId + ", keyVersionId=" + this.keyVersionId + ", signature=" + this.signature + ", signingAlgorithm=" + (Object)((Object)this.signingAlgorithm) + ")";
        }
    }
}

