/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WrappedImportKey {
    @JsonProperty(value="keyMaterial")
    private final String keyMaterial;
    @JsonProperty(value="wrappingAlgorithm")
    private final WrappingAlgorithm wrappingAlgorithm;
    @JsonIgnore
    private final Set<String> __explicitlySet__ = new HashSet<String>();

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().keyMaterial(this.keyMaterial).wrappingAlgorithm(this.wrappingAlgorithm);
    }

    public String getKeyMaterial() {
        return this.keyMaterial;
    }

    public WrappingAlgorithm getWrappingAlgorithm() {
        return this.wrappingAlgorithm;
    }

    public Set<String> get__explicitlySet__() {
        return this.__explicitlySet__;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WrappedImportKey)) {
            return false;
        }
        WrappedImportKey other = (WrappedImportKey)o;
        String this$keyMaterial = this.getKeyMaterial();
        String other$keyMaterial = other.getKeyMaterial();
        if (this$keyMaterial == null ? other$keyMaterial != null : !this$keyMaterial.equals(other$keyMaterial)) {
            return false;
        }
        WrappingAlgorithm this$wrappingAlgorithm = this.getWrappingAlgorithm();
        WrappingAlgorithm other$wrappingAlgorithm = other.getWrappingAlgorithm();
        if (this$wrappingAlgorithm == null ? other$wrappingAlgorithm != null : !((Object)((Object)this$wrappingAlgorithm)).equals((Object)other$wrappingAlgorithm)) {
            return false;
        }
        Set<String> this$__explicitlySet__ = this.get__explicitlySet__();
        Set<String> other$__explicitlySet__ = other.get__explicitlySet__();
        return !(this$__explicitlySet__ == null ? other$__explicitlySet__ != null : !((Object)this$__explicitlySet__).equals(other$__explicitlySet__));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $keyMaterial = this.getKeyMaterial();
        result = result * 59 + ($keyMaterial == null ? 43 : $keyMaterial.hashCode());
        WrappingAlgorithm $wrappingAlgorithm = this.getWrappingAlgorithm();
        result = result * 59 + ($wrappingAlgorithm == null ? 43 : ((Object)((Object)$wrappingAlgorithm)).hashCode());
        Set<String> $__explicitlySet__ = this.get__explicitlySet__();
        result = result * 59 + ($__explicitlySet__ == null ? 43 : ((Object)$__explicitlySet__).hashCode());
        return result;
    }

    public String toString() {
        return "WrappedImportKey(keyMaterial=" + this.getKeyMaterial() + ", wrappingAlgorithm=" + (Object)((Object)this.getWrappingAlgorithm()) + ", __explicitlySet__=" + this.get__explicitlySet__() + ")";
    }

    @ConstructorProperties(value={"keyMaterial", "wrappingAlgorithm"})
    @Deprecated
    public WrappedImportKey(String keyMaterial, WrappingAlgorithm wrappingAlgorithm) {
        this.keyMaterial = keyMaterial;
        this.wrappingAlgorithm = wrappingAlgorithm;
    }

    public static enum WrappingAlgorithm {
        RsaOaepSha256("RSA_OAEP_SHA256"),
        RsaOaepAesSha256("RSA_OAEP_AES_SHA256");

        private final String value;
        private static Map<String, WrappingAlgorithm> map;

        private WrappingAlgorithm(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static WrappingAlgorithm create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid WrappingAlgorithm: " + key);
        }

        static {
            map = new HashMap<String, WrappingAlgorithm>();
            for (WrappingAlgorithm v : WrappingAlgorithm.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="keyMaterial")
        private String keyMaterial;
        @JsonProperty(value="wrappingAlgorithm")
        private WrappingAlgorithm wrappingAlgorithm;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder keyMaterial(String keyMaterial) {
            this.keyMaterial = keyMaterial;
            this.__explicitlySet__.add("keyMaterial");
            return this;
        }

        public Builder wrappingAlgorithm(WrappingAlgorithm wrappingAlgorithm) {
            this.wrappingAlgorithm = wrappingAlgorithm;
            this.__explicitlySet__.add("wrappingAlgorithm");
            return this;
        }

        public WrappedImportKey build() {
            WrappedImportKey __instance__ = new WrappedImportKey(this.keyMaterial, this.wrappingAlgorithm);
            __instance__.__explicitlySet__.addAll(this.__explicitlySet__);
            return __instance__;
        }

        @JsonIgnore
        public Builder copy(WrappedImportKey o) {
            Builder copiedBuilder = this.keyMaterial(o.getKeyMaterial()).wrappingAlgorithm(o.getWrappingAlgorithm());
            copiedBuilder.__explicitlySet__.retainAll(o.__explicitlySet__);
            return copiedBuilder;
        }

        Builder() {
        }

        public String toString() {
            return "WrappedImportKey.Builder(keyMaterial=" + this.keyMaterial + ", wrappingAlgorithm=" + (Object)((Object)this.wrappingAlgorithm) + ")";
        }
    }
}

