/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.keymanagement.model.DecryptDataDetails;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class DecryptRequest
extends BmcRequest<DecryptDataDetails> {
    private DecryptDataDetails decryptDataDetails;
    private String opcRequestId;

    @InternalSdk
    public DecryptDataDetails getBody$() {
        return this.decryptDataDetails;
    }

    @ConstructorProperties(value={"decryptDataDetails", "opcRequestId"})
    DecryptRequest(DecryptDataDetails decryptDataDetails, String opcRequestId) {
        this.decryptDataDetails = decryptDataDetails;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DecryptDataDetails getDecryptDataDetails() {
        return this.decryptDataDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<DecryptRequest, DecryptDataDetails> {
        private DecryptDataDetails decryptDataDetails;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DecryptRequest o) {
            this.decryptDataDetails(o.getDecryptDataDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DecryptRequest build() {
            DecryptRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(DecryptDataDetails body) {
            this.decryptDataDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder decryptDataDetails(DecryptDataDetails decryptDataDetails) {
            this.decryptDataDetails = decryptDataDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public DecryptRequest buildWithoutInvocationCallback() {
            return new DecryptRequest(this.decryptDataDetails, this.opcRequestId);
        }

        public String toString() {
            return "DecryptRequest.Builder(decryptDataDetails=" + this.decryptDataDetails + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

