/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.keymanagement.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import java.io.InputStream;
import javax.ws.rs.client.Invocation;

public class RestoreVaultFromFileRequest
extends BmcRequest<InputStream> {
    private String compartmentId;
    private Long contentLength;
    private InputStream restoreVaultFromFileDetails;
    private String ifMatch;
    private String contentMd5;
    private String opcRequestId;
    private String opcRetryToken;

    @InternalSdk
    public InputStream getBody$() {
        return this.restoreVaultFromFileDetails;
    }

    @ConstructorProperties(value={"compartmentId", "contentLength", "restoreVaultFromFileDetails", "ifMatch", "contentMd5", "opcRequestId", "opcRetryToken"})
    RestoreVaultFromFileRequest(String compartmentId, Long contentLength, InputStream restoreVaultFromFileDetails, String ifMatch, String contentMd5, String opcRequestId, String opcRetryToken) {
        this.compartmentId = compartmentId;
        this.contentLength = contentLength;
        this.restoreVaultFromFileDetails = restoreVaultFromFileDetails;
        this.ifMatch = ifMatch;
        this.contentMd5 = contentMd5;
        this.opcRequestId = opcRequestId;
        this.opcRetryToken = opcRetryToken;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public InputStream getRestoreVaultFromFileDetails() {
        return this.restoreVaultFromFileDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getContentMd5() {
        return this.contentMd5;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public static class Builder
    implements BmcRequest.Builder<RestoreVaultFromFileRequest, InputStream> {
        private String compartmentId;
        private Long contentLength;
        private InputStream restoreVaultFromFileDetails;
        private String ifMatch;
        private String contentMd5;
        private String opcRequestId;
        private String opcRetryToken;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(RestoreVaultFromFileRequest o) {
            this.compartmentId(o.getCompartmentId());
            this.contentLength(o.getContentLength());
            this.restoreVaultFromFileDetails(o.getRestoreVaultFromFileDetails());
            this.ifMatch(o.getIfMatch());
            this.contentMd5(o.getContentMd5());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public RestoreVaultFromFileRequest build() {
            RestoreVaultFromFileRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(InputStream body) {
            this.restoreVaultFromFileDetails(body);
            return this;
        }

        Builder() {
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder contentLength(Long contentLength) {
            this.contentLength = contentLength;
            return this;
        }

        public Builder restoreVaultFromFileDetails(InputStream restoreVaultFromFileDetails) {
            this.restoreVaultFromFileDetails = restoreVaultFromFileDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder contentMd5(String contentMd5) {
            this.contentMd5 = contentMd5;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public RestoreVaultFromFileRequest buildWithoutInvocationCallback() {
            return new RestoreVaultFromFileRequest(this.compartmentId, this.contentLength, this.restoreVaultFromFileDetails, this.ifMatch, this.contentMd5, this.opcRequestId, this.opcRetryToken);
        }

        public String toString() {
            return "RestoreVaultFromFileRequest.Builder(compartmentId=" + this.compartmentId + ", contentLength=" + this.contentLength + ", restoreVaultFromFileDetails=" + this.restoreVaultFromFileDetails + ", ifMatch=" + this.ifMatch + ", contentMd5=" + this.contentMd5 + ", opcRequestId=" + this.opcRequestId + ", opcRetryToken=" + this.opcRetryToken + ")";
        }
    }
}

