/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.oracle.bmc.loadbalancer.LoadBalancer;
import com.oracle.bmc.loadbalancer.model.LoadBalancerHealthSummary;
import com.oracle.bmc.loadbalancer.model.LoadBalancerPolicy;
import com.oracle.bmc.loadbalancer.model.LoadBalancerProtocol;
import com.oracle.bmc.loadbalancer.model.LoadBalancerShape;
import com.oracle.bmc.loadbalancer.model.RoutingPolicy;
import com.oracle.bmc.loadbalancer.model.WorkRequest;
import com.oracle.bmc.loadbalancer.requests.ListLoadBalancerHealthsRequest;
import com.oracle.bmc.loadbalancer.requests.ListLoadBalancersRequest;
import com.oracle.bmc.loadbalancer.requests.ListPoliciesRequest;
import com.oracle.bmc.loadbalancer.requests.ListProtocolsRequest;
import com.oracle.bmc.loadbalancer.requests.ListRoutingPoliciesRequest;
import com.oracle.bmc.loadbalancer.requests.ListShapesRequest;
import com.oracle.bmc.loadbalancer.requests.ListWorkRequestsRequest;
import com.oracle.bmc.loadbalancer.responses.ListLoadBalancerHealthsResponse;
import com.oracle.bmc.loadbalancer.responses.ListLoadBalancersResponse;
import com.oracle.bmc.loadbalancer.responses.ListPoliciesResponse;
import com.oracle.bmc.loadbalancer.responses.ListProtocolsResponse;
import com.oracle.bmc.loadbalancer.responses.ListRoutingPoliciesResponse;
import com.oracle.bmc.loadbalancer.responses.ListShapesResponse;
import com.oracle.bmc.loadbalancer.responses.ListWorkRequestsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.beans.ConstructorProperties;
import java.util.List;

public class LoadBalancerPaginators {
    private final LoadBalancer client;

    public Iterable<ListLoadBalancerHealthsResponse> listLoadBalancerHealthsResponseIterator(final ListLoadBalancerHealthsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListLoadBalancerHealthsRequest.Builder>(){

            public ListLoadBalancerHealthsRequest.Builder get() {
                return ListLoadBalancerHealthsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLoadBalancerHealthsResponse, String>(){

            public String apply(ListLoadBalancerHealthsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLoadBalancerHealthsRequest.Builder>, ListLoadBalancerHealthsRequest>(){

            public ListLoadBalancerHealthsRequest apply(RequestBuilderAndToken<ListLoadBalancerHealthsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListLoadBalancerHealthsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLoadBalancerHealthsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListLoadBalancerHealthsRequest, ListLoadBalancerHealthsResponse>(){

            public ListLoadBalancerHealthsResponse apply(ListLoadBalancerHealthsRequest request) {
                return LoadBalancerPaginators.this.client.listLoadBalancerHealths(request);
            }
        });
    }

    public Iterable<LoadBalancerHealthSummary> listLoadBalancerHealthsRecordIterator(final ListLoadBalancerHealthsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListLoadBalancerHealthsRequest.Builder>(){

            public ListLoadBalancerHealthsRequest.Builder get() {
                return ListLoadBalancerHealthsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLoadBalancerHealthsResponse, String>(){

            public String apply(ListLoadBalancerHealthsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLoadBalancerHealthsRequest.Builder>, ListLoadBalancerHealthsRequest>(){

            public ListLoadBalancerHealthsRequest apply(RequestBuilderAndToken<ListLoadBalancerHealthsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListLoadBalancerHealthsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLoadBalancerHealthsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListLoadBalancerHealthsRequest, ListLoadBalancerHealthsResponse>(){

            public ListLoadBalancerHealthsResponse apply(ListLoadBalancerHealthsRequest request) {
                return LoadBalancerPaginators.this.client.listLoadBalancerHealths(request);
            }
        }, (Function)new Function<ListLoadBalancerHealthsResponse, List<LoadBalancerHealthSummary>>(){

            public List<LoadBalancerHealthSummary> apply(ListLoadBalancerHealthsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListLoadBalancersResponse> listLoadBalancersResponseIterator(final ListLoadBalancersRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListLoadBalancersRequest.Builder>(){

            public ListLoadBalancersRequest.Builder get() {
                return ListLoadBalancersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLoadBalancersResponse, String>(){

            public String apply(ListLoadBalancersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLoadBalancersRequest.Builder>, ListLoadBalancersRequest>(){

            public ListLoadBalancersRequest apply(RequestBuilderAndToken<ListLoadBalancersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListLoadBalancersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLoadBalancersRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListLoadBalancersRequest, ListLoadBalancersResponse>(){

            public ListLoadBalancersResponse apply(ListLoadBalancersRequest request) {
                return LoadBalancerPaginators.this.client.listLoadBalancers(request);
            }
        });
    }

    public Iterable<com.oracle.bmc.loadbalancer.model.LoadBalancer> listLoadBalancersRecordIterator(final ListLoadBalancersRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListLoadBalancersRequest.Builder>(){

            public ListLoadBalancersRequest.Builder get() {
                return ListLoadBalancersRequest.builder().copy(request);
            }
        }, (Function)new Function<ListLoadBalancersResponse, String>(){

            public String apply(ListLoadBalancersResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListLoadBalancersRequest.Builder>, ListLoadBalancersRequest>(){

            public ListLoadBalancersRequest apply(RequestBuilderAndToken<ListLoadBalancersRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListLoadBalancersRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListLoadBalancersRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListLoadBalancersRequest, ListLoadBalancersResponse>(){

            public ListLoadBalancersResponse apply(ListLoadBalancersRequest request) {
                return LoadBalancerPaginators.this.client.listLoadBalancers(request);
            }
        }, (Function)new Function<ListLoadBalancersResponse, List<com.oracle.bmc.loadbalancer.model.LoadBalancer>>(){

            public List<com.oracle.bmc.loadbalancer.model.LoadBalancer> apply(ListLoadBalancersResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListPoliciesResponse> listPoliciesResponseIterator(final ListPoliciesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListPoliciesRequest.Builder>(){

            public ListPoliciesRequest.Builder get() {
                return ListPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPoliciesResponse, String>(){

            public String apply(ListPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPoliciesRequest.Builder>, ListPoliciesRequest>(){

            public ListPoliciesRequest apply(RequestBuilderAndToken<ListPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPoliciesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPoliciesRequest, ListPoliciesResponse>(){

            public ListPoliciesResponse apply(ListPoliciesRequest request) {
                return LoadBalancerPaginators.this.client.listPolicies(request);
            }
        });
    }

    public Iterable<LoadBalancerPolicy> listPoliciesRecordIterator(final ListPoliciesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListPoliciesRequest.Builder>(){

            public ListPoliciesRequest.Builder get() {
                return ListPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListPoliciesResponse, String>(){

            public String apply(ListPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListPoliciesRequest.Builder>, ListPoliciesRequest>(){

            public ListPoliciesRequest apply(RequestBuilderAndToken<ListPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListPoliciesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListPoliciesRequest, ListPoliciesResponse>(){

            public ListPoliciesResponse apply(ListPoliciesRequest request) {
                return LoadBalancerPaginators.this.client.listPolicies(request);
            }
        }, (Function)new Function<ListPoliciesResponse, List<LoadBalancerPolicy>>(){

            public List<LoadBalancerPolicy> apply(ListPoliciesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListProtocolsResponse> listProtocolsResponseIterator(final ListProtocolsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListProtocolsRequest.Builder>(){

            public ListProtocolsRequest.Builder get() {
                return ListProtocolsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProtocolsResponse, String>(){

            public String apply(ListProtocolsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProtocolsRequest.Builder>, ListProtocolsRequest>(){

            public ListProtocolsRequest apply(RequestBuilderAndToken<ListProtocolsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListProtocolsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProtocolsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListProtocolsRequest, ListProtocolsResponse>(){

            public ListProtocolsResponse apply(ListProtocolsRequest request) {
                return LoadBalancerPaginators.this.client.listProtocols(request);
            }
        });
    }

    public Iterable<LoadBalancerProtocol> listProtocolsRecordIterator(final ListProtocolsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListProtocolsRequest.Builder>(){

            public ListProtocolsRequest.Builder get() {
                return ListProtocolsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListProtocolsResponse, String>(){

            public String apply(ListProtocolsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListProtocolsRequest.Builder>, ListProtocolsRequest>(){

            public ListProtocolsRequest apply(RequestBuilderAndToken<ListProtocolsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListProtocolsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListProtocolsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListProtocolsRequest, ListProtocolsResponse>(){

            public ListProtocolsResponse apply(ListProtocolsRequest request) {
                return LoadBalancerPaginators.this.client.listProtocols(request);
            }
        }, (Function)new Function<ListProtocolsResponse, List<LoadBalancerProtocol>>(){

            public List<LoadBalancerProtocol> apply(ListProtocolsResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListRoutingPoliciesResponse> listRoutingPoliciesResponseIterator(final ListRoutingPoliciesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRoutingPoliciesRequest.Builder>(){

            public ListRoutingPoliciesRequest.Builder get() {
                return ListRoutingPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRoutingPoliciesResponse, String>(){

            public String apply(ListRoutingPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRoutingPoliciesRequest.Builder>, ListRoutingPoliciesRequest>(){

            public ListRoutingPoliciesRequest apply(RequestBuilderAndToken<ListRoutingPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRoutingPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRoutingPoliciesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRoutingPoliciesRequest, ListRoutingPoliciesResponse>(){

            public ListRoutingPoliciesResponse apply(ListRoutingPoliciesRequest request) {
                return LoadBalancerPaginators.this.client.listRoutingPolicies(request);
            }
        });
    }

    public Iterable<RoutingPolicy> listRoutingPoliciesRecordIterator(final ListRoutingPoliciesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRoutingPoliciesRequest.Builder>(){

            public ListRoutingPoliciesRequest.Builder get() {
                return ListRoutingPoliciesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRoutingPoliciesResponse, String>(){

            public String apply(ListRoutingPoliciesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRoutingPoliciesRequest.Builder>, ListRoutingPoliciesRequest>(){

            public ListRoutingPoliciesRequest apply(RequestBuilderAndToken<ListRoutingPoliciesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListRoutingPoliciesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRoutingPoliciesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListRoutingPoliciesRequest, ListRoutingPoliciesResponse>(){

            public ListRoutingPoliciesResponse apply(ListRoutingPoliciesRequest request) {
                return LoadBalancerPaginators.this.client.listRoutingPolicies(request);
            }
        }, (Function)new Function<ListRoutingPoliciesResponse, List<RoutingPolicy>>(){

            public List<RoutingPolicy> apply(ListRoutingPoliciesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListShapesResponse> listShapesResponseIterator(final ListShapesRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListShapesRequest.Builder>(){

            public ListShapesRequest.Builder get() {
                return ListShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListShapesResponse, String>(){

            public String apply(ListShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListShapesRequest.Builder>, ListShapesRequest>(){

            public ListShapesRequest apply(RequestBuilderAndToken<ListShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListShapesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListShapesRequest, ListShapesResponse>(){

            public ListShapesResponse apply(ListShapesRequest request) {
                return LoadBalancerPaginators.this.client.listShapes(request);
            }
        });
    }

    public Iterable<LoadBalancerShape> listShapesRecordIterator(final ListShapesRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListShapesRequest.Builder>(){

            public ListShapesRequest.Builder get() {
                return ListShapesRequest.builder().copy(request);
            }
        }, (Function)new Function<ListShapesResponse, String>(){

            public String apply(ListShapesResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListShapesRequest.Builder>, ListShapesRequest>(){

            public ListShapesRequest apply(RequestBuilderAndToken<ListShapesRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListShapesRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListShapesRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListShapesRequest, ListShapesResponse>(){

            public ListShapesResponse apply(ListShapesRequest request) {
                return LoadBalancerPaginators.this.client.listShapes(request);
            }
        }, (Function)new Function<ListShapesResponse, List<LoadBalancerShape>>(){

            public List<LoadBalancerShape> apply(ListShapesResponse response) {
                return response.getItems();
            }
        });
    }

    public Iterable<ListWorkRequestsResponse> listWorkRequestsResponseIterator(final ListWorkRequestsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return LoadBalancerPaginators.this.client.listWorkRequests(request);
            }
        });
    }

    public Iterable<WorkRequest> listWorkRequestsRecordIterator(final ListWorkRequestsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListWorkRequestsRequest.Builder>(){

            public ListWorkRequestsRequest.Builder get() {
                return ListWorkRequestsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, String>(){

            public String apply(ListWorkRequestsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListWorkRequestsRequest.Builder>, ListWorkRequestsRequest>(){

            public ListWorkRequestsRequest apply(RequestBuilderAndToken<ListWorkRequestsRequest.Builder> input) {
                if (input.getToken() == null) {
                    return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListWorkRequestsRequest.Builder)input.getRequestBuilder()).page((String)input.getToken().orNull()).build();
            }
        }, (Function)new Function<ListWorkRequestsRequest, ListWorkRequestsResponse>(){

            public ListWorkRequestsResponse apply(ListWorkRequestsRequest request) {
                return LoadBalancerPaginators.this.client.listWorkRequests(request);
            }
        }, (Function)new Function<ListWorkRequestsResponse, List<WorkRequest>>(){

            public List<WorkRequest> apply(ListWorkRequestsResponse response) {
                return response.getItems();
            }
        });
    }

    @ConstructorProperties(value={"client"})
    public LoadBalancerPaginators(LoadBalancer client) {
        this.client = client;
    }
}

