/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.loadbalancer.model.Backend;
import com.oracle.bmc.loadbalancer.requests.GetBackendRequest;
import com.oracle.bmc.loadbalancer.responses.GetBackendResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetBackendConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetBackendConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetBackendRequest interceptRequest(GetBackendRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetBackendRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getLoadBalancerId(), (String)"loadBalancerId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBackendSetName(), (String)"backendSetName must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getBackendName(), (String)"backendName must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20170115").path("loadBalancers").path(HttpUtils.encodePathSegment((String)request.getLoadBalancerId())).path("backendSets").path(HttpUtils.encodePathSegment((String)request.getBackendSetName())).path("backends").path(HttpUtils.encodePathSegment((String)request.getBackendName()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetBackendResponse> fromResponse() {
        Function<Response, GetBackendResponse> transformer = new Function<Response, GetBackendResponse>(){

            public GetBackendResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.loadbalancer.responses.GetBackendResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(Backend.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetBackendResponse.Builder builder = GetBackendResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.backend((Backend)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                GetBackendResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

