/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loadbalancer.requests;

import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import com.oracle.bmc.util.internal.Consumer;
import java.beans.ConstructorProperties;
import javax.ws.rs.client.Invocation;

public class GetRoutingPolicyRequest
extends BmcRequest<Void> {
    private String loadBalancerId;
    private String routingPolicyName;
    private String opcRequestId;

    @ConstructorProperties(value={"loadBalancerId", "routingPolicyName", "opcRequestId"})
    GetRoutingPolicyRequest(String loadBalancerId, String routingPolicyName, String opcRequestId) {
        this.loadBalancerId = loadBalancerId;
        this.routingPolicyName = routingPolicyName;
        this.opcRequestId = opcRequestId;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getLoadBalancerId() {
        return this.loadBalancerId;
    }

    public String getRoutingPolicyName() {
        return this.routingPolicyName;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRoutingPolicyRequest, Void> {
        private String loadBalancerId;
        private String routingPolicyName;
        private String opcRequestId;
        private Consumer<Invocation.Builder> invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;

        public Builder invocationCallback(Consumer<Invocation.Builder> invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRoutingPolicyRequest o) {
            this.loadBalancerId(o.getLoadBalancerId());
            this.routingPolicyName(o.getRoutingPolicyName());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback((Consumer<Invocation.Builder>)o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRoutingPolicyRequest build() {
            GetRoutingPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        Builder() {
        }

        public Builder loadBalancerId(String loadBalancerId) {
            this.loadBalancerId = loadBalancerId;
            return this;
        }

        public Builder routingPolicyName(String routingPolicyName) {
            this.routingPolicyName = routingPolicyName;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public GetRoutingPolicyRequest buildWithoutInvocationCallback() {
            return new GetRoutingPolicyRequest(this.loadBalancerId, this.routingPolicyName, this.opcRequestId);
        }

        public String toString() {
            return "GetRoutingPolicyRequest.Builder(loadBalancerId=" + this.loadBalancerId + ", routingPolicyName=" + this.routingPolicyName + ", opcRequestId=" + this.opcRequestId + ")";
        }
    }
}

