/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Suppliers;
import com.oracle.bmc.loganalytics.LogAnalytics;
import com.oracle.bmc.loganalytics.model.EntityLifecycleStates;
import com.oracle.bmc.loganalytics.model.ObjectCollectionRuleLifecycleStates;
import com.oracle.bmc.loganalytics.model.ScheduledTask;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsEntityRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsEntityTypeRequest;
import com.oracle.bmc.loganalytics.requests.GetLogAnalyticsObjectCollectionRuleRequest;
import com.oracle.bmc.loganalytics.requests.GetQueryWorkRequestRequest;
import com.oracle.bmc.loganalytics.requests.GetScheduledTaskRequest;
import com.oracle.bmc.loganalytics.requests.GetStorageWorkRequestRequest;
import com.oracle.bmc.loganalytics.requests.GetWorkRequestRequest;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsEntityResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsEntityTypeResponse;
import com.oracle.bmc.loganalytics.responses.GetLogAnalyticsObjectCollectionRuleResponse;
import com.oracle.bmc.loganalytics.responses.GetQueryWorkRequestResponse;
import com.oracle.bmc.loganalytics.responses.GetScheduledTaskResponse;
import com.oracle.bmc.loganalytics.responses.GetStorageWorkRequestResponse;
import com.oracle.bmc.loganalytics.responses.GetWorkRequestResponse;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.apache.commons.lang3.Validate;

public class LogAnalyticsWaiters {
    private final ExecutorService executorService;
    private final LogAnalytics client;

    public Waiter<GetLogAnalyticsEntityRequest, GetLogAnalyticsEntityResponse> forLogAnalyticsEntity(GetLogAnalyticsEntityRequest request, EntityLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLogAnalyticsEntity(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetLogAnalyticsEntityRequest, GetLogAnalyticsEntityResponse> forLogAnalyticsEntity(GetLogAnalyticsEntityRequest request, EntityLifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forLogAnalyticsEntity(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetLogAnalyticsEntityRequest, GetLogAnalyticsEntityResponse> forLogAnalyticsEntity(GetLogAnalyticsEntityRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, EntityLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLogAnalyticsEntity(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetLogAnalyticsEntityRequest, GetLogAnalyticsEntityResponse> forLogAnalyticsEntity(BmcGenericWaiter waiter, GetLogAnalyticsEntityRequest request, EntityLifecycleStates ... targetStates) {
        final HashSet<EntityLifecycleStates> targetStatesSet = new HashSet<EntityLifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetLogAnalyticsEntityRequest, GetLogAnalyticsEntityResponse>(){

            public GetLogAnalyticsEntityResponse apply(GetLogAnalyticsEntityRequest request) {
                return LogAnalyticsWaiters.this.client.getLogAnalyticsEntity(request);
            }
        }, (Predicate)new Predicate<GetLogAnalyticsEntityResponse>(){

            public boolean apply(GetLogAnalyticsEntityResponse response) {
                return targetStatesSet.contains((Object)response.getLogAnalyticsEntity().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)EntityLifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetLogAnalyticsEntityTypeRequest, GetLogAnalyticsEntityTypeResponse> forLogAnalyticsEntityType(GetLogAnalyticsEntityTypeRequest request, EntityLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLogAnalyticsEntityType(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetLogAnalyticsEntityTypeRequest, GetLogAnalyticsEntityTypeResponse> forLogAnalyticsEntityType(GetLogAnalyticsEntityTypeRequest request, EntityLifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forLogAnalyticsEntityType(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetLogAnalyticsEntityTypeRequest, GetLogAnalyticsEntityTypeResponse> forLogAnalyticsEntityType(GetLogAnalyticsEntityTypeRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, EntityLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLogAnalyticsEntityType(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetLogAnalyticsEntityTypeRequest, GetLogAnalyticsEntityTypeResponse> forLogAnalyticsEntityType(BmcGenericWaiter waiter, GetLogAnalyticsEntityTypeRequest request, EntityLifecycleStates ... targetStates) {
        final HashSet<EntityLifecycleStates> targetStatesSet = new HashSet<EntityLifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetLogAnalyticsEntityTypeRequest, GetLogAnalyticsEntityTypeResponse>(){

            public GetLogAnalyticsEntityTypeResponse apply(GetLogAnalyticsEntityTypeRequest request) {
                return LogAnalyticsWaiters.this.client.getLogAnalyticsEntityType(request);
            }
        }, (Predicate)new Predicate<GetLogAnalyticsEntityTypeResponse>(){

            public boolean apply(GetLogAnalyticsEntityTypeResponse response) {
                return targetStatesSet.contains((Object)response.getLogAnalyticsEntityType().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)EntityLifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetLogAnalyticsObjectCollectionRuleRequest, GetLogAnalyticsObjectCollectionRuleResponse> forLogAnalyticsObjectCollectionRule(GetLogAnalyticsObjectCollectionRuleRequest request, ObjectCollectionRuleLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLogAnalyticsObjectCollectionRule(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetLogAnalyticsObjectCollectionRuleRequest, GetLogAnalyticsObjectCollectionRuleResponse> forLogAnalyticsObjectCollectionRule(GetLogAnalyticsObjectCollectionRuleRequest request, ObjectCollectionRuleLifecycleStates targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forLogAnalyticsObjectCollectionRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetLogAnalyticsObjectCollectionRuleRequest, GetLogAnalyticsObjectCollectionRuleResponse> forLogAnalyticsObjectCollectionRule(GetLogAnalyticsObjectCollectionRuleRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ObjectCollectionRuleLifecycleStates ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forLogAnalyticsObjectCollectionRule(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetLogAnalyticsObjectCollectionRuleRequest, GetLogAnalyticsObjectCollectionRuleResponse> forLogAnalyticsObjectCollectionRule(BmcGenericWaiter waiter, GetLogAnalyticsObjectCollectionRuleRequest request, ObjectCollectionRuleLifecycleStates ... targetStates) {
        final HashSet<ObjectCollectionRuleLifecycleStates> targetStatesSet = new HashSet<ObjectCollectionRuleLifecycleStates>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetLogAnalyticsObjectCollectionRuleRequest, GetLogAnalyticsObjectCollectionRuleResponse>(){

            public GetLogAnalyticsObjectCollectionRuleResponse apply(GetLogAnalyticsObjectCollectionRuleRequest request) {
                return LogAnalyticsWaiters.this.client.getLogAnalyticsObjectCollectionRule(request);
            }
        }, (Predicate)new Predicate<GetLogAnalyticsObjectCollectionRuleResponse>(){

            public boolean apply(GetLogAnalyticsObjectCollectionRuleResponse response) {
                return targetStatesSet.contains((Object)response.getLogAnalyticsObjectCollectionRule().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ObjectCollectionRuleLifecycleStates.Deleted)), (Object)request);
    }

    public Waiter<GetQueryWorkRequestRequest, GetQueryWorkRequestResponse> forQueryWorkRequest(GetQueryWorkRequestRequest request) {
        return this.forQueryWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetQueryWorkRequestRequest, GetQueryWorkRequestResponse> forQueryWorkRequest(GetQueryWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forQueryWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetQueryWorkRequestRequest, GetQueryWorkRequestResponse> forQueryWorkRequest(BmcGenericWaiter waiter, GetQueryWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetQueryWorkRequestRequest, GetQueryWorkRequestResponse>(){

            public GetQueryWorkRequestResponse apply(GetQueryWorkRequestRequest request) {
                return LogAnalyticsWaiters.this.client.getQueryWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetQueryWorkRequestResponse>(){

            public boolean apply(GetQueryWorkRequestResponse response) {
                return response.getQueryWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    public Waiter<GetScheduledTaskRequest, GetScheduledTaskResponse> forScheduledTask(GetScheduledTaskRequest request, ScheduledTask.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forScheduledTask(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetScheduledTaskRequest, GetScheduledTaskResponse> forScheduledTask(GetScheduledTaskRequest request, ScheduledTask.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forScheduledTask(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetScheduledTaskRequest, GetScheduledTaskResponse> forScheduledTask(GetScheduledTaskRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, ScheduledTask.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forScheduledTask(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetScheduledTaskRequest, GetScheduledTaskResponse> forScheduledTask(BmcGenericWaiter waiter, GetScheduledTaskRequest request, ScheduledTask.LifecycleState ... targetStates) {
        final HashSet<ScheduledTask.LifecycleState> targetStatesSet = new HashSet<ScheduledTask.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetScheduledTaskRequest, GetScheduledTaskResponse>(){

            public GetScheduledTaskResponse apply(GetScheduledTaskRequest request) {
                return LogAnalyticsWaiters.this.client.getScheduledTask(request);
            }
        }, (Predicate)new Predicate<GetScheduledTaskResponse>(){

            public boolean apply(GetScheduledTaskResponse response) {
                return targetStatesSet.contains((Object)response.getScheduledTask().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)ScheduledTask.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetStorageWorkRequestRequest, GetStorageWorkRequestResponse> forStorageWorkRequest(GetStorageWorkRequestRequest request) {
        return this.forStorageWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetStorageWorkRequestRequest, GetStorageWorkRequestResponse> forStorageWorkRequest(GetStorageWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forStorageWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetStorageWorkRequestRequest, GetStorageWorkRequestResponse> forStorageWorkRequest(BmcGenericWaiter waiter, GetStorageWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetStorageWorkRequestRequest, GetStorageWorkRequestResponse>(){

            public GetStorageWorkRequestResponse apply(GetStorageWorkRequestRequest request) {
                return LogAnalyticsWaiters.this.client.getStorageWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetStorageWorkRequestResponse>(){

            public boolean apply(GetStorageWorkRequestResponse response) {
                return response.getStorageWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request) {
        return this.forWorkRequest(Waiters.DEFAULT_POLLING_WAITER, request);
    }

    public Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(GetWorkRequestRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        return this.forWorkRequest(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request);
    }

    private Waiter<GetWorkRequestRequest, GetWorkRequestResponse> forWorkRequest(BmcGenericWaiter waiter, GetWorkRequestRequest request) {
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(Suppliers.ofInstance((Object)((Object)request)), (Function)new Function<GetWorkRequestRequest, GetWorkRequestResponse>(){

            public GetWorkRequestResponse apply(GetWorkRequestRequest request) {
                return LogAnalyticsWaiters.this.client.getWorkRequest(request);
            }
        }, (Predicate)new Predicate<GetWorkRequestResponse>(){

            public boolean apply(GetWorkRequestResponse response) {
                return response.getWorkRequest().getTimeFinished() != null;
            }
        }, false), (Object)request);
    }

    @ConstructorProperties(value={"executorService", "client"})
    public LogAnalyticsWaiters(ExecutorService executorService, LogAnalytics client) {
        this.executorService = executorService;
        this.client = client;
    }
}

