/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.loganalytics.model.StorageWorkRequest;
import com.oracle.bmc.loganalytics.requests.GetStorageWorkRequestRequest;
import com.oracle.bmc.loganalytics.responses.GetStorageWorkRequestResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetStorageWorkRequestConverter {
    private static final Logger LOG = LoggerFactory.getLogger(GetStorageWorkRequestConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static GetStorageWorkRequestRequest interceptRequest(GetStorageWorkRequestRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, GetStorageWorkRequestRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getWorkRequestId(), (String)"workRequestId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200601").path("namespaces").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("storageWorkRequests").path(HttpUtils.encodePathSegment((String)request.getWorkRequestId()));
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, GetStorageWorkRequestResponse> fromResponse() {
        Function<Response, GetStorageWorkRequestResponse> transformer = new Function<Response, GetStorageWorkRequestResponse>(){

            public GetStorageWorkRequestResponse apply(Response rawResponse) {
                Optional retryAfterHeader;
                Optional etagHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.loganalytics.responses.GetStorageWorkRequestResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(StorageWorkRequest.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                GetStorageWorkRequestResponse.Builder builder = GetStorageWorkRequestResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.storageWorkRequest((StorageWorkRequest)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((etagHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"etag")).isPresent()) {
                    builder.etag((String)HeaderUtils.toValue((String)"etag", (String)((String)((List)etagHeader.get()).get(0)), String.class));
                }
                if ((retryAfterHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"retry-after")).isPresent()) {
                    builder.retryAfter((Float)HeaderUtils.toValue((String)"retry-after", (String)((String)((List)retryAfterHeader.get()).get(0)), Float.class));
                }
                GetStorageWorkRequestResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

