/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.loganalytics.model.LogAnalyticsImportCustomContent;
import com.oracle.bmc.loganalytics.requests.ImportCustomContentRequest;
import com.oracle.bmc.loganalytics.responses.ImportCustomContentResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportCustomContentConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ImportCustomContentConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ImportCustomContentRequest interceptRequest(ImportCustomContentRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ImportCustomContentRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getImportCustomContentFileBody(), (String)"importCustomContentFileBody is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200601").path("namespaces").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("contents").path("actions").path("importCustomContent");
        if (request.getIsOverwrite() != null) {
            target = target.queryParam("isOverwrite", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsOverwrite())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRetryToken() != null) {
            ib.header("opc-retry-token", (Object)request.getOpcRetryToken());
        }
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ImportCustomContentResponse> fromResponse() {
        Function<Response, ImportCustomContentResponse> transformer = new Function<Response, ImportCustomContentResponse>(){

            public ImportCustomContentResponse apply(Response rawResponse) {
                LOG.trace("Transform function invoked for com.oracle.bmc.loganalytics.responses.ImportCustomContentResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(LogAnalyticsImportCustomContent.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ImportCustomContentResponse.Builder builder = ImportCustomContentResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.logAnalyticsImportCustomContent((LogAnalyticsImportCustomContent)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ImportCustomContentResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

