/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.loganalytics.model.LogAnalyticsFieldCollection;
import com.oracle.bmc.loganalytics.requests.ListFieldsRequest;
import com.oracle.bmc.loganalytics.responses.ListFieldsResponse;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListFieldsConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListFieldsConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListFieldsRequest interceptRequest(ListFieldsRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListFieldsRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200601").path("namespaces").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("fields");
        if (request.getIsMatchAll() != null) {
            target = target.queryParam("isMatchAll", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsMatchAll())});
        }
        if (request.getSourceIds() != null) {
            target = target.queryParam("sourceIds", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSourceIds())});
        }
        if (request.getSourceNames() != null) {
            target = target.queryParam("sourceNames", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSourceNames())});
        }
        if (request.getParserType() != null) {
            target = target.queryParam("parserType", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getParserType().getValue())});
        }
        if (request.getParserIds() != null) {
            target = target.queryParam("parserIds", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getParserIds())});
        }
        if (request.getParserNames() != null) {
            target = target.queryParam("parserNames", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getParserNames())});
        }
        if (request.getIsIncludeParser() != null) {
            target = target.queryParam("isIncludeParser", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsIncludeParser())});
        }
        if (request.getFilter() != null) {
            target = target.queryParam("filter", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getFilter())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListFieldsResponse> fromResponse() {
        Function<Response, ListFieldsResponse> transformer = new Function<Response, ListFieldsResponse>(){

            public ListFieldsResponse apply(Response rawResponse) {
                Optional opcRequestIdHeader;
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.loganalytics.responses.ListFieldsResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(LogAnalyticsFieldCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListFieldsResponse.Builder builder = ListFieldsResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.logAnalyticsFieldCollection((LogAnalyticsFieldCollection)response.getItem());
                Optional opcPrevPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-prev-page");
                if (opcPrevPageHeader.isPresent()) {
                    builder.opcPrevPage((String)HeaderUtils.toValue((String)"opc-prev-page", (String)((String)((List)opcPrevPageHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                if ((opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id")).isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                ListFieldsResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

