/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.loganalytics.internal.http;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.oracle.bmc.http.internal.HeaderUtils;
import com.oracle.bmc.http.internal.ResponseConversionFunctionFactory;
import com.oracle.bmc.http.internal.ResponseHelper;
import com.oracle.bmc.http.internal.RestClient;
import com.oracle.bmc.http.internal.WithHeaders;
import com.oracle.bmc.http.internal.WrappedInvocationBuilder;
import com.oracle.bmc.http.internal.WrappedWebTarget;
import com.oracle.bmc.loganalytics.model.LogAnalyticsEntityCollection;
import com.oracle.bmc.loganalytics.requests.ListLogAnalyticsEntitiesRequest;
import com.oracle.bmc.loganalytics.responses.ListLogAnalyticsEntitiesResponse;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.HttpUtils;
import java.util.List;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListLogAnalyticsEntitiesConverter {
    private static final Logger LOG = LoggerFactory.getLogger(ListLogAnalyticsEntitiesConverter.class);
    private static final ResponseConversionFunctionFactory RESPONSE_CONVERSION_FACTORY = new ResponseConversionFunctionFactory();

    public static ListLogAnalyticsEntitiesRequest interceptRequest(ListLogAnalyticsEntitiesRequest request) {
        return request;
    }

    public static WrappedInvocationBuilder fromRequest(RestClient client, ListLogAnalyticsEntitiesRequest request) {
        Validate.notNull((Object)((Object)request), (String)"request instance is required", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)request.getNamespaceName(), (String)"namespaceName must not be blank", (Object[])new Object[0]);
        Validate.notNull((Object)request.getCompartmentId(), (String)"compartmentId is required", (Object[])new Object[0]);
        WrappedWebTarget target = client.getBaseTarget().path("/20200601").path("namespaces").path(HttpUtils.encodePathSegment((String)request.getNamespaceName())).path("logAnalyticsEntities");
        target = target.queryParam("compartmentId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCompartmentId())});
        if (request.getName() != null) {
            target = target.queryParam("name", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getName())});
        }
        if (request.getNameContains() != null) {
            target = target.queryParam("nameContains", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getNameContains())});
        }
        if (request.getEntityTypeName() != null) {
            target = HttpUtils.encodeCollectionFormatQueryParam((WrappedWebTarget)target, (String)"entityTypeName", request.getEntityTypeName(), (CollectionFormatType)CollectionFormatType.Multi);
        }
        if (request.getCloudResourceId() != null) {
            target = target.queryParam("cloudResourceId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getCloudResourceId())});
        }
        if (request.getLifecycleState() != null) {
            target = target.queryParam("lifecycleState", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleState().getValue())});
        }
        if (request.getLifecycleDetailsContains() != null) {
            target = target.queryParam("lifecycleDetailsContains", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLifecycleDetailsContains())});
        }
        if (request.getIsManagementAgentIdNull() != null) {
            target = target.queryParam("isManagementAgentIdNull", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getIsManagementAgentIdNull().getValue())});
        }
        if (request.getHostname() != null) {
            target = target.queryParam("hostname", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getHostname())});
        }
        if (request.getHostnameContains() != null) {
            target = target.queryParam("hostnameContains", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getHostnameContains())});
        }
        if (request.getSourceId() != null) {
            target = target.queryParam("sourceId", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSourceId())});
        }
        if (request.getLimit() != null) {
            target = target.queryParam("limit", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getLimit())});
        }
        if (request.getPage() != null) {
            target = target.queryParam("page", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getPage())});
        }
        if (request.getSortOrder() != null) {
            target = target.queryParam("sortOrder", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortOrder().getValue())});
        }
        if (request.getSortBy() != null) {
            target = target.queryParam("sortBy", new Object[]{HttpUtils.attemptEncodeQueryParam((Object)request.getSortBy().getValue())});
        }
        WrappedInvocationBuilder ib = target.request();
        ib.accept(new String[]{"application/json"});
        if (request.getOpcRequestId() != null) {
            ib.header("opc-request-id", (Object)request.getOpcRequestId());
        }
        return ib;
    }

    public static Function<Response, ListLogAnalyticsEntitiesResponse> fromResponse() {
        Function<Response, ListLogAnalyticsEntitiesResponse> transformer = new Function<Response, ListLogAnalyticsEntitiesResponse>(){

            public ListLogAnalyticsEntitiesResponse apply(Response rawResponse) {
                Optional opcNextPageHeader;
                LOG.trace("Transform function invoked for com.oracle.bmc.loganalytics.responses.ListLogAnalyticsEntitiesResponse");
                Function responseFn = RESPONSE_CONVERSION_FACTORY.create(LogAnalyticsEntityCollection.class);
                WithHeaders response = (WithHeaders)responseFn.apply((Object)rawResponse);
                MultivaluedMap headers = response.getHeaders();
                ListLogAnalyticsEntitiesResponse.Builder builder = ListLogAnalyticsEntitiesResponse.builder().__httpStatusCode__(rawResponse.getStatus());
                builder.logAnalyticsEntityCollection((LogAnalyticsEntityCollection)response.getItem());
                Optional opcRequestIdHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-request-id");
                if (opcRequestIdHeader.isPresent()) {
                    builder.opcRequestId((String)HeaderUtils.toValue((String)"opc-request-id", (String)((String)((List)opcRequestIdHeader.get()).get(0)), String.class));
                }
                if ((opcNextPageHeader = HeaderUtils.get((MultivaluedMap)headers, (String)"opc-next-page")).isPresent()) {
                    builder.opcNextPage((String)HeaderUtils.toValue((String)"opc-next-page", (String)((String)((List)opcNextPageHeader.get()).get(0)), String.class));
                }
                ListLogAnalyticsEntitiesResponse responseWrapper = builder.build();
                ResponseHelper.closeResponseSilentlyIfNotBuffered((Response)rawResponse);
                return responseWrapper;
            }
        };
        return transformer;
    }
}

